/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.Breakout;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.Heading;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Expand
extends AbstractContentNode<Expand, NonNestableBlockContent>
implements Marked<Expand, Breakout>,
DocContent,
LayoutColumnContent {
    static final Factory<Expand> FACTORY = new Factory<Expand>("expand", Expand.class, Expand::parse);
    private final MarkHolder<Breakout> marks = MarkHolder.unlimited();
    @Nullable
    private String title;

    private Expand() {
    }

    public static Expand expand() {
        return new Expand();
    }

    public static Expand expand(NonNestableBlockContent content) {
        return (Expand)Expand.expand().content(content);
    }

    public static Expand expand(NonNestableBlockContent ... content) {
        return (Expand)Expand.expand().content(content);
    }

    public static Expand expand(Iterable<? extends NonNestableBlockContent> content) {
        return (Expand)Expand.expand().content(content);
    }

    public static Expand expand(Stream<? extends NonNestableBlockContent> content) {
        return (Expand)Expand.expand().content(content);
    }

    public Optional<String> title() {
        return Optional.ofNullable(this.title);
    }

    public Expand title(String title) {
        this.title = title;
        return this;
    }

    @Override
    public Collection<Breakout> marks() {
        return this.marks.get();
    }

    @Override
    public Set<String> markTypes() {
        return this.marks.getTypes();
    }

    @Override
    public <T extends Breakout> Stream<? extends T> marks(Class<T> markClass) {
        return this.marks.stream(markClass);
    }

    @Override
    public Expand mark(Breakout mark) {
        this.marks.add(mark);
        return this;
    }

    @Override
    public String elementType() {
        return "expand";
    }

    @Override
    public void validate() {
        this.requireNotEmpty();
        super.validate();
    }

    @Override
    protected void validateContentNodeForAppend(NonNestableBlockContent node) {
        super.validateContentNodeForAppend(node);
        if (node instanceof Paragraph) {
            ((Paragraph)node).disableMarks(this);
        } else if (node instanceof Heading) {
            ((Heading)node).disableMarks(this);
        } else if (node instanceof CodeBlock) {
            ((CodeBlock)node).disableMarks(this);
        }
    }

    public Optional<Breakout> breakout() {
        return this.marks.stream(Breakout.class).findAny();
    }

    public Expand breakout(@Nullable Breakout breakout) {
        this.marks.clear();
        if (breakout != null) {
            this.marks.add(breakout);
        }
        return this;
    }

    public Expand wide() {
        return this.breakout(Breakout.wide());
    }

    public Expand fullWidth() {
        return this.breakout(Breakout.fullWidth());
    }

    public Expand defaultWidth() {
        return this.breakout(null);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expand other = (Expand)o;
        return Objects.equals(this.title, other.title) && this.marks.equals(other.marks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.marks, this.title);
    }

    void disableMarks(ContentNode<?, ?> parent) {
        this.marks.disable(parent.elementType());
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().let(this::addContent).add("attrs", FieldMap.map().addIfPresent("title", this.title)).let(this.marks::addToMap);
    }

    private static Expand parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "expand");
        Expand expand = (Expand)new Expand().parseRequiredContent(map, NonNestableBlockContent.class);
        ParserSupport.getOrThrow(map, "attrs");
        ParserSupport.getAttr(map, "title", String.class).ifPresent(expand::title);
        MarkParserSupport.parseBreakoutMark(map, expand);
        return expand;
    }
}

