/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.jackson2;

import com.atlassian.adf.model.node.Doc;
import com.atlassian.adf.parser.AdfParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

public class AdfJackson2
implements AdfParser<String> {
    private static final TypeReference<Map<String, Object>> TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final ObjectMapper MAPPER = new ObjectMapper();

    public String marshall(Doc doc) {
        Map map = doc.toMap();
        try {
            return this.MAPPER.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Invalid JSON output", e);
        }
    }

    public Doc unmarshall(String json) {
        Map map;
        try {
            map = (Map)this.MAPPER.readValue(json, TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid JSON input", e);
        }
        return Doc.parse((Map)map);
    }

    public AdfParser<JsonNode> useJsonNode() {
        return new UseJsonNode();
    }

    private class UseJsonNode
    implements AdfParser<JsonNode> {
        private UseJsonNode() {
        }

        public JsonNode marshall(Doc doc) {
            Map map = doc.toMap();
            return AdfJackson2.this.MAPPER.valueToTree((Object)map);
        }

        public Doc unmarshall(JsonNode json) {
            if (!json.isObject()) {
                throw new IllegalArgumentException("Invalid JSON input: " + json.asToken());
            }
            Map map = (Map)AdfJackson2.this.MAPPER.convertValue((Object)json, TYPE_REFERENCE);
            return Doc.parse((Map)map);
        }
    }
}

