package com.atlassian.activeobjects.spi;

import com.atlassian.tenancy.api.Tenant;

import javax.annotation.Nonnull;

/**
 * This class provides a partial implementation of the {@link TenantAwareDataSourceProvider}
 * where {@link #getDatabaseType(Tenant)} always returns {@link com.atlassian.activeobjects.spi.DatabaseType#UNKNOWN}.
 */
public abstract class AbstractTenantAwareDataSourceProvider implements TenantAwareDataSourceProvider {
    /**
     * Always returns com.atlassian.activeobjects.spi.DatabaseType#UNKNOWN
     *
     * @return {@link com.atlassian.activeobjects.spi.DatabaseType#UNKNOWN}
     */
    @Override
    @Nonnull
    public DatabaseType getDatabaseType(@Nonnull final Tenant tenant) {
        return DatabaseType.UNKNOWN;
    }

    @Override
    public String getSchema(@Nonnull final Tenant tenant) {
        return null; // use the default schema configured for the user
    }
}
