/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.selenium_shutterbug.utils.file;

import com.assertthat.selenium_shutterbug.utils.file.UnableSaveSnapshotException;
import com.assertthat.selenium_shutterbug.utils.web.UnableTakeSnapshotException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static String getJsScript(String filePath) {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            if (is == null) {
                is = FileUtil.class.getClassLoader().getResourceAsStream(filePath);
            }
            if (is == null) {
                new UnableTakeSnapshotException("Unable to load JS script, unable to locate resource stream.");
            }
            return IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            throw new UnableTakeSnapshotException("Unable to load JS script", e);
        }
    }

    public static void writeImage(BufferedImage imageFile, String extension, File fileToWriteTo) {
        try {
            ImageIO.write((RenderedImage)imageFile, extension, fileToWriteTo);
        }
        catch (IOException e) {
            throw new UnableSaveSnapshotException(e);
        }
    }
}

