/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.client;

import com.aspose.words.client.ApiException;
import com.aspose.words.client.ApiInvokerResponse;
import com.aspose.words.model.ResponseMessage;
import com.google.gson.Gson;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class ApiInvoker {
    private static ApiInvoker INSTANCE = new ApiInvoker();
    private Map<String, Client> hostMap = new HashMap<String, Client>();
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private boolean isDebug = false;
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    public final String APP_SID = "appSid";
    public final String API_KEY = "apiKey";

    public void enableDebug() {
        this.isDebug = true;
    }

    public static ApiInvoker getInstance() {
        return INSTANCE;
    }

    public void addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
    }

    public static String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static Object deserialize(ApiInvokerResponse aiResponse, String containerType, Class cls) throws ApiException {
        String json = "";
        try {
            if (cls.isInstance(new ResponseMessage())) {
                ResponseMessage rm = new ResponseMessage();
                rm.setStatus("OK");
                rm.setCode(200);
                if (aiResponse.getInputStream() != null) {
                    rm.setInputStream(aiResponse.getInputStream());
                }
                return rm;
            }
            json = IOUtils.toString((InputStream)aiResponse.getInputStream());
            if (String.class.equals((Object)cls)) {
                if (json != null && json.startsWith("\"") && json.endsWith("\"") && json.length() > 1) {
                    return json.substring(1, json.length() - 2);
                }
                return json;
            }
            Gson gson = new Gson();
            return gson.fromJson(json, cls);
        }
        catch (IOException e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public static String serialize(Object obj) throws ApiException {
        try {
            if (obj != null) {
                Gson gson = new Gson();
                return gson.toJson(obj);
            }
            throw new ApiException(500, "No object found");
        }
        catch (Exception e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public boolean SaveStreamToFile(String FileNameWithPath, InputStream inputStream) {
        try {
            FileOutputStream out = new FileOutputStream(new File(FileNameWithPath));
            int read = 0;
            byte[] bytes = new byte[8192];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            inputStream.close();
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String Sign(String unsignedURL, String privateKey) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(new SecretKeySpec(privateKey.getBytes(), HMAC_SHA1_ALGORITHM));
            String signature = new String(Base64.encodeBase64((byte[])mac.doFinal(unsignedURL.getBytes())));
            if (signature.endsWith("=")) {
                signature = signature.substring(0, signature.length() - 1);
            }
            return URLEncoder.encode(signature, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ApiInvokerResponse invokeAPI(String host, String resourceURL, String method, Map<String, String> queryParams, Object body, Map<String, String> headerParams, Map<String, String> formParams, String contentType) throws ApiException {
        Client client = this.getClient(host);
        ApiInvokerResponse aiResponse = new ApiInvokerResponse("", null);
        resourceURL = resourceURL.replace("{appSid}", this.defaultHeaderMap.get("appSid"));
        resourceURL = resourceURL.replaceAll("\\{\\w*\\}", "");
        StringBuilder resourceURLBuilder = new StringBuilder(host).append(resourceURL);
        String signature = ApiInvoker.Sign(resourceURLBuilder.toString(), this.defaultHeaderMap.get("apiKey"));
        resourceURLBuilder.append("&signature=").append(signature);
        WebResource.Builder builder = client.resource(resourceURLBuilder.toString()).accept(new String[]{"application/json"});
        for (String key : headerParams.keySet()) {
            builder.header(key, (Object)headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder.header(key, (Object)this.defaultHeaderMap.get(key));
        }
        ClientResponse response = null;
        if ("GET".equals(method)) {
            response = (ClientResponse)builder.get(ClientResponse.class);
        } else if ("POST".equals(method)) {
            response = body == null ? (ClientResponse)builder.post(ClientResponse.class, null) : (body instanceof FormDataMultiPart ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, body) : (contentType.equalsIgnoreCase("application/json") ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)ApiInvoker.serialize(body)) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, body)));
        } else if ("PUT".equals(method)) {
            if (body == null) {
                response = (ClientResponse)builder.put(ClientResponse.class);
            } else if ("application/x-www-form-urlencoded".equals(contentType)) {
                StringBuilder formParamBuilder = new StringBuilder();
                for (String key : formParams.keySet()) {
                    String value = formParams.get(key);
                    if (value == null || "".equals(value.trim())) continue;
                    if (formParamBuilder.length() > 0) {
                        formParamBuilder.append("&");
                    }
                    try {
                        formParamBuilder.append(URLEncoder.encode(key, "utf8")).append("=").append(URLEncoder.encode(value, "utf8"));
                    }
                    catch (Exception e) {}
                }
                response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)formParamBuilder.toString());
            } else if (body instanceof FormDataMultiPart) {
                FormDataMultiPart form = (FormDataMultiPart)body;
                response = (ClientResponse)((WebResource.Builder)builder.type(MediaType.MULTIPART_FORM_DATA_TYPE)).put(ClientResponse.class, (Object)form);
            } else {
                response = contentType.equalsIgnoreCase("application/json") ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)ApiInvoker.serialize(body)) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, body);
            }
        } else if ("DELETE".equals(method)) {
            response = body == null ? (ClientResponse)builder.delete(ClientResponse.class) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)ApiInvoker.serialize(body));
        } else {
            throw new ApiException(500, "unknown method type " + method);
        }
        if (response.getClientResponseStatus() == ClientResponse.Status.NO_CONTENT) {
            throw new ApiException(500, "No contents found");
        }
        if (response.getClientResponseStatus().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (response.getEntityInputStream() != null) {
                aiResponse.setInputStream(response.getEntityInputStream());
            } else {
                aiResponse.setJson((String)response.getEntity(String.class));
            }
            return aiResponse;
        }
        throw new ApiException(response.getClientResponseStatus().getStatusCode(), (String)response.getEntity(String.class));
    }

    private Client getClient(String host) {
        if (!this.hostMap.containsKey(host)) {
            Client client = Client.create();
            if (this.isDebug) {
                client.addFilter((ClientFilter)new LoggingFilter());
            }
            this.hostMap.put(host, client);
        }
        return this.hostMap.get(host);
    }

    public String toPathValue(String value) {
        return value == null ? "" : value;
    }

    public String toPathValue(Integer value) {
        return value.toString();
    }

    public String toPathValue(Float value) {
        return value.toString();
    }

    public String toPathValue(Long value) {
        return value.toString();
    }

    public String toPathValue(Boolean value) {
        return value.toString();
    }

    public String toPathValue(Double value) {
        return value.toString();
    }

    public String toPathValue(Date value) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(value);
    }
}

