/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.api;

import com.aspose.words.client.ApiException;
import com.aspose.words.client.ApiInvoker;
import com.aspose.words.client.ApiInvokerResponse;
import com.aspose.words.model.BookmarkData;
import com.aspose.words.model.BookmarkResponse;
import com.aspose.words.model.BookmarksResponse;
import com.aspose.words.model.DocumentEntryList;
import com.aspose.words.model.DocumentPropertiesResponse;
import com.aspose.words.model.DocumentProperty;
import com.aspose.words.model.DocumentPropertyResponse;
import com.aspose.words.model.DocumentResponse;
import com.aspose.words.model.DrawingObjectResponse;
import com.aspose.words.model.DrawingObjectsResponse;
import com.aspose.words.model.FieldNamesResponse;
import com.aspose.words.model.Font;
import com.aspose.words.model.FontResponse;
import com.aspose.words.model.FormField;
import com.aspose.words.model.FormFieldResponse;
import com.aspose.words.model.HyperlinkResponse;
import com.aspose.words.model.HyperlinksResponse;
import com.aspose.words.model.LoadWebDocumentData;
import com.aspose.words.model.PageNumber;
import com.aspose.words.model.PageSetup;
import com.aspose.words.model.ParagraphLinkCollectionResponse;
import com.aspose.words.model.ParagraphResponse;
import com.aspose.words.model.ProtectionDataResponse;
import com.aspose.words.model.ProtectionRequest;
import com.aspose.words.model.ReplaceTextRequest;
import com.aspose.words.model.ReplaceTextResponse;
import com.aspose.words.model.ResponseMessage;
import com.aspose.words.model.RevisionsModificationResponse;
import com.aspose.words.model.RunResponse;
import com.aspose.words.model.SaaSposeResponse;
import com.aspose.words.model.SaveResponse;
import com.aspose.words.model.SectionLinkCollectionResponse;
import com.aspose.words.model.SectionPageSetupResponse;
import com.aspose.words.model.SectionResponse;
import com.aspose.words.model.SplitDocumentResponse;
import com.aspose.words.model.StatDataResponse;
import com.aspose.words.model.TextItemsResponse;
import com.aspose.words.model.TiffSaveOptionsData;
import com.aspose.words.model.WatermarkText;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;

public class WordsApi {
    String basePath = "http://api.aspose.com/v1.1";
    ApiInvoker apiInvoker = ApiInvoker.getInstance();
    ApiInvokerResponse response = null;

    public WordsApi(String basePath, String apiKey, String appSid) {
        this.basePath = basePath;
        this.apiInvoker.addDefaultHeader(this.apiInvoker.API_KEY, apiKey);
        this.apiInvoker.addDefaultHeader(this.apiInvoker.APP_SID, appSid);
    }

    public WordsApi(String basePath, String apiKey, String appSid, boolean isDebug) {
        this.basePath = basePath;
        this.apiInvoker.addDefaultHeader(this.apiInvoker.API_KEY, apiKey);
        this.apiInvoker.addDefaultHeader(this.apiInvoker.APP_SID, appSid);
        if (isDebug) {
            this.apiInvoker.enableDebug();
        }
    }

    public WordsApi(String apiKey, String appSid) {
        this.apiInvoker.addDefaultHeader(this.apiInvoker.API_KEY, apiKey);
        this.apiInvoker.addDefaultHeader(this.apiInvoker.APP_SID, appSid);
    }

    public WordsApi(String apiKey, String appSid, boolean isDebug) {
        this.apiInvoker.addDefaultHeader(this.apiInvoker.API_KEY, apiKey);
        this.apiInvoker.addDefaultHeader(this.apiInvoker.APP_SID, appSid);
        if (isDebug) {
            this.apiInvoker.enableDebug();
        }
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public BookmarkResponse GetDocumentBookmarkByName(String name, String bookmarkName, String storage, String folder) {
        Object postBody = null;
        if (name == null || bookmarkName == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/bookmarks/{bookmarkName}/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = bookmarkName != null ? resourcePath.replace("{bookmarkName}", this.apiInvoker.toPathValue(bookmarkName)) : resourcePath.replaceAll("[&?]bookmarkName.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (BookmarkResponse)ApiInvoker.deserialize(this.response, "", BookmarkResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public BookmarksResponse GetDocumentBookmarks(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/bookmarks/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (BookmarksResponse)ApiInvoker.deserialize(this.response, "", BookmarksResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public BookmarkResponse PostUpdateDocumentBookmark(String name, String bookmarkName, String filename, String storage, String folder, BookmarkData body) {
        BookmarkData postBody = body;
        if (name == null || bookmarkName == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/bookmarks/{bookmarkName}/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = bookmarkName != null ? resourcePath.replace("{bookmarkName}", this.apiInvoker.toPathValue(bookmarkName)) : resourcePath.replaceAll("[&?]bookmarkName.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (BookmarkResponse)ApiInvoker.deserialize(this.response, "", BookmarkResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage GetDocument(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage GetDocumentWithFormat(String name, String format, String storage, String folder, String outPath) {
        Object postBody = null;
        if (name == null || format == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/?appSid={appSid}&amp;toFormat={toFormat}&amp;storage={storage}&amp;folder={folder}&amp;outPath={outPath}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = format != null ? resourcePath.replace("{format}", this.apiInvoker.toPathValue(format)) : resourcePath.replaceAll("[&?]format.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        resourcePath = outPath != null ? resourcePath.replace("{outPath}", this.apiInvoker.toPathValue(outPath)) : resourcePath.replaceAll("[&?]outPath.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentResponse PostAppendDocument(String name, String filename, String storage, String folder, DocumentEntryList body) {
        DocumentEntryList postBody = body;
        if (name == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/appendDocument/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentResponse)ApiInvoker.deserialize(this.response, "", DocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentResponse PostExecuteTemplate(String name, String cleanup, String filename, String storage, String folder, Boolean useWholeParagraphAsRegion, Boolean withRegions, File file) {
        String contentType;
        File postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/executeTemplate/?appSid={appSid}&amp;cleanup={cleanup}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}&amp;useWholeParagraphAsRegion={useWholeParagraphAsRegion}&amp;withRegions={withRegions}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = cleanup != null ? resourcePath.replace("{cleanup}", this.apiInvoker.toPathValue(cleanup)) : resourcePath.replaceAll("[&?]cleanup.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        resourcePath = useWholeParagraphAsRegion != null ? resourcePath.replace("{useWholeParagraphAsRegion}", this.apiInvoker.toPathValue(useWholeParagraphAsRegion)) : resourcePath.replaceAll("[&?]useWholeParagraphAsRegion.*?(?=&|\\?|$)", "");
        resourcePath = withRegions != null ? resourcePath.replace("{withRegions}", this.apiInvoker.toPathValue(withRegions)) : resourcePath.replaceAll("[&?]withRegions.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/xml"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (file != null) {
            postBody = file;
        }
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentResponse)ApiInvoker.deserialize(this.response, "", DocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentResponse PostInsertPageNumbers(String name, String filename, String storage, String folder, PageNumber body) {
        PageNumber postBody = body;
        if (name == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/insertPageNumbers/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentResponse)ApiInvoker.deserialize(this.response, "", DocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaveResponse PostLoadWebDocument(LoadWebDocumentData body) {
        if (body == null) {
            throw new ApiException(400, "missing required params");
        }
        LoadWebDocumentData postBody = body;
        String resourcePath = "/words/loadWebDocument/?appSid={appSid}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (SaveResponse)ApiInvoker.deserialize(this.response, "", SaveResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage PostRunTask() {
        Object postBody = null;
        String resourcePath = "/words/tasks/?appSid={appSid}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SplitDocumentResponse PostSplitDocument(String name, String format, Integer from, Integer to, Boolean zipOutput, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/split/?appSid={appSid}&amp;toFormat={toFormat}&amp;from={from}&amp;to={to}&amp;zipOutput={zipOutput}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = format != null ? resourcePath.replace("{format}", this.apiInvoker.toPathValue(format)) : resourcePath.replaceAll("[&?]format.*?(?=&|\\?|$)", "");
        resourcePath = from != null ? resourcePath.replace("{from}", this.apiInvoker.toPathValue(from)) : resourcePath.replaceAll("[&?]from.*?(?=&|\\?|$)", "");
        resourcePath = to != null ? resourcePath.replace("{to}", this.apiInvoker.toPathValue(to)) : resourcePath.replaceAll("[&?]to.*?(?=&|\\?|$)", "");
        resourcePath = zipOutput != null ? resourcePath.replace("{zipOutput}", this.apiInvoker.toPathValue(zipOutput)) : resourcePath.replaceAll("[&?]zipOutput.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (SplitDocumentResponse)ApiInvoker.deserialize(this.response, "", SplitDocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage PutConvertDocument(String format, String outPath, File file) {
        String contentType;
        FormDataMultiPart postBody = null;
        if (file == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/convert/?appSid={appSid}&amp;toFormat={toFormat}&amp;outPath={outPath}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = format != null ? resourcePath.replace("{format}", this.apiInvoker.toPathValue(format)) : resourcePath.replaceAll("[&?]format.*?(?=&|\\?|$)", "");
        resourcePath = outPath != null ? resourcePath.replace("{outPath}", this.apiInvoker.toPathValue(outPath)) : resourcePath.replaceAll("[&?]outPath.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"multipart/form-data"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.field("file", (Object)file, MediaType.MULTIPART_FORM_DATA_TYPE);
            postBody = mp;
        }
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public FieldNamesResponse PutDocumentFieldNames(Boolean useNonMergeFields) {
        Object postBody = null;
        String resourcePath = "/words/mailMergeFieldNames/?appSid={appSid}&amp;useNonMergeFields={useNonMergeFields}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = useNonMergeFields != null ? resourcePath.replace("{useNonMergeFields}", this.apiInvoker.toPathValue(useNonMergeFields)) : resourcePath.replaceAll("[&?]useNonMergeFields.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (FieldNamesResponse)ApiInvoker.deserialize(this.response, "", FieldNamesResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage PutExecuteMailMergeOnline(Boolean withRegions, String cleanup, File file, File data) {
        String contentType;
        FormDataMultiPart postBody = null;
        if (withRegions == null || file == null || data == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/executeMailMerge/?withRegions={withRegions}&amp;appSid={appSid}&amp;cleanup={cleanup}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = withRegions != null ? resourcePath.replace("{withRegions}", this.apiInvoker.toPathValue(withRegions)) : resourcePath.replaceAll("[&?]withRegions.*?(?=&|\\?|$)", "");
        resourcePath = cleanup != null ? resourcePath.replace("{cleanup}", this.apiInvoker.toPathValue(cleanup)) : resourcePath.replaceAll("[&?]cleanup.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"multipart/form-data"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.field("file", (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            mp.field("data", (Object)data, MediaType.APPLICATION_XML_TYPE);
            postBody = mp;
        }
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage PutExecuteTemplateOnline(String cleanup, Boolean useWholeParagraphAsRegion, Boolean withRegions, File file) {
        String contentType;
        FormDataMultiPart postBody = null;
        if (file == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/executeTemplate/?appSid={appSid}&amp;cleanup={cleanup}&amp;useWholeParagraphAsRegion={useWholeParagraphAsRegion}&amp;withRegions={withRegions}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = cleanup != null ? resourcePath.replace("{cleanup}", this.apiInvoker.toPathValue(cleanup)) : resourcePath.replaceAll("[&?]cleanup.*?(?=&|\\?|$)", "");
        resourcePath = useWholeParagraphAsRegion != null ? resourcePath.replace("{useWholeParagraphAsRegion}", this.apiInvoker.toPathValue(useWholeParagraphAsRegion)) : resourcePath.replaceAll("[&?]useWholeParagraphAsRegion.*?(?=&|\\?|$)", "");
        resourcePath = withRegions != null ? resourcePath.replace("{withRegions}", this.apiInvoker.toPathValue(withRegions)) : resourcePath.replaceAll("[&?]withRegions.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"multipart/form-data"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.field("file", (Object)file, MediaType.MULTIPART_FORM_DATA_TYPE);
            postBody = mp;
        }
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaaSposeResponse DeleteDocumentFields(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/fields/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (SaaSposeResponse)ApiInvoker.deserialize(this.response, "", SaaSposeResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentResponse PostUpdateDocumentFields(String name, String filename, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/updateFields/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentResponse)ApiInvoker.deserialize(this.response, "", DocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaaSposeResponse DeleteDocumentProperty(String name, String propertyName, String filename, String storage, String folder) {
        Object postBody = null;
        if (name == null || propertyName == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/documentProperties/{propertyName}/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = propertyName != null ? resourcePath.replace("{propertyName}", this.apiInvoker.toPathValue(propertyName)) : resourcePath.replaceAll("[&?]propertyName.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (SaaSposeResponse)ApiInvoker.deserialize(this.response, "", SaaSposeResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentPropertiesResponse GetDocumentProperties(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/documentProperties/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentPropertiesResponse)ApiInvoker.deserialize(this.response, "", DocumentPropertiesResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentPropertyResponse GetDocumentProperty(String name, String propertyName, String storage, String folder) {
        Object postBody = null;
        if (name == null || propertyName == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/documentProperties/{propertyName}/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = propertyName != null ? resourcePath.replace("{propertyName}", this.apiInvoker.toPathValue(propertyName)) : resourcePath.replaceAll("[&?]propertyName.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentPropertyResponse)ApiInvoker.deserialize(this.response, "", DocumentPropertyResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentPropertyResponse PutUpdateDocumentProperty(String name, String propertyName, String filename, String storage, String folder, DocumentProperty body) {
        DocumentProperty postBody = body;
        if (name == null || propertyName == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/documentProperties/{propertyName}/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = propertyName != null ? resourcePath.replace("{propertyName}", this.apiInvoker.toPathValue(propertyName)) : resourcePath.replaceAll("[&?]propertyName.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentPropertyResponse)ApiInvoker.deserialize(this.response, "", DocumentPropertyResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ProtectionDataResponse DeleteUnprotectDocument(String name, String filename, String storage, String folder, ProtectionRequest body) {
        ProtectionRequest postBody = body;
        if (name == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/protection/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (ProtectionDataResponse)ApiInvoker.deserialize(this.response, "", ProtectionDataResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ProtectionDataResponse GetDocumentProtection(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/protection/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (ProtectionDataResponse)ApiInvoker.deserialize(this.response, "", ProtectionDataResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ProtectionDataResponse PostChangeDocumentProtection(String name, String filename, String storage, String folder, ProtectionRequest body) {
        ProtectionRequest postBody = body;
        if (name == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/protection/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (ProtectionDataResponse)ApiInvoker.deserialize(this.response, "", ProtectionDataResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ProtectionDataResponse PutProtectDocument(String name, String filename, String storage, String folder, ProtectionRequest body) {
        ProtectionRequest postBody = body;
        if (name == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/protection/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (ProtectionDataResponse)ApiInvoker.deserialize(this.response, "", ProtectionDataResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaveResponse PostDocumentSaveAs(String name, String storage, String folder, Object body) {
        Object postBody = body;
        if (name == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/SaveAs/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/xml"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (SaveResponse)ApiInvoker.deserialize(this.response, "", SaveResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaveResponse PutDocumentSaveAsTiff(String name, String resultFile, Boolean useAntiAliasing, Boolean useHighQualityRendering, Float imageBrightness, String imageColorMode, Float imageContrast, String numeralFormat, Integer pageCount, Integer pageIndex, String paperColor, String pixelFormat, Float resolution, Float scale, String tiffCompression, String dmlRenderingMode, String dmlEffectsRenderingMode, String tiffBinarizationMethod, String storage, String folder, Boolean zipOutput, TiffSaveOptionsData body) {
        TiffSaveOptionsData postBody = body;
        if (name == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/SaveAs/tiff/?appSid={appSid}&amp;resultFile={resultFile}&amp;useAntiAliasing={useAntiAliasing}&amp;useHighQualityRendering={useHighQualityRendering}&amp;imageBrightness={imageBrightness}&amp;imageColorMode={imageColorMode}&amp;imageContrast={imageContrast}&amp;numeralFormat={numeralFormat}&amp;pageCount={pageCount}&amp;pageIndex={pageIndex}&amp;paperColor={paperColor}&amp;pixelFormat={pixelFormat}&amp;resolution={resolution}&amp;scale={scale}&amp;tiffCompression={tiffCompression}&amp;dmlRenderingMode={dmlRenderingMode}&amp;dmlEffectsRenderingMode={dmlEffectsRenderingMode}&amp;tiffBinarizationMethod={tiffBinarizationMethod}&amp;storage={storage}&amp;folder={folder}&amp;zipOutput={zipOutput}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = resultFile != null ? resourcePath.replace("{resultFile}", this.apiInvoker.toPathValue(resultFile)) : resourcePath.replaceAll("[&?]resultFile.*?(?=&|\\?|$)", "");
        resourcePath = useAntiAliasing != null ? resourcePath.replace("{useAntiAliasing}", this.apiInvoker.toPathValue(useAntiAliasing)) : resourcePath.replaceAll("[&?]useAntiAliasing.*?(?=&|\\?|$)", "");
        resourcePath = useHighQualityRendering != null ? resourcePath.replace("{useHighQualityRendering}", this.apiInvoker.toPathValue(useHighQualityRendering)) : resourcePath.replaceAll("[&?]useHighQualityRendering.*?(?=&|\\?|$)", "");
        resourcePath = imageBrightness != null ? resourcePath.replace("{imageBrightness}", this.apiInvoker.toPathValue(imageBrightness)) : resourcePath.replaceAll("[&?]imageBrightness.*?(?=&|\\?|$)", "");
        resourcePath = imageColorMode != null ? resourcePath.replace("{imageColorMode}", this.apiInvoker.toPathValue(imageColorMode)) : resourcePath.replaceAll("[&?]imageColorMode.*?(?=&|\\?|$)", "");
        resourcePath = imageContrast != null ? resourcePath.replace("{imageContrast}", this.apiInvoker.toPathValue(imageContrast)) : resourcePath.replaceAll("[&?]imageContrast.*?(?=&|\\?|$)", "");
        resourcePath = numeralFormat != null ? resourcePath.replace("{numeralFormat}", this.apiInvoker.toPathValue(numeralFormat)) : resourcePath.replaceAll("[&?]numeralFormat.*?(?=&|\\?|$)", "");
        resourcePath = pageCount != null ? resourcePath.replace("{pageCount}", this.apiInvoker.toPathValue(pageCount)) : resourcePath.replaceAll("[&?]pageCount.*?(?=&|\\?|$)", "");
        resourcePath = pageIndex != null ? resourcePath.replace("{pageIndex}", this.apiInvoker.toPathValue(pageIndex)) : resourcePath.replaceAll("[&?]pageIndex.*?(?=&|\\?|$)", "");
        resourcePath = paperColor != null ? resourcePath.replace("{paperColor}", this.apiInvoker.toPathValue(paperColor)) : resourcePath.replaceAll("[&?]paperColor.*?(?=&|\\?|$)", "");
        resourcePath = pixelFormat != null ? resourcePath.replace("{pixelFormat}", this.apiInvoker.toPathValue(pixelFormat)) : resourcePath.replaceAll("[&?]pixelFormat.*?(?=&|\\?|$)", "");
        resourcePath = resolution != null ? resourcePath.replace("{resolution}", this.apiInvoker.toPathValue(resolution)) : resourcePath.replaceAll("[&?]resolution.*?(?=&|\\?|$)", "");
        resourcePath = scale != null ? resourcePath.replace("{scale}", this.apiInvoker.toPathValue(scale)) : resourcePath.replaceAll("[&?]scale.*?(?=&|\\?|$)", "");
        resourcePath = tiffCompression != null ? resourcePath.replace("{tiffCompression}", this.apiInvoker.toPathValue(tiffCompression)) : resourcePath.replaceAll("[&?]tiffCompression.*?(?=&|\\?|$)", "");
        resourcePath = dmlRenderingMode != null ? resourcePath.replace("{dmlRenderingMode}", this.apiInvoker.toPathValue(dmlRenderingMode)) : resourcePath.replaceAll("[&?]dmlRenderingMode.*?(?=&|\\?|$)", "");
        resourcePath = dmlEffectsRenderingMode != null ? resourcePath.replace("{dmlEffectsRenderingMode}", this.apiInvoker.toPathValue(dmlEffectsRenderingMode)) : resourcePath.replaceAll("[&?]dmlEffectsRenderingMode.*?(?=&|\\?|$)", "");
        resourcePath = tiffBinarizationMethod != null ? resourcePath.replace("{tiffBinarizationMethod}", this.apiInvoker.toPathValue(tiffBinarizationMethod)) : resourcePath.replaceAll("[&?]tiffBinarizationMethod.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        resourcePath = zipOutput != null ? resourcePath.replace("{zipOutput}", this.apiInvoker.toPathValue(zipOutput)) : resourcePath.replaceAll("[&?]zipOutput.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (SaveResponse)ApiInvoker.deserialize(this.response, "", SaveResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public StatDataResponse GetDocumentStatistics(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/statistics/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (StatDataResponse)ApiInvoker.deserialize(this.response, "", StatDataResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentResponse DeleteDocumentWatermark(String name, String filename, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/watermark/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentResponse)ApiInvoker.deserialize(this.response, "", DocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentResponse PostInsertDocumentWatermarkImage(String name, String filename, Double rotationAngle, String image, String storage, String folder, File file) {
        String contentType;
        FormDataMultiPart postBody = null;
        if (name == null || file == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/watermark/insertImage/?appSid={appSid}&amp;filename={filename}&amp;rotationAngle={rotationAngle}&amp;image={image}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = rotationAngle != null ? resourcePath.replace("{rotationAngle}", this.apiInvoker.toPathValue(rotationAngle)) : resourcePath.replaceAll("[&?]rotationAngle.*?(?=&|\\?|$)", "");
        resourcePath = image != null ? resourcePath.replace("{image}", this.apiInvoker.toPathValue(image)) : resourcePath.replaceAll("[&?]image.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"multipart/form-data"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.field("file", (Object)file, MediaType.MULTIPART_FORM_DATA_TYPE);
            postBody = mp;
        }
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentResponse)ApiInvoker.deserialize(this.response, "", DocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentResponse PostInsertDocumentWatermarkText(String name, String filename, String text, Double rotationAngle, String storage, String folder, WatermarkText body) {
        WatermarkText postBody = body;
        if (name == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/watermark/insertText/?appSid={appSid}&amp;filename={filename}&amp;text={text}&amp;rotationAngle={rotationAngle}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = text != null ? resourcePath.replace("{text}", this.apiInvoker.toPathValue(text)) : resourcePath.replaceAll("[&?]text.*?(?=&|\\?|$)", "");
        resourcePath = rotationAngle != null ? resourcePath.replace("{rotationAngle}", this.apiInvoker.toPathValue(rotationAngle)) : resourcePath.replaceAll("[&?]rotationAngle.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentResponse)ApiInvoker.deserialize(this.response, "", DocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DrawingObjectResponse GetDocumentDrawingObjectByIndex(String name, Integer objectIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || objectIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/drawingObjects/{objectIndex}/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = objectIndex != null ? resourcePath.replace("{objectIndex}", this.apiInvoker.toPathValue(objectIndex)) : resourcePath.replaceAll("[&?]objectIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (DrawingObjectResponse)ApiInvoker.deserialize(this.response, "", DrawingObjectResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage GetDocumentDrawingObjectByIndexWithFormat(String name, Integer objectIndex, String format, String storage, String folder) {
        Object postBody = null;
        if (name == null || objectIndex == null || format == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/drawingObjects/{objectIndex}/?appSid={appSid}&amp;toFormat={toFormat}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = objectIndex != null ? resourcePath.replace("{objectIndex}", this.apiInvoker.toPathValue(objectIndex)) : resourcePath.replaceAll("[&?]objectIndex.*?(?=&|\\?|$)", "");
        resourcePath = format != null ? resourcePath.replace("{format}", this.apiInvoker.toPathValue(format)) : resourcePath.replaceAll("[&?]format.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage GetDocumentDrawingObjectImageData(String name, Integer objectIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || objectIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/drawingObjects/{objectIndex}/imageData/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = objectIndex != null ? resourcePath.replace("{objectIndex}", this.apiInvoker.toPathValue(objectIndex)) : resourcePath.replaceAll("[&?]objectIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage GetDocumentDrawingObjectOleData(String name, Integer objectIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || objectIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/drawingObjects/{objectIndex}/oleData/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = objectIndex != null ? resourcePath.replace("{objectIndex}", this.apiInvoker.toPathValue(objectIndex)) : resourcePath.replaceAll("[&?]objectIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DrawingObjectsResponse GetDocumentDrawingObjects(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/drawingObjects/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (DrawingObjectsResponse)ApiInvoker.deserialize(this.response, "", DrawingObjectsResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaaSposeResponse DeleteFormField(String name, Integer sectionIndex, Integer paragraphIndex, Integer formfieldIndex, String destFileName, String storage, String folder) {
        Object postBody = null;
        if (name == null || sectionIndex == null || paragraphIndex == null || formfieldIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/sections/{sectionIndex}/paragraphs/{paragraphIndex}/formfields/{formfieldIndex}/?appSid={appSid}&amp;destFileName={destFileName}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = sectionIndex != null ? resourcePath.replace("{sectionIndex}", this.apiInvoker.toPathValue(sectionIndex)) : resourcePath.replaceAll("[&?]sectionIndex.*?(?=&|\\?|$)", "");
        resourcePath = paragraphIndex != null ? resourcePath.replace("{paragraphIndex}", this.apiInvoker.toPathValue(paragraphIndex)) : resourcePath.replaceAll("[&?]paragraphIndex.*?(?=&|\\?|$)", "");
        resourcePath = formfieldIndex != null ? resourcePath.replace("{formfieldIndex}", this.apiInvoker.toPathValue(formfieldIndex)) : resourcePath.replaceAll("[&?]formfieldIndex.*?(?=&|\\?|$)", "");
        resourcePath = destFileName != null ? resourcePath.replace("{destFileName}", this.apiInvoker.toPathValue(destFileName)) : resourcePath.replaceAll("[&?]destFileName.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (SaaSposeResponse)ApiInvoker.deserialize(this.response, "", SaaSposeResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public FormFieldResponse GetFormField(String name, Integer sectionIndex, Integer paragraphIndex, Integer formfieldIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || sectionIndex == null || paragraphIndex == null || formfieldIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/sections/{sectionIndex}/paragraphs/{paragraphIndex}/formfields/{formfieldIndex}/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = sectionIndex != null ? resourcePath.replace("{sectionIndex}", this.apiInvoker.toPathValue(sectionIndex)) : resourcePath.replaceAll("[&?]sectionIndex.*?(?=&|\\?|$)", "");
        resourcePath = paragraphIndex != null ? resourcePath.replace("{paragraphIndex}", this.apiInvoker.toPathValue(paragraphIndex)) : resourcePath.replaceAll("[&?]paragraphIndex.*?(?=&|\\?|$)", "");
        resourcePath = formfieldIndex != null ? resourcePath.replace("{formfieldIndex}", this.apiInvoker.toPathValue(formfieldIndex)) : resourcePath.replaceAll("[&?]formfieldIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (FormFieldResponse)ApiInvoker.deserialize(this.response, "", FormFieldResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public FormFieldResponse PostFormField(String name, Integer sectionIndex, Integer paragraphIndex, Integer formfieldIndex, String destFileName, String storage, String folder, FormField body) {
        FormField postBody = body;
        if (name == null || sectionIndex == null || paragraphIndex == null || formfieldIndex == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/sections/{sectionIndex}/paragraphs/{paragraphIndex}/formfields/{formfieldIndex}/?appSid={appSid}&amp;destFileName={destFileName}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = sectionIndex != null ? resourcePath.replace("{sectionIndex}", this.apiInvoker.toPathValue(sectionIndex)) : resourcePath.replaceAll("[&?]sectionIndex.*?(?=&|\\?|$)", "");
        resourcePath = paragraphIndex != null ? resourcePath.replace("{paragraphIndex}", this.apiInvoker.toPathValue(paragraphIndex)) : resourcePath.replaceAll("[&?]paragraphIndex.*?(?=&|\\?|$)", "");
        resourcePath = formfieldIndex != null ? resourcePath.replace("{formfieldIndex}", this.apiInvoker.toPathValue(formfieldIndex)) : resourcePath.replaceAll("[&?]formfieldIndex.*?(?=&|\\?|$)", "");
        resourcePath = destFileName != null ? resourcePath.replace("{destFileName}", this.apiInvoker.toPathValue(destFileName)) : resourcePath.replaceAll("[&?]destFileName.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (FormFieldResponse)ApiInvoker.deserialize(this.response, "", FormFieldResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public FormFieldResponse PutFormField(String name, Integer sectionIndex, Integer paragraphIndex, String insertBeforeNode, String destFileName, String storage, String folder, Object body) {
        Object postBody = body;
        if (name == null || sectionIndex == null || paragraphIndex == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/sections/{sectionIndex}/paragraphs/{paragraphIndex}/formfields/?appSid={appSid}&amp;insertBeforeNode={insertBeforeNode}&amp;destFileName={destFileName}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = sectionIndex != null ? resourcePath.replace("{sectionIndex}", this.apiInvoker.toPathValue(sectionIndex)) : resourcePath.replaceAll("[&?]sectionIndex.*?(?=&|\\?|$)", "");
        resourcePath = paragraphIndex != null ? resourcePath.replace("{paragraphIndex}", this.apiInvoker.toPathValue(paragraphIndex)) : resourcePath.replaceAll("[&?]paragraphIndex.*?(?=&|\\?|$)", "");
        resourcePath = insertBeforeNode != null ? resourcePath.replace("{insertBeforeNode}", this.apiInvoker.toPathValue(insertBeforeNode)) : resourcePath.replaceAll("[&?]insertBeforeNode.*?(?=&|\\?|$)", "");
        resourcePath = destFileName != null ? resourcePath.replace("{destFileName}", this.apiInvoker.toPathValue(destFileName)) : resourcePath.replaceAll("[&?]destFileName.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/xml"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (FormFieldResponse)ApiInvoker.deserialize(this.response, "", FormFieldResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaaSposeResponse DeleteHeadersFooters(String name, String headersFootersTypes, String filename, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/headersfooters/?appSid={appSid}&amp;headersFootersTypes={headersFootersTypes}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = headersFootersTypes != null ? resourcePath.replace("{headersFootersTypes}", this.apiInvoker.toPathValue(headersFootersTypes)) : resourcePath.replaceAll("[&?]headersFootersTypes.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (SaaSposeResponse)ApiInvoker.deserialize(this.response, "", SaaSposeResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public HyperlinkResponse GetDocumentHyperlinkByIndex(String name, Integer hyperlinkIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || hyperlinkIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/hyperlinks/{hyperlinkIndex}/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = hyperlinkIndex != null ? resourcePath.replace("{hyperlinkIndex}", this.apiInvoker.toPathValue(hyperlinkIndex)) : resourcePath.replaceAll("[&?]hyperlinkIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (HyperlinkResponse)ApiInvoker.deserialize(this.response, "", HyperlinkResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public HyperlinksResponse GetDocumentHyperlinks(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/hyperlinks/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (HyperlinksResponse)ApiInvoker.deserialize(this.response, "", HyperlinksResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaaSposeResponse DeleteDocumentMacros(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/macros/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (SaaSposeResponse)ApiInvoker.deserialize(this.response, "", SaaSposeResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public FieldNamesResponse GetDocumentFieldNames(String name, Boolean useNonMergeFields, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/mailMergeFieldNames/?appSid={appSid}&amp;useNonMergeFields={useNonMergeFields}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = useNonMergeFields != null ? resourcePath.replace("{useNonMergeFields}", this.apiInvoker.toPathValue(useNonMergeFields)) : resourcePath.replaceAll("[&?]useNonMergeFields.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (FieldNamesResponse)ApiInvoker.deserialize(this.response, "", FieldNamesResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentResponse PostDocumentExecuteMailMerge(String name, Boolean withRegions, String mailMergeDataFile, String cleanup, String filename, String storage, String folder, Boolean useWholeParagraphAsRegion, File file) {
        String contentType;
        File postBody = null;
        if (name == null || withRegions == null || file == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/executeMailMerge/{withRegions}/?appSid={appSid}&amp;mailMergeDataFile={mailMergeDataFile}&amp;cleanup={cleanup}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}&amp;useWholeParagraphAsRegion={useWholeParagraphAsRegion}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = withRegions != null ? resourcePath.replace("{withRegions}", this.apiInvoker.toPathValue(withRegions)) : resourcePath.replaceAll("[&?]withRegions.*?(?=&|\\?|$)", "");
        resourcePath = mailMergeDataFile != null ? resourcePath.replace("{mailMergeDataFile}", this.apiInvoker.toPathValue(mailMergeDataFile)) : resourcePath.replaceAll("[&?]mailMergeDataFile.*?(?=&|\\?|$)", "");
        resourcePath = cleanup != null ? resourcePath.replace("{cleanup}", this.apiInvoker.toPathValue(cleanup)) : resourcePath.replaceAll("[&?]cleanup.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        resourcePath = useWholeParagraphAsRegion != null ? resourcePath.replace("{useWholeParagraphAsRegion}", this.apiInvoker.toPathValue(useWholeParagraphAsRegion)) : resourcePath.replaceAll("[&?]useWholeParagraphAsRegion.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/xml"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (file != null) {
            postBody = file;
        }
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentResponse)ApiInvoker.deserialize(this.response, "", DocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaaSposeResponse DeleteParagraphFields(String name, Integer index, String storage, String folder) {
        Object postBody = null;
        if (name == null || index == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/paragraphs/{index}/fields/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = index != null ? resourcePath.replace("{index}", this.apiInvoker.toPathValue(index)) : resourcePath.replaceAll("[&?]index.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (SaaSposeResponse)ApiInvoker.deserialize(this.response, "", SaaSposeResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ParagraphResponse GetDocumentParagraph(String name, Integer index, String storage, String folder) {
        Object postBody = null;
        if (name == null || index == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/paragraphs/{index}/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = index != null ? resourcePath.replace("{index}", this.apiInvoker.toPathValue(index)) : resourcePath.replaceAll("[&?]index.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (ParagraphResponse)ApiInvoker.deserialize(this.response, "", ParagraphResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public RunResponse GetDocumentParagraphRun(String name, Integer index, Integer runIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || index == null || runIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/paragraphs/{index}/runs/{runIndex}/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = index != null ? resourcePath.replace("{index}", this.apiInvoker.toPathValue(index)) : resourcePath.replaceAll("[&?]index.*?(?=&|\\?|$)", "");
        resourcePath = runIndex != null ? resourcePath.replace("{runIndex}", this.apiInvoker.toPathValue(runIndex)) : resourcePath.replaceAll("[&?]runIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (RunResponse)ApiInvoker.deserialize(this.response, "", RunResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public FontResponse GetDocumentParagraphRunFont(String name, Integer index, Integer runIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || index == null || runIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/paragraphs/{index}/runs/{runIndex}/font/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = index != null ? resourcePath.replace("{index}", this.apiInvoker.toPathValue(index)) : resourcePath.replaceAll("[&?]index.*?(?=&|\\?|$)", "");
        resourcePath = runIndex != null ? resourcePath.replace("{runIndex}", this.apiInvoker.toPathValue(runIndex)) : resourcePath.replaceAll("[&?]runIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (FontResponse)ApiInvoker.deserialize(this.response, "", FontResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ParagraphLinkCollectionResponse GetDocumentParagraphs(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/paragraphs/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (ParagraphLinkCollectionResponse)ApiInvoker.deserialize(this.response, "", ParagraphLinkCollectionResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public FontResponse PostDocumentParagraphRunFont(String name, Integer index, Integer runIndex, String storage, String folder, String filename, Font body) {
        Font postBody = body;
        if (name == null || index == null || runIndex == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/paragraphs/{index}/runs/{runIndex}/font/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}&amp;filename={filename}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = index != null ? resourcePath.replace("{index}", this.apiInvoker.toPathValue(index)) : resourcePath.replaceAll("[&?]index.*?(?=&|\\?|$)", "");
        resourcePath = runIndex != null ? resourcePath.replace("{runIndex}", this.apiInvoker.toPathValue(runIndex)) : resourcePath.replaceAll("[&?]runIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (FontResponse)ApiInvoker.deserialize(this.response, "", FontResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public RevisionsModificationResponse AcceptAllRevisions(String name, String filename, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/revisions/acceptAll/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (RevisionsModificationResponse)ApiInvoker.deserialize(this.response, "", RevisionsModificationResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public RevisionsModificationResponse RejectAllRevisions(String name, String filename, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/revisions/rejectAll/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (RevisionsModificationResponse)ApiInvoker.deserialize(this.response, "", RevisionsModificationResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaaSposeResponse DeleteSectionFields(String name, Integer sectionIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || sectionIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/sections/{sectionIndex}/fields/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = sectionIndex != null ? resourcePath.replace("{sectionIndex}", this.apiInvoker.toPathValue(sectionIndex)) : resourcePath.replaceAll("[&?]sectionIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (SaaSposeResponse)ApiInvoker.deserialize(this.response, "", SaaSposeResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SaaSposeResponse DeleteSectionParagraphFields(String name, Integer sectionIndex, Integer paragraphIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || sectionIndex == null || paragraphIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/sections/{sectionIndex}/paragraphs/{paragraphIndex}/fields/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = sectionIndex != null ? resourcePath.replace("{sectionIndex}", this.apiInvoker.toPathValue(sectionIndex)) : resourcePath.replaceAll("[&?]sectionIndex.*?(?=&|\\?|$)", "");
        resourcePath = paragraphIndex != null ? resourcePath.replace("{paragraphIndex}", this.apiInvoker.toPathValue(paragraphIndex)) : resourcePath.replaceAll("[&?]paragraphIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (SaaSposeResponse)ApiInvoker.deserialize(this.response, "", SaaSposeResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SectionResponse GetSection(String name, Integer sectionIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || sectionIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/sections/{sectionIndex}/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = sectionIndex != null ? resourcePath.replace("{sectionIndex}", this.apiInvoker.toPathValue(sectionIndex)) : resourcePath.replaceAll("[&?]sectionIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (SectionResponse)ApiInvoker.deserialize(this.response, "", SectionResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SectionPageSetupResponse GetSectionPageSetup(String name, Integer sectionIndex, String storage, String folder) {
        Object postBody = null;
        if (name == null || sectionIndex == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/sections/{sectionIndex}/pageSetup/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = sectionIndex != null ? resourcePath.replace("{sectionIndex}", this.apiInvoker.toPathValue(sectionIndex)) : resourcePath.replaceAll("[&?]sectionIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (SectionPageSetupResponse)ApiInvoker.deserialize(this.response, "", SectionPageSetupResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SectionLinkCollectionResponse GetSections(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/sections/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (SectionLinkCollectionResponse)ApiInvoker.deserialize(this.response, "", SectionLinkCollectionResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public SectionPageSetupResponse UpdateSectionPageSetup(String name, Integer sectionIndex, String storage, String folder, String filename, PageSetup body) {
        PageSetup postBody = body;
        if (name == null || sectionIndex == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/sections/{sectionIndex}/pageSetup/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}&amp;filename={filename}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = sectionIndex != null ? resourcePath.replace("{sectionIndex}", this.apiInvoker.toPathValue(sectionIndex)) : resourcePath.replaceAll("[&?]sectionIndex.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (SectionPageSetupResponse)ApiInvoker.deserialize(this.response, "", SectionPageSetupResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public TextItemsResponse GetDocumentTextItems(String name, String storage, String folder) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/textItems/?appSid={appSid}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (TextItemsResponse)ApiInvoker.deserialize(this.response, "", TextItemsResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ReplaceTextResponse PostReplaceText(String name, String filename, String storage, String folder, ReplaceTextRequest body) {
        ReplaceTextRequest postBody = body;
        if (name == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/replaceText/?appSid={appSid}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (ReplaceTextResponse)ApiInvoker.deserialize(this.response, "", ReplaceTextResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentResponse PostInsertWatermarkImage(String name, String filename, Double rotationAngle, String image, String storage, String folder, File file) {
        String contentType;
        FormDataMultiPart postBody = null;
        if (name == null || file == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/insertWatermarkImage/?appSid={appSid}&amp;filename={filename}&amp;rotationAngle={rotationAngle}&amp;image={image}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = rotationAngle != null ? resourcePath.replace("{rotationAngle}", this.apiInvoker.toPathValue(rotationAngle)) : resourcePath.replaceAll("[&?]rotationAngle.*?(?=&|\\?|$)", "");
        resourcePath = image != null ? resourcePath.replace("{image}", this.apiInvoker.toPathValue(image)) : resourcePath.replaceAll("[&?]image.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"multipart/form-data"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.field("file", (Object)file, MediaType.MULTIPART_FORM_DATA_TYPE);
            postBody = mp;
        }
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentResponse)ApiInvoker.deserialize(this.response, "", DocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DocumentResponse PostInsertWatermarkText(String name, String text, Double rotationAngle, String filename, String storage, String folder, WatermarkText body) {
        WatermarkText postBody = body;
        if (name == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/words/{name}/insertWatermarkText/?appSid={appSid}&amp;text={text}&amp;rotationAngle={rotationAngle}&amp;filename={filename}&amp;storage={storage}&amp;folder={folder}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        resourcePath = text != null ? resourcePath.replace("{text}", this.apiInvoker.toPathValue(text)) : resourcePath.replaceAll("[&?]text.*?(?=&|\\?|$)", "");
        resourcePath = rotationAngle != null ? resourcePath.replace("{rotationAngle}", this.apiInvoker.toPathValue(rotationAngle)) : resourcePath.replaceAll("[&?]rotationAngle.*?(?=&|\\?|$)", "");
        resourcePath = filename != null ? resourcePath.replace("{filename}", this.apiInvoker.toPathValue(filename)) : resourcePath.replaceAll("[&?]filename.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = folder != null ? resourcePath.replace("{folder}", this.apiInvoker.toPathValue(folder)) : resourcePath.replaceAll("[&?]folder.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (DocumentResponse)ApiInvoker.deserialize(this.response, "", DocumentResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }
}

