/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.storage.api;

import com.aspose.storage.client.ApiException;
import com.aspose.storage.client.ApiInvoker;
import com.aspose.storage.client.ApiInvokerResponse;
import com.aspose.storage.model.DiscUsageResponse;
import com.aspose.storage.model.FileExistResponse;
import com.aspose.storage.model.FileVersionsResponse;
import com.aspose.storage.model.MoveFileResponse;
import com.aspose.storage.model.MoveFolderResponse;
import com.aspose.storage.model.RemoveFileResponse;
import com.aspose.storage.model.RemoveFolderResponse;
import com.aspose.storage.model.ResponseMessage;
import com.aspose.storage.model.StorageExistResponse;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;

public class StorageApi {
    String basePath = "http://api.aspose.com/v1.1";
    ApiInvoker apiInvoker = ApiInvoker.getInstance();
    ApiInvokerResponse response = null;

    public StorageApi(String basePath, String apiKey, String appSid) {
        this.basePath = basePath;
        this.apiInvoker.addDefaultHeader(this.apiInvoker.API_KEY, apiKey);
        this.apiInvoker.addDefaultHeader(this.apiInvoker.APP_SID, appSid);
    }

    public StorageApi(String basePath, String apiKey, String appSid, boolean isDebug) {
        this.basePath = basePath;
        this.apiInvoker.addDefaultHeader(this.apiInvoker.API_KEY, apiKey);
        this.apiInvoker.addDefaultHeader(this.apiInvoker.APP_SID, appSid);
        if (isDebug) {
            this.apiInvoker.enableDebug();
        }
    }

    public StorageApi(String apiKey, String appSid) {
        this.apiInvoker.addDefaultHeader(this.apiInvoker.API_KEY, apiKey);
        this.apiInvoker.addDefaultHeader(this.apiInvoker.APP_SID, appSid);
    }

    public StorageApi(String apiKey, String appSid, boolean isDebug) {
        this.apiInvoker.addDefaultHeader(this.apiInvoker.API_KEY, apiKey);
        this.apiInvoker.addDefaultHeader(this.apiInvoker.APP_SID, appSid);
        if (isDebug) {
            this.apiInvoker.enableDebug();
        }
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public RemoveFileResponse DeleteFile(String Path2, String versionId, String storage) {
        Object postBody = null;
        if (Path2 == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/file/{Path}/?appSid={appSid}&amp;versionId={versionId}&amp;storage={storage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = Path2 != null ? resourcePath.replace("{Path}", this.apiInvoker.toPathValue(Path2)) : resourcePath.replaceAll("[&?]Path.*?(?=&|\\?|$)", "");
        resourcePath = versionId != null ? resourcePath.replace("{versionId}", this.apiInvoker.toPathValue(versionId)) : resourcePath.replaceAll("[&?]versionId.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (RemoveFileResponse)ApiInvoker.deserialize(this.response, "", RemoveFileResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public DiscUsageResponse GetDiscUsage(String storage) {
        Object postBody = null;
        String resourcePath = "/storage/disc/?appSid={appSid}&amp;storage={storage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (DiscUsageResponse)ApiInvoker.deserialize(this.response, "", DiscUsageResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage GetDownload(String Path2, String versionId, String storage) {
        Object postBody = null;
        if (Path2 == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/file/{Path}/?appSid={appSid}&amp;versionId={versionId}&amp;storage={storage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = Path2 != null ? resourcePath.replace("{Path}", this.apiInvoker.toPathValue(Path2)) : resourcePath.replaceAll("[&?]Path.*?(?=&|\\?|$)", "");
        resourcePath = versionId != null ? resourcePath.replace("{versionId}", this.apiInvoker.toPathValue(versionId)) : resourcePath.replaceAll("[&?]versionId.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public FileExistResponse GetIsExist(String Path2, String versionId, String storage) {
        Object postBody = null;
        if (Path2 == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/exist/{Path}/?appSid={appSid}&amp;versionId={versionId}&amp;storage={storage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = Path2 != null ? resourcePath.replace("{Path}", this.apiInvoker.toPathValue(Path2)) : resourcePath.replaceAll("[&?]Path.*?(?=&|\\?|$)", "");
        resourcePath = versionId != null ? resourcePath.replace("{versionId}", this.apiInvoker.toPathValue(versionId)) : resourcePath.replaceAll("[&?]versionId.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (FileExistResponse)ApiInvoker.deserialize(this.response, "", FileExistResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public FileVersionsResponse GetListFileVersions(String Path2, String storage) {
        Object postBody = null;
        if (Path2 == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/version/{Path}/?appSid={appSid}&amp;storage={storage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = Path2 != null ? resourcePath.replace("{Path}", this.apiInvoker.toPathValue(Path2)) : resourcePath.replaceAll("[&?]Path.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (FileVersionsResponse)ApiInvoker.deserialize(this.response, "", FileVersionsResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public MoveFileResponse PostMoveFile(String src, String dest, String versionId, String storage, String destStorage) {
        Object postBody = null;
        if (src == null || dest == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/file/{src}/?dest={dest}&amp;appSid={appSid}&amp;versionId={versionId}&amp;storage={storage}&amp;destStorage={destStorage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = src != null ? resourcePath.replace("{src}", this.apiInvoker.toPathValue(src)) : resourcePath.replaceAll("[&?]src.*?(?=&|\\?|$)", "");
        resourcePath = dest != null ? resourcePath.replace("{dest}", this.apiInvoker.toPathValue(dest)) : resourcePath.replaceAll("[&?]dest.*?(?=&|\\?|$)", "");
        resourcePath = versionId != null ? resourcePath.replace("{versionId}", this.apiInvoker.toPathValue(versionId)) : resourcePath.replaceAll("[&?]versionId.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = destStorage != null ? resourcePath.replace("{destStorage}", this.apiInvoker.toPathValue(destStorage)) : resourcePath.replaceAll("[&?]destStorage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (MoveFileResponse)ApiInvoker.deserialize(this.response, "", MoveFileResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage PutCopy(String Path2, String newdest, String versionId, String storage, String destStorage, File file) {
        String contentType;
        FormDataMultiPart postBody = null;
        if (Path2 == null || newdest == null || file == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/file/{Path}/?appSid={appSid}&amp;newdest={newdest}&amp;versionId={versionId}&amp;storage={storage}&amp;destStorage={destStorage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = Path2 != null ? resourcePath.replace("{Path}", this.apiInvoker.toPathValue(Path2)) : resourcePath.replaceAll("[&?]Path.*?(?=&|\\?|$)", "");
        resourcePath = newdest != null ? resourcePath.replace("{newdest}", this.apiInvoker.toPathValue(newdest)) : resourcePath.replaceAll("[&?]newdest.*?(?=&|\\?|$)", "");
        resourcePath = versionId != null ? resourcePath.replace("{versionId}", this.apiInvoker.toPathValue(versionId)) : resourcePath.replaceAll("[&?]versionId.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = destStorage != null ? resourcePath.replace("{destStorage}", this.apiInvoker.toPathValue(destStorage)) : resourcePath.replaceAll("[&?]destStorage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"multipart/form-data"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.field("file", (Object)file, MediaType.MULTIPART_FORM_DATA_TYPE);
            postBody = mp;
        }
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage PutCreate(String Path2, String versionId, String storage, File file) {
        String contentType;
        FormDataMultiPart postBody = null;
        if (Path2 == null || file == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/file/{Path}/?appSid={appSid}&amp;versionId={versionId}&amp;storage={storage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = Path2 != null ? resourcePath.replace("{Path}", this.apiInvoker.toPathValue(Path2)) : resourcePath.replaceAll("[&?]Path.*?(?=&|\\?|$)", "");
        resourcePath = versionId != null ? resourcePath.replace("{versionId}", this.apiInvoker.toPathValue(versionId)) : resourcePath.replaceAll("[&?]versionId.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"multipart/form-data"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.field("file", (Object)file, MediaType.MULTIPART_FORM_DATA_TYPE);
            postBody = mp;
        }
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public RemoveFolderResponse DeleteFolder(String Path2, String storage, Boolean recursive) {
        Object postBody = null;
        if (Path2 == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/folder/{Path}/?appSid={appSid}&amp;storage={storage}&amp;recursive={recursive}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = Path2 != null ? resourcePath.replace("{Path}", this.apiInvoker.toPathValue(Path2)) : resourcePath.replaceAll("[&?]Path.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = recursive != null ? resourcePath.replace("{recursive}", this.apiInvoker.toPathValue(recursive)) : resourcePath.replaceAll("[&?]recursive.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
            return (RemoveFolderResponse)ApiInvoker.deserialize(this.response, "", RemoveFolderResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage GetListFiles(String Path2, String storage) {
        Object postBody = null;
        String resourcePath = "/storage/folder/{Path}/?appSid={appSid}&amp;storage={storage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = Path2 != null ? resourcePath.replace("{Path}", this.apiInvoker.toPathValue(Path2)) : resourcePath.replaceAll("[&?]Path.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public MoveFolderResponse PostMoveFolder(String src, String dest, String storage, String destStorage) {
        Object postBody = null;
        if (src == null || dest == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/folder/{src}/?dest={dest}&amp;appSid={appSid}&amp;storage={storage}&amp;destStorage={destStorage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = src != null ? resourcePath.replace("{src}", this.apiInvoker.toPathValue(src)) : resourcePath.replaceAll("[&?]src.*?(?=&|\\?|$)", "");
        resourcePath = dest != null ? resourcePath.replace("{dest}", this.apiInvoker.toPathValue(dest)) : resourcePath.replaceAll("[&?]dest.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = destStorage != null ? resourcePath.replace("{destStorage}", this.apiInvoker.toPathValue(destStorage)) : resourcePath.replaceAll("[&?]destStorage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, postBody, headerParams, formParams, contentType);
            return (MoveFolderResponse)ApiInvoker.deserialize(this.response, "", MoveFolderResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage PutCopyFolder(String Path2, String newdest, String storage, String destStorage) {
        Object postBody = null;
        if (Path2 == null || newdest == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/folder/{Path}/?appSid={appSid}&amp;newdest={newdest}&amp;storage={storage}&amp;destStorage={destStorage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = Path2 != null ? resourcePath.replace("{Path}", this.apiInvoker.toPathValue(Path2)) : resourcePath.replaceAll("[&?]Path.*?(?=&|\\?|$)", "");
        resourcePath = newdest != null ? resourcePath.replace("{newdest}", this.apiInvoker.toPathValue(newdest)) : resourcePath.replaceAll("[&?]newdest.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = destStorage != null ? resourcePath.replace("{destStorage}", this.apiInvoker.toPathValue(destStorage)) : resourcePath.replaceAll("[&?]destStorage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public ResponseMessage PutCreateFolder(String Path2, String storage, String destStorage) {
        Object postBody = null;
        if (Path2 == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/folder/{Path}/?appSid={appSid}&amp;storage={storage}&amp;destStorage={destStorage}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = Path2 != null ? resourcePath.replace("{Path}", this.apiInvoker.toPathValue(Path2)) : resourcePath.replaceAll("[&?]Path.*?(?=&|\\?|$)", "");
        resourcePath = storage != null ? resourcePath.replace("{storage}", this.apiInvoker.toPathValue(storage)) : resourcePath.replaceAll("[&?]storage.*?(?=&|\\?|$)", "");
        resourcePath = destStorage != null ? resourcePath.replace("{destStorage}", this.apiInvoker.toPathValue(destStorage)) : resourcePath.replaceAll("[&?]destStorage.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, postBody, headerParams, formParams, contentType);
            return (ResponseMessage)ApiInvoker.deserialize(this.response, "", ResponseMessage.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }

    public StorageExistResponse GetIsStorageExist(String name) {
        Object postBody = null;
        if (name == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/storage/{name}/exist/?appSid={appSid}";
        resourcePath = resourcePath.replaceAll("\\*", "").replace("&amp;", "&").replace("/?", "?").replace("toFormat={toFormat}", "format={format}");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        resourcePath = name != null ? resourcePath.replace("{name}", this.apiInvoker.toPathValue(name)) : resourcePath.replaceAll("[&?]name.*?(?=&|\\?|$)", "");
        String[] contentTypes = new String[]{"application/json"};
        String contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        try {
            this.response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, postBody, headerParams, formParams, contentType);
            return (StorageExistResponse)ApiInvoker.deserialize(this.response, "", StorageExistResponse.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                throw new ApiException(404, "");
            }
            throw ex;
        }
    }
}

