/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.HorizontalAlignment;
import com.aspose.asposecloudpdf.model.Position;
import com.aspose.asposecloudpdf.model.Rectangle;
import com.aspose.asposecloudpdf.model.TextState;
import com.aspose.asposecloudpdf.model.VerticalAlignment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents text occurrence.")
public class TextRect {
    @SerializedName(value="Text")
    private String text = null;
    @SerializedName(value="Page")
    private Integer page = null;
    @SerializedName(value="Rect")
    private Rectangle rect = null;
    @SerializedName(value="HorizontalAlignment")
    private HorizontalAlignment horizontalAlignment = null;
    @SerializedName(value="VerticalAlignment")
    private VerticalAlignment verticalAlignment = null;
    @SerializedName(value="Position")
    private Position position = null;
    @SerializedName(value="BaselinePosition")
    private Position baselinePosition = null;
    @SerializedName(value="TextState")
    private TextState textState = null;

    public TextRect text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Text of the occurrence.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TextRect page(Integer page) {
        this.page = page;
        return this;
    }

    @ApiModelProperty(value="Page on which the occurrence is found.")
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public TextRect rect(Rectangle rect) {
        this.rect = rect;
        return this;
    }

    @ApiModelProperty(value="Rectangle of the occurrence.")
    public Rectangle getRect() {
        return this.rect;
    }

    public void setRect(Rectangle rect) {
        this.rect = rect;
    }

    public TextRect horizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a horizontal alignment of text fragment. ")
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public TextRect verticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a vertical alignment of text fragment. ")
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public TextRect position(Position position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(value="Gets or sets text position for text, represented with TextRect object.")
    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public TextRect baselinePosition(Position baselinePosition) {
        this.baselinePosition = baselinePosition;
        return this;
    }

    @ApiModelProperty(value="Gets text position for text, represented with TextRect object. The YIndent of the Position structure represents baseline coordinate of the text fragment.")
    public Position getBaselinePosition() {
        return this.baselinePosition;
    }

    public void setBaselinePosition(Position baselinePosition) {
        this.baselinePosition = baselinePosition;
    }

    public TextRect textState(TextState textState) {
        this.textState = textState;
        return this;
    }

    @ApiModelProperty(value="Gets or sets text state for the text that TextRect object represents.")
    public TextState getTextState() {
        return this.textState;
    }

    public void setTextState(TextState textState) {
        this.textState = textState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextRect textRect = (TextRect)o;
        return Objects.equals(this.text, textRect.text) && Objects.equals(this.page, textRect.page) && Objects.equals(this.rect, textRect.rect) && Objects.equals((Object)this.horizontalAlignment, (Object)textRect.horizontalAlignment) && Objects.equals((Object)this.verticalAlignment, (Object)textRect.verticalAlignment) && Objects.equals(this.position, textRect.position) && Objects.equals(this.baselinePosition, textRect.baselinePosition) && Objects.equals(this.textState, textRect.textState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.page, this.rect, this.horizontalAlignment, this.verticalAlignment, this.position, this.baselinePosition, this.textState});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextRect {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    rect: ").append(this.toIndentedString(this.rect)).append("\n");
        sb.append("    horizontalAlignment: ").append(this.toIndentedString((Object)this.horizontalAlignment)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    baselinePosition: ").append(this.toIndentedString(this.baselinePosition)).append("\n");
        sb.append("    textState: ").append(this.toIndentedString(this.textState)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

