/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.Annotation;
import com.aspose.asposecloudpdf.model.Color;
import com.aspose.asposecloudpdf.model.HorizontalAlignment;
import com.aspose.asposecloudpdf.model.Point;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides RedactionAnnotation.")
public class RedactionAnnotation
extends Annotation {
    @SerializedName(value="QuadPoint")
    private List<Point> quadPoint = null;
    @SerializedName(value="FillColor")
    private Color fillColor = null;
    @SerializedName(value="BorderColor")
    private Color borderColor = null;
    @SerializedName(value="OverlayText")
    private String overlayText = null;
    @SerializedName(value="Repeat")
    private Boolean repeat = null;
    @SerializedName(value="TextAlignment")
    private HorizontalAlignment textAlignment = null;

    public RedactionAnnotation quadPoint(List<Point> quadPoint) {
        this.quadPoint = quadPoint;
        return this;
    }

    public RedactionAnnotation addQuadPointItem(Point quadPointItem) {
        if (this.quadPoint == null) {
            this.quadPoint = new ArrayList<Point>();
        }
        this.quadPoint.add(quadPointItem);
        return this;
    }

    @ApiModelProperty(value="An array of 8xN numbers specifying the coordinates of content region that is intended to be removed. ")
    public List<Point> getQuadPoint() {
        return this.quadPoint;
    }

    public void setQuadPoint(List<Point> quadPoint) {
        this.quadPoint = quadPoint;
    }

    public RedactionAnnotation fillColor(Color fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets color to fill annotation.")
    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public RedactionAnnotation borderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets color of border which is drawn when redaction is not active.")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public RedactionAnnotation overlayText(String overlayText) {
        this.overlayText = overlayText;
        return this;
    }

    @ApiModelProperty(value="Text to print on redact annotation.")
    public String getOverlayText() {
        return this.overlayText;
    }

    public void setOverlayText(String overlayText) {
        this.overlayText = overlayText;
    }

    public RedactionAnnotation repeat(Boolean repeat) {
        this.repeat = repeat;
        return this;
    }

    @ApiModelProperty(value="If true overlay text will be repated on the annotation. ")
    public Boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(Boolean repeat) {
        this.repeat = repeat;
    }

    public RedactionAnnotation textAlignment(HorizontalAlignment textAlignment) {
        this.textAlignment = textAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets. Alignment of Overlay Text.")
    public HorizontalAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(HorizontalAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedactionAnnotation redactionAnnotation = (RedactionAnnotation)o;
        return Objects.equals(this.quadPoint, redactionAnnotation.quadPoint) && Objects.equals(this.fillColor, redactionAnnotation.fillColor) && Objects.equals(this.borderColor, redactionAnnotation.borderColor) && Objects.equals(this.overlayText, redactionAnnotation.overlayText) && Objects.equals(this.repeat, redactionAnnotation.repeat) && Objects.equals((Object)this.textAlignment, (Object)redactionAnnotation.textAlignment) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.quadPoint, this.fillColor, this.borderColor, this.overlayText, this.repeat, this.textAlignment, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RedactionAnnotation {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    quadPoint: ").append(this.toIndentedString(this.quadPoint)).append("\n");
        sb.append("    fillColor: ").append(this.toIndentedString(this.fillColor)).append("\n");
        sb.append("    borderColor: ").append(this.toIndentedString(this.borderColor)).append("\n");
        sb.append("    overlayText: ").append(this.toIndentedString(this.overlayText)).append("\n");
        sb.append("    repeat: ").append(this.toIndentedString(this.repeat)).append("\n");
        sb.append("    textAlignment: ").append(this.toIndentedString((Object)this.textAlignment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

