/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.Color;
import com.aspose.asposecloudpdf.model.LineEnding;
import com.aspose.asposecloudpdf.model.MarkupAnnotation;
import com.aspose.asposecloudpdf.model.Point;
import com.aspose.asposecloudpdf.model.PolyIntent;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides PolyAnnotation.")
public class PolyAnnotation
extends MarkupAnnotation {
    @SerializedName(value="InteriorColor")
    private Color interiorColor = null;
    @SerializedName(value="StartingStyle")
    private LineEnding startingStyle = null;
    @SerializedName(value="EndingStyle")
    private LineEnding endingStyle = null;
    @SerializedName(value="Intent")
    private PolyIntent intent = null;
    @SerializedName(value="Vertices")
    private List<Point> vertices = new ArrayList<Point>();

    public PolyAnnotation interiorColor(Color interiorColor) {
        this.interiorColor = interiorColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the interior color with which to fill the annotation\u0432\u0402\u2122s line endings.")
    public Color getInteriorColor() {
        return this.interiorColor;
    }

    public void setInteriorColor(Color interiorColor) {
        this.interiorColor = interiorColor;
    }

    public PolyAnnotation startingStyle(LineEnding startingStyle) {
        this.startingStyle = startingStyle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the style of first line ending.")
    public LineEnding getStartingStyle() {
        return this.startingStyle;
    }

    public void setStartingStyle(LineEnding startingStyle) {
        this.startingStyle = startingStyle;
    }

    public PolyAnnotation endingStyle(LineEnding endingStyle) {
        this.endingStyle = endingStyle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the style of second line ending.")
    public LineEnding getEndingStyle() {
        return this.endingStyle;
    }

    public void setEndingStyle(LineEnding endingStyle) {
        this.endingStyle = endingStyle;
    }

    public PolyAnnotation intent(PolyIntent intent) {
        this.intent = intent;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the intent of the polygon or polyline annotation.")
    public PolyIntent getIntent() {
        return this.intent;
    }

    public void setIntent(PolyIntent intent) {
        this.intent = intent;
    }

    public PolyAnnotation vertices(List<Point> vertices) {
        this.vertices = vertices;
        return this;
    }

    public PolyAnnotation addVerticesItem(Point verticesItem) {
        this.vertices.add(verticesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets an array of points representing the horizontal and vertical coordinates of each vertex.")
    public List<Point> getVertices() {
        return this.vertices;
    }

    public void setVertices(List<Point> vertices) {
        this.vertices = vertices;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolyAnnotation polyAnnotation = (PolyAnnotation)o;
        return Objects.equals(this.interiorColor, polyAnnotation.interiorColor) && Objects.equals((Object)this.startingStyle, (Object)polyAnnotation.startingStyle) && Objects.equals((Object)this.endingStyle, (Object)polyAnnotation.endingStyle) && Objects.equals((Object)this.intent, (Object)polyAnnotation.intent) && Objects.equals(this.vertices, polyAnnotation.vertices) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.interiorColor, this.startingStyle, this.endingStyle, this.intent, this.vertices, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolyAnnotation {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    interiorColor: ").append(this.toIndentedString(this.interiorColor)).append("\n");
        sb.append("    startingStyle: ").append(this.toIndentedString((Object)this.startingStyle)).append("\n");
        sb.append("    endingStyle: ").append(this.toIndentedString((Object)this.endingStyle)).append("\n");
        sb.append("    intent: ").append(this.toIndentedString((Object)this.intent)).append("\n");
        sb.append("    vertices: ").append(this.toIndentedString(this.vertices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

