/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.LineSpacing;
import com.aspose.asposecloudpdf.model.Rectangle;
import com.aspose.asposecloudpdf.model.TextHorizontalAlignment;
import com.aspose.asposecloudpdf.model.TextLine;
import com.aspose.asposecloudpdf.model.VerticalAlignment;
import com.aspose.asposecloudpdf.model.WrapMode;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents text paragraphs as multiline text object.")
public class Paragraph {
    @SerializedName(value="LineSpacing")
    private LineSpacing lineSpacing = null;
    @SerializedName(value="WrapMode")
    private WrapMode wrapMode = null;
    @SerializedName(value="HorizontalAlignment")
    private TextHorizontalAlignment horizontalAlignment = null;
    @SerializedName(value="LeftMargin")
    private Double leftMargin = null;
    @SerializedName(value="RightMargin")
    private Double rightMargin = null;
    @SerializedName(value="TopMargin")
    private Double topMargin = null;
    @SerializedName(value="BottomMargin")
    private Double bottomMargin = null;
    @SerializedName(value="Rectangle")
    private Rectangle rectangle = null;
    @SerializedName(value="Rotation")
    private Double rotation = null;
    @SerializedName(value="SubsequentLinesIndent")
    private Double subsequentLinesIndent = null;
    @SerializedName(value="VerticalAlignment")
    private VerticalAlignment verticalAlignment = null;
    @SerializedName(value="Lines")
    private List<TextLine> lines = new ArrayList<TextLine>();

    public Paragraph lineSpacing(LineSpacing lineSpacing) {
        this.lineSpacing = lineSpacing;
        return this;
    }

    @ApiModelProperty(value="Line spacing mode.")
    public LineSpacing getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(LineSpacing lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public Paragraph wrapMode(WrapMode wrapMode) {
        this.wrapMode = wrapMode;
        return this;
    }

    @ApiModelProperty(value="Word wrap mode.")
    public WrapMode getWrapMode() {
        return this.wrapMode;
    }

    public void setWrapMode(WrapMode wrapMode) {
        this.wrapMode = wrapMode;
    }

    public Paragraph horizontalAlignment(TextHorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @ApiModelProperty(value="Horizontal alignment for the text inside paragrph's rectangle.")
    public TextHorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(TextHorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public Paragraph leftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    @ApiModelProperty(value="Left margin.")
    public Double getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
    }

    public Paragraph rightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    @ApiModelProperty(value="Right margin.")
    public Double getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
    }

    public Paragraph topMargin(Double topMargin) {
        this.topMargin = topMargin;
        return this;
    }

    @ApiModelProperty(value="Top margin.")
    public Double getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(Double topMargin) {
        this.topMargin = topMargin;
    }

    public Paragraph bottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
        return this;
    }

    @ApiModelProperty(value="Bottom margin.")
    public Double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public Paragraph rectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
        return this;
    }

    @ApiModelProperty(value="Rectangle of the paragraph.")
    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public Paragraph rotation(Double rotation) {
        this.rotation = rotation;
        return this;
    }

    @ApiModelProperty(value="Rotation angle in degrees.")
    public Double getRotation() {
        return this.rotation;
    }

    public void setRotation(Double rotation) {
        this.rotation = rotation;
    }

    public Paragraph subsequentLinesIndent(Double subsequentLinesIndent) {
        this.subsequentLinesIndent = subsequentLinesIndent;
        return this;
    }

    @ApiModelProperty(value="Subsequent lines indent value.")
    public Double getSubsequentLinesIndent() {
        return this.subsequentLinesIndent;
    }

    public void setSubsequentLinesIndent(Double subsequentLinesIndent) {
        this.subsequentLinesIndent = subsequentLinesIndent;
    }

    public Paragraph verticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(value="Vertical alignment for the text inside paragrph's rectangle")
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public Paragraph lines(List<TextLine> lines) {
        this.lines = lines;
        return this;
    }

    public Paragraph addLinesItem(TextLine linesItem) {
        this.lines.add(linesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of text lines.")
    public List<TextLine> getLines() {
        return this.lines;
    }

    public void setLines(List<TextLine> lines) {
        this.lines = lines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Paragraph paragraph = (Paragraph)o;
        return Objects.equals((Object)this.lineSpacing, (Object)paragraph.lineSpacing) && Objects.equals((Object)this.wrapMode, (Object)paragraph.wrapMode) && Objects.equals((Object)this.horizontalAlignment, (Object)paragraph.horizontalAlignment) && Objects.equals(this.leftMargin, paragraph.leftMargin) && Objects.equals(this.rightMargin, paragraph.rightMargin) && Objects.equals(this.topMargin, paragraph.topMargin) && Objects.equals(this.bottomMargin, paragraph.bottomMargin) && Objects.equals(this.rectangle, paragraph.rectangle) && Objects.equals(this.rotation, paragraph.rotation) && Objects.equals(this.subsequentLinesIndent, paragraph.subsequentLinesIndent) && Objects.equals((Object)this.verticalAlignment, (Object)paragraph.verticalAlignment) && Objects.equals(this.lines, paragraph.lines);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lineSpacing, this.wrapMode, this.horizontalAlignment, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.rectangle, this.rotation, this.subsequentLinesIndent, this.verticalAlignment, this.lines});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Paragraph {\n");
        sb.append("    lineSpacing: ").append(this.toIndentedString((Object)this.lineSpacing)).append("\n");
        sb.append("    wrapMode: ").append(this.toIndentedString((Object)this.wrapMode)).append("\n");
        sb.append("    horizontalAlignment: ").append(this.toIndentedString((Object)this.horizontalAlignment)).append("\n");
        sb.append("    leftMargin: ").append(this.toIndentedString(this.leftMargin)).append("\n");
        sb.append("    rightMargin: ").append(this.toIndentedString(this.rightMargin)).append("\n");
        sb.append("    topMargin: ").append(this.toIndentedString(this.topMargin)).append("\n");
        sb.append("    bottomMargin: ").append(this.toIndentedString(this.bottomMargin)).append("\n");
        sb.append("    rectangle: ").append(this.toIndentedString(this.rectangle)).append("\n");
        sb.append("    rotation: ").append(this.toIndentedString(this.rotation)).append("\n");
        sb.append("    subsequentLinesIndent: ").append(this.toIndentedString(this.subsequentLinesIndent)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("    lines: ").append(this.toIndentedString(this.lines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

