/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.CaptionPosition;
import com.aspose.asposecloudpdf.model.Color;
import com.aspose.asposecloudpdf.model.LineEnding;
import com.aspose.asposecloudpdf.model.LineIntent;
import com.aspose.asposecloudpdf.model.MarkupAnnotation;
import com.aspose.asposecloudpdf.model.Point;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Provides LineAnnotation.")
public class LineAnnotation
extends MarkupAnnotation {
    @SerializedName(value="Starting")
    private Point starting = null;
    @SerializedName(value="StartingStyle")
    private LineEnding startingStyle = null;
    @SerializedName(value="Ending")
    private Point ending = null;
    @SerializedName(value="EndingStyle")
    private LineEnding endingStyle = null;
    @SerializedName(value="InteriorColor")
    private Color interiorColor = null;
    @SerializedName(value="LeaderLine")
    private Double leaderLine = null;
    @SerializedName(value="LeaderLineExtension")
    private Double leaderLineExtension = null;
    @SerializedName(value="LeaderLineOffset")
    private Double leaderLineOffset = null;
    @SerializedName(value="ShowCaption")
    private Boolean showCaption = null;
    @SerializedName(value="CaptionOffset")
    private Point captionOffset = null;
    @SerializedName(value="CaptionPosition")
    private CaptionPosition captionPosition = null;
    @SerializedName(value="Intent")
    private LineIntent intent = null;

    public LineAnnotation starting(Point starting) {
        this.starting = starting;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets starting point of line.")
    public Point getStarting() {
        return this.starting;
    }

    public void setStarting(Point starting) {
        this.starting = starting;
    }

    public LineAnnotation startingStyle(LineEnding startingStyle) {
        this.startingStyle = startingStyle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets line ending style for line starting point.")
    public LineEnding getStartingStyle() {
        return this.startingStyle;
    }

    public void setStartingStyle(LineEnding startingStyle) {
        this.startingStyle = startingStyle;
    }

    public LineAnnotation ending(Point ending) {
        this.ending = ending;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets ending point of line.")
    public Point getEnding() {
        return this.ending;
    }

    public void setEnding(Point ending) {
        this.ending = ending;
    }

    public LineAnnotation endingStyle(LineEnding endingStyle) {
        this.endingStyle = endingStyle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets ending style for end point of line.")
    public LineEnding getEndingStyle() {
        return this.endingStyle;
    }

    public void setEndingStyle(LineEnding endingStyle) {
        this.endingStyle = endingStyle;
    }

    public LineAnnotation interiorColor(Color interiorColor) {
        this.interiorColor = interiorColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets interior color of the annotation.")
    public Color getInteriorColor() {
        return this.interiorColor;
    }

    public void setInteriorColor(Color interiorColor) {
        this.interiorColor = interiorColor;
    }

    public LineAnnotation leaderLine(Double leaderLine) {
        this.leaderLine = leaderLine;
        return this;
    }

    @ApiModelProperty(value="Gets or sets leader line length.")
    public Double getLeaderLine() {
        return this.leaderLine;
    }

    public void setLeaderLine(Double leaderLine) {
        this.leaderLine = leaderLine;
    }

    public LineAnnotation leaderLineExtension(Double leaderLineExtension) {
        this.leaderLineExtension = leaderLineExtension;
        return this;
    }

    @ApiModelProperty(value="Gets or sets length of leader line extension.")
    public Double getLeaderLineExtension() {
        return this.leaderLineExtension;
    }

    public void setLeaderLineExtension(Double leaderLineExtension) {
        this.leaderLineExtension = leaderLineExtension;
    }

    public LineAnnotation leaderLineOffset(Double leaderLineOffset) {
        this.leaderLineOffset = leaderLineOffset;
        return this;
    }

    @ApiModelProperty(value="Gets or sets leader line offset.")
    public Double getLeaderLineOffset() {
        return this.leaderLineOffset;
    }

    public void setLeaderLineOffset(Double leaderLineOffset) {
        this.leaderLineOffset = leaderLineOffset;
    }

    public LineAnnotation showCaption(Boolean showCaption) {
        this.showCaption = showCaption;
        return this;
    }

    @ApiModelProperty(value="Gets or sets boolean flag which determinies is contents must be shown as caption.")
    public Boolean isShowCaption() {
        return this.showCaption;
    }

    public void setShowCaption(Boolean showCaption) {
        this.showCaption = showCaption;
    }

    public LineAnnotation captionOffset(Point captionOffset) {
        this.captionOffset = captionOffset;
        return this;
    }

    @ApiModelProperty(value="Gets or sets caption text offset from its normal position.")
    public Point getCaptionOffset() {
        return this.captionOffset;
    }

    public void setCaptionOffset(Point captionOffset) {
        this.captionOffset = captionOffset;
    }

    public LineAnnotation captionPosition(CaptionPosition captionPosition) {
        this.captionPosition = captionPosition;
        return this;
    }

    @ApiModelProperty(value="Gets or sets annotation caption position.")
    public CaptionPosition getCaptionPosition() {
        return this.captionPosition;
    }

    public void setCaptionPosition(CaptionPosition captionPosition) {
        this.captionPosition = captionPosition;
    }

    public LineAnnotation intent(LineIntent intent) {
        this.intent = intent;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the intent of the line annotation.")
    public LineIntent getIntent() {
        return this.intent;
    }

    public void setIntent(LineIntent intent) {
        this.intent = intent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineAnnotation lineAnnotation = (LineAnnotation)o;
        return Objects.equals(this.starting, lineAnnotation.starting) && Objects.equals((Object)this.startingStyle, (Object)lineAnnotation.startingStyle) && Objects.equals(this.ending, lineAnnotation.ending) && Objects.equals((Object)this.endingStyle, (Object)lineAnnotation.endingStyle) && Objects.equals(this.interiorColor, lineAnnotation.interiorColor) && Objects.equals(this.leaderLine, lineAnnotation.leaderLine) && Objects.equals(this.leaderLineExtension, lineAnnotation.leaderLineExtension) && Objects.equals(this.leaderLineOffset, lineAnnotation.leaderLineOffset) && Objects.equals(this.showCaption, lineAnnotation.showCaption) && Objects.equals(this.captionOffset, lineAnnotation.captionOffset) && Objects.equals((Object)this.captionPosition, (Object)lineAnnotation.captionPosition) && Objects.equals((Object)this.intent, (Object)lineAnnotation.intent) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.starting, this.startingStyle, this.ending, this.endingStyle, this.interiorColor, this.leaderLine, this.leaderLineExtension, this.leaderLineOffset, this.showCaption, this.captionOffset, this.captionPosition, this.intent, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineAnnotation {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    starting: ").append(this.toIndentedString(this.starting)).append("\n");
        sb.append("    startingStyle: ").append(this.toIndentedString((Object)this.startingStyle)).append("\n");
        sb.append("    ending: ").append(this.toIndentedString(this.ending)).append("\n");
        sb.append("    endingStyle: ").append(this.toIndentedString((Object)this.endingStyle)).append("\n");
        sb.append("    interiorColor: ").append(this.toIndentedString(this.interiorColor)).append("\n");
        sb.append("    leaderLine: ").append(this.toIndentedString(this.leaderLine)).append("\n");
        sb.append("    leaderLineExtension: ").append(this.toIndentedString(this.leaderLineExtension)).append("\n");
        sb.append("    leaderLineOffset: ").append(this.toIndentedString(this.leaderLineOffset)).append("\n");
        sb.append("    showCaption: ").append(this.toIndentedString(this.showCaption)).append("\n");
        sb.append("    captionOffset: ").append(this.toIndentedString(this.captionOffset)).append("\n");
        sb.append("    captionPosition: ").append(this.toIndentedString((Object)this.captionPosition)).append("\n");
        sb.append("    intent: ").append(this.toIndentedString((Object)this.intent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

