/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.ImageTemplate;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Create document from images request.")
public class ImageTemplatesRequest {
    @SerializedName(value="IsOCR")
    private Boolean isOCR = null;
    @SerializedName(value="OCRLangs")
    private String ocRLangs = null;
    @SerializedName(value="ImagesList")
    private List<ImageTemplate> imagesList = new ArrayList<ImageTemplate>();

    public ImageTemplatesRequest isOCR(Boolean isOCR) {
        this.isOCR = isOCR;
        return this;
    }

    @ApiModelProperty(required=true, value="Using OCR function.")
    public Boolean isIsOCR() {
        return this.isOCR;
    }

    public void setIsOCR(Boolean isOCR) {
        this.isOCR = isOCR;
    }

    public ImageTemplatesRequest ocRLangs(String ocRLangs) {
        this.ocRLangs = ocRLangs;
        return this;
    }

    @ApiModelProperty(value="Language for recognition possible values: eng, ara, bel, ben, bul, ces, dan, deu, ell, fin, fra, heb, hin, ind, isl, ita, jpn, kor, nld, nor, pol, por, ron, rus, spa, swe, tha, tur, ukr, vie, chi_sim, chi_tra      or thier combination e.g. eng+rus")
    public String getOcRLangs() {
        return this.ocRLangs;
    }

    public void setOcRLangs(String ocRLangs) {
        this.ocRLangs = ocRLangs;
    }

    public ImageTemplatesRequest imagesList(List<ImageTemplate> imagesList) {
        this.imagesList = imagesList;
        return this;
    }

    public ImageTemplatesRequest addImagesListItem(ImageTemplate imagesListItem) {
        this.imagesList.add(imagesListItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A List of objects describing images to be added.")
    public List<ImageTemplate> getImagesList() {
        return this.imagesList;
    }

    public void setImagesList(List<ImageTemplate> imagesList) {
        this.imagesList = imagesList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageTemplatesRequest imageTemplatesRequest = (ImageTemplatesRequest)o;
        return Objects.equals(this.isOCR, imageTemplatesRequest.isOCR) && Objects.equals(this.ocRLangs, imageTemplatesRequest.ocRLangs) && Objects.equals(this.imagesList, imageTemplatesRequest.imagesList);
    }

    public int hashCode() {
        return Objects.hash(this.isOCR, this.ocRLangs, this.imagesList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageTemplatesRequest {\n");
        sb.append("    isOCR: ").append(this.toIndentedString(this.isOCR)).append("\n");
        sb.append("    ocRLangs: ").append(this.toIndentedString(this.ocRLangs)).append("\n");
        sb.append("    imagesList: ").append(this.toIndentedString(this.imagesList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

