/**
 *
 *   Copyright (c) 2020 Aspose.PDF Cloud
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */


package com.aspose.asposecloudpdf.api;

import com.aspose.asposecloudpdf.ApiCallback;
import com.aspose.asposecloudpdf.ApiClient;
import com.aspose.asposecloudpdf.ApiException;
import com.aspose.asposecloudpdf.ApiResponse;
import com.aspose.asposecloudpdf.Configuration;
import com.aspose.asposecloudpdf.Pair;
import com.aspose.asposecloudpdf.ProgressRequestBody;
import com.aspose.asposecloudpdf.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.aspose.asposecloudpdf.model.AnnotationType;
import com.aspose.asposecloudpdf.model.AnnotationsInfoResponse;
import com.aspose.asposecloudpdf.model.AsposeResponse;
import com.aspose.asposecloudpdf.model.AttachmentResponse;
import com.aspose.asposecloudpdf.model.AttachmentsResponse;
import com.aspose.asposecloudpdf.model.Bookmark;
import com.aspose.asposecloudpdf.model.BookmarkResponse;
import com.aspose.asposecloudpdf.model.BookmarksResponse;
import com.aspose.asposecloudpdf.model.CaretAnnotation;
import com.aspose.asposecloudpdf.model.CaretAnnotationResponse;
import com.aspose.asposecloudpdf.model.CaretAnnotationsResponse;
import com.aspose.asposecloudpdf.model.CheckBoxField;
import com.aspose.asposecloudpdf.model.CheckBoxFieldResponse;
import com.aspose.asposecloudpdf.model.CheckBoxFieldsResponse;
import com.aspose.asposecloudpdf.model.CircleAnnotation;
import com.aspose.asposecloudpdf.model.CircleAnnotationResponse;
import com.aspose.asposecloudpdf.model.CircleAnnotationsResponse;
import com.aspose.asposecloudpdf.model.ComboBoxField;
import com.aspose.asposecloudpdf.model.ComboBoxFieldResponse;
import com.aspose.asposecloudpdf.model.ComboBoxFieldsResponse;
import com.aspose.asposecloudpdf.model.DiscUsage;
import com.aspose.asposecloudpdf.model.DisplayProperties;
import com.aspose.asposecloudpdf.model.DisplayPropertiesResponse;
import com.aspose.asposecloudpdf.model.DocumentConfig;
import com.aspose.asposecloudpdf.model.DocumentPageResponse;
import com.aspose.asposecloudpdf.model.DocumentPagesResponse;
import com.aspose.asposecloudpdf.model.DocumentPrivilege;
import com.aspose.asposecloudpdf.model.DocumentPropertiesResponse;
import com.aspose.asposecloudpdf.model.DocumentPropertyResponse;
import com.aspose.asposecloudpdf.model.DocumentResponse;
import com.aspose.asposecloudpdf.model.Field;
import com.aspose.asposecloudpdf.model.FieldResponse;
import com.aspose.asposecloudpdf.model.Fields;
import com.aspose.asposecloudpdf.model.FieldsResponse;
import java.io.File;
import com.aspose.asposecloudpdf.model.FileAttachmentAnnotation;
import com.aspose.asposecloudpdf.model.FileAttachmentAnnotationResponse;
import com.aspose.asposecloudpdf.model.FileAttachmentAnnotationsResponse;
import com.aspose.asposecloudpdf.model.FileVersions;
import com.aspose.asposecloudpdf.model.FilesList;
import com.aspose.asposecloudpdf.model.FilesUploadResult;
import com.aspose.asposecloudpdf.model.FreeTextAnnotation;
import com.aspose.asposecloudpdf.model.FreeTextAnnotationResponse;
import com.aspose.asposecloudpdf.model.FreeTextAnnotationsResponse;
import com.aspose.asposecloudpdf.model.HighlightAnnotation;
import com.aspose.asposecloudpdf.model.HighlightAnnotationResponse;
import com.aspose.asposecloudpdf.model.HighlightAnnotationsResponse;
import com.aspose.asposecloudpdf.model.ImageFooter;
import com.aspose.asposecloudpdf.model.ImageHeader;
import com.aspose.asposecloudpdf.model.ImageResponse;
import com.aspose.asposecloudpdf.model.ImageStamp;
import com.aspose.asposecloudpdf.model.ImageTemplatesRequest;
import com.aspose.asposecloudpdf.model.ImagesResponse;
import com.aspose.asposecloudpdf.model.InkAnnotation;
import com.aspose.asposecloudpdf.model.InkAnnotationResponse;
import com.aspose.asposecloudpdf.model.InkAnnotationsResponse;
import com.aspose.asposecloudpdf.model.LineAnnotation;
import com.aspose.asposecloudpdf.model.LineAnnotationResponse;
import com.aspose.asposecloudpdf.model.LineAnnotationsResponse;
import com.aspose.asposecloudpdf.model.LinkAnnotation;
import com.aspose.asposecloudpdf.model.LinkAnnotationResponse;
import com.aspose.asposecloudpdf.model.LinkAnnotationsResponse;
import com.aspose.asposecloudpdf.model.ListBoxField;
import com.aspose.asposecloudpdf.model.ListBoxFieldResponse;
import com.aspose.asposecloudpdf.model.ListBoxFieldsResponse;
import com.aspose.asposecloudpdf.model.MergeDocuments;
import com.aspose.asposecloudpdf.model.MovieAnnotation;
import com.aspose.asposecloudpdf.model.MovieAnnotationResponse;
import com.aspose.asposecloudpdf.model.MovieAnnotationsResponse;
import com.aspose.asposecloudpdf.model.ObjectExist;
import com.aspose.asposecloudpdf.model.OptimizeOptions;
import com.aspose.asposecloudpdf.model.PageNumberStamp;
import com.aspose.asposecloudpdf.model.Paragraph;
import com.aspose.asposecloudpdf.model.PdfPageStamp;
import com.aspose.asposecloudpdf.model.PermissionsFlags;
import com.aspose.asposecloudpdf.model.PolyLineAnnotation;
import com.aspose.asposecloudpdf.model.PolyLineAnnotationResponse;
import com.aspose.asposecloudpdf.model.PolyLineAnnotationsResponse;
import com.aspose.asposecloudpdf.model.PolygonAnnotation;
import com.aspose.asposecloudpdf.model.PolygonAnnotationResponse;
import com.aspose.asposecloudpdf.model.PolygonAnnotationsResponse;
import com.aspose.asposecloudpdf.model.PopupAnnotation;
import com.aspose.asposecloudpdf.model.PopupAnnotationResponse;
import com.aspose.asposecloudpdf.model.PopupAnnotationsResponse;
import com.aspose.asposecloudpdf.model.RadioButtonField;
import com.aspose.asposecloudpdf.model.RadioButtonFieldResponse;
import com.aspose.asposecloudpdf.model.RadioButtonFieldsResponse;
import com.aspose.asposecloudpdf.model.RedactionAnnotation;
import com.aspose.asposecloudpdf.model.RedactionAnnotationResponse;
import com.aspose.asposecloudpdf.model.RedactionAnnotationsResponse;
import com.aspose.asposecloudpdf.model.ScreenAnnotation;
import com.aspose.asposecloudpdf.model.ScreenAnnotationResponse;
import com.aspose.asposecloudpdf.model.ScreenAnnotationsResponse;
import com.aspose.asposecloudpdf.model.Signature;
import com.aspose.asposecloudpdf.model.SignatureField;
import com.aspose.asposecloudpdf.model.SignatureFieldResponse;
import com.aspose.asposecloudpdf.model.SignatureFieldsResponse;
import com.aspose.asposecloudpdf.model.SignatureVerifyResponse;
import com.aspose.asposecloudpdf.model.SoundAnnotation;
import com.aspose.asposecloudpdf.model.SoundAnnotationResponse;
import com.aspose.asposecloudpdf.model.SoundAnnotationsResponse;
import com.aspose.asposecloudpdf.model.SplitResultResponse;
import com.aspose.asposecloudpdf.model.SquareAnnotation;
import com.aspose.asposecloudpdf.model.SquareAnnotationResponse;
import com.aspose.asposecloudpdf.model.SquareAnnotationsResponse;
import com.aspose.asposecloudpdf.model.SquigglyAnnotation;
import com.aspose.asposecloudpdf.model.SquigglyAnnotationResponse;
import com.aspose.asposecloudpdf.model.SquigglyAnnotationsResponse;
import com.aspose.asposecloudpdf.model.Stamp;
import com.aspose.asposecloudpdf.model.StampAnnotation;
import com.aspose.asposecloudpdf.model.StampAnnotationResponse;
import com.aspose.asposecloudpdf.model.StampAnnotationsResponse;
import com.aspose.asposecloudpdf.model.StampsInfoResponse;
import com.aspose.asposecloudpdf.model.StorageExist;
import com.aspose.asposecloudpdf.model.StrikeOutAnnotation;
import com.aspose.asposecloudpdf.model.StrikeOutAnnotationResponse;
import com.aspose.asposecloudpdf.model.StrikeOutAnnotationsResponse;
import com.aspose.asposecloudpdf.model.Table;
import com.aspose.asposecloudpdf.model.TableRecognizedResponse;
import com.aspose.asposecloudpdf.model.TablesRecognizedResponse;
import com.aspose.asposecloudpdf.model.TextAnnotation;
import com.aspose.asposecloudpdf.model.TextAnnotationResponse;
import com.aspose.asposecloudpdf.model.TextAnnotationsResponse;
import com.aspose.asposecloudpdf.model.TextBoxField;
import com.aspose.asposecloudpdf.model.TextBoxFieldResponse;
import com.aspose.asposecloudpdf.model.TextBoxFieldsResponse;
import com.aspose.asposecloudpdf.model.TextFooter;
import com.aspose.asposecloudpdf.model.TextHeader;
import com.aspose.asposecloudpdf.model.TextRectsResponse;
import com.aspose.asposecloudpdf.model.TextReplaceListRequest;
import com.aspose.asposecloudpdf.model.TextReplaceResponse;
import com.aspose.asposecloudpdf.model.TextStamp;
import com.aspose.asposecloudpdf.model.UnderlineAnnotation;
import com.aspose.asposecloudpdf.model.UnderlineAnnotationResponse;
import com.aspose.asposecloudpdf.model.UnderlineAnnotationsResponse;
import com.aspose.asposecloudpdf.model.WordCountResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdfApi {
    private ApiClient apiClient;

    public PdfApi(String appKey, String appSid) {
        this(Configuration.getDefaultApiClient());
        apiClient.setAppKey(appKey);
        apiClient.setAppSid(appSid);
    }

    public PdfApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for copyFile
     * @param srcPath Source file path e.g. &#39;/folder/file.ext&#39; (required)
     * @param destPath Destination file path (required)
     * @param srcStorageName Source storage name (optional)
     * @param destStorageName Destination storage name (optional)
     * @param versionId File version ID to copy (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call copyFileCall(String srcPath, String destPath, String srcStorageName, String destStorageName, String versionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/storage/file/copy/{srcPath}"
            .replaceAll("\\{" + "srcPath" + "\\}", apiClient.escapePathSegmentString(srcPath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (destPath != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("destPath", destPath));
        if (srcStorageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("srcStorageName", srcStorageName));
        if (destStorageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("destStorageName", destStorageName));
        if (versionId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("versionId", versionId));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call copyFileValidateBeforeCall(String srcPath, String destPath, String srcStorageName, String destStorageName, String versionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'srcPath' is set
        if (srcPath == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling copyFile(Async)");
        }
        
        // verify the required parameter 'destPath' is set
        if (destPath == null) {
            throw new ApiException("Missing the required parameter 'destPath' when calling copyFile(Async)");
        }
        

        com.squareup.okhttp.Call call = copyFileCall(srcPath, destPath, srcStorageName, destStorageName, versionId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Copy file
     * 
     * @param srcPath Source file path e.g. &#39;/folder/file.ext&#39; (required)
     * @param destPath Destination file path (required)
     * @param srcStorageName Source storage name (optional)
     * @param destStorageName Destination storage name (optional)
     * @param versionId File version ID to copy (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void copyFile(String srcPath, String destPath, String srcStorageName, String destStorageName, String versionId) throws ApiException {
        try
        {
            copyFileWithHttpInfo(srcPath, destPath, srcStorageName, destStorageName, versionId);
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                copyFileWithHttpInfo(srcPath, destPath, srcStorageName, destStorageName, versionId);
            }
            throw ex;
        }
    }

    /**
     * Copy file
     * 
     * @param srcPath Source file path e.g. &#39;/folder/file.ext&#39; (required)
     * @param destPath Destination file path (required)
     * @param srcStorageName Source storage name (optional)
     * @param destStorageName Destination storage name (optional)
     * @param versionId File version ID to copy (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> copyFileWithHttpInfo(String srcPath, String destPath, String srcStorageName, String destStorageName, String versionId) throws ApiException {
        com.squareup.okhttp.Call call = copyFileValidateBeforeCall(srcPath, destPath, srcStorageName, destStorageName, versionId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Copy file (asynchronously)
     * 
     * @param srcPath Source file path e.g. &#39;/folder/file.ext&#39; (required)
     * @param destPath Destination file path (required)
     * @param srcStorageName Source storage name (optional)
     * @param destStorageName Destination storage name (optional)
     * @param versionId File version ID to copy (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call copyFileAsync(String srcPath, String destPath, String srcStorageName, String destStorageName, String versionId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = copyFileValidateBeforeCall(srcPath, destPath, srcStorageName, destStorageName, versionId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for copyFolder
     * @param srcPath Source folder path e.g. &#39;/src&#39; (required)
     * @param destPath Destination folder path e.g. &#39;/dst&#39; (required)
     * @param srcStorageName Source storage name (optional)
     * @param destStorageName Destination storage name (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call copyFolderCall(String srcPath, String destPath, String srcStorageName, String destStorageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/storage/folder/copy/{srcPath}"
            .replaceAll("\\{" + "srcPath" + "\\}", apiClient.escapePathSegmentString(srcPath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (destPath != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("destPath", destPath));
        if (srcStorageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("srcStorageName", srcStorageName));
        if (destStorageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("destStorageName", destStorageName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call copyFolderValidateBeforeCall(String srcPath, String destPath, String srcStorageName, String destStorageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'srcPath' is set
        if (srcPath == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling copyFolder(Async)");
        }
        
        // verify the required parameter 'destPath' is set
        if (destPath == null) {
            throw new ApiException("Missing the required parameter 'destPath' when calling copyFolder(Async)");
        }
        

        com.squareup.okhttp.Call call = copyFolderCall(srcPath, destPath, srcStorageName, destStorageName, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Copy folder
     * 
     * @param srcPath Source folder path e.g. &#39;/src&#39; (required)
     * @param destPath Destination folder path e.g. &#39;/dst&#39; (required)
     * @param srcStorageName Source storage name (optional)
     * @param destStorageName Destination storage name (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void copyFolder(String srcPath, String destPath, String srcStorageName, String destStorageName) throws ApiException {
        try
        {
            copyFolderWithHttpInfo(srcPath, destPath, srcStorageName, destStorageName);
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                copyFolderWithHttpInfo(srcPath, destPath, srcStorageName, destStorageName);
            }
            throw ex;
        }
    }

    /**
     * Copy folder
     * 
     * @param srcPath Source folder path e.g. &#39;/src&#39; (required)
     * @param destPath Destination folder path e.g. &#39;/dst&#39; (required)
     * @param srcStorageName Source storage name (optional)
     * @param destStorageName Destination storage name (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> copyFolderWithHttpInfo(String srcPath, String destPath, String srcStorageName, String destStorageName) throws ApiException {
        com.squareup.okhttp.Call call = copyFolderValidateBeforeCall(srcPath, destPath, srcStorageName, destStorageName, null, null);
        return apiClient.execute(call);
    }

    /**
     * Copy folder (asynchronously)
     * 
     * @param srcPath Source folder path e.g. &#39;/src&#39; (required)
     * @param destPath Destination folder path e.g. &#39;/dst&#39; (required)
     * @param srcStorageName Source storage name (optional)
     * @param destStorageName Destination storage name (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call copyFolderAsync(String srcPath, String destPath, String srcStorageName, String destStorageName, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = copyFolderValidateBeforeCall(srcPath, destPath, srcStorageName, destStorageName, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for createFolder
     * @param path Folder path to create e.g. &#39;folder_1/folder_2/&#39; (required)
     * @param storageName Storage name (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createFolderCall(String path, String storageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/storage/folder/{path}"
            .replaceAll("\\{" + "path" + "\\}", apiClient.escapePathSegmentString(path.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storageName", storageName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createFolderValidateBeforeCall(String path, String storageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling createFolder(Async)");
        }
        

        com.squareup.okhttp.Call call = createFolderCall(path, storageName, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create the folder
     * 
     * @param path Folder path to create e.g. &#39;folder_1/folder_2/&#39; (required)
     * @param storageName Storage name (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void createFolder(String path, String storageName) throws ApiException {
        try
        {
            createFolderWithHttpInfo(path, storageName);
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                createFolderWithHttpInfo(path, storageName);
            }
            throw ex;
        }
    }

    /**
     * Create the folder
     * 
     * @param path Folder path to create e.g. &#39;folder_1/folder_2/&#39; (required)
     * @param storageName Storage name (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> createFolderWithHttpInfo(String path, String storageName) throws ApiException {
        com.squareup.okhttp.Call call = createFolderValidateBeforeCall(path, storageName, null, null);
        return apiClient.execute(call);
    }

    /**
     * Create the folder (asynchronously)
     * 
     * @param path Folder path to create e.g. &#39;folder_1/folder_2/&#39; (required)
     * @param storageName Storage name (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createFolderAsync(String path, String storageName, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createFolderValidateBeforeCall(path, storageName, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteAnnotation
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteAnnotationCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/{annotationId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteAnnotationValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteAnnotation(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling deleteAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteAnnotationCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete document annotation by ID
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteAnnotation(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteAnnotationWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteAnnotationWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete document annotation by ID
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteAnnotationWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deleteAnnotationValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete document annotation by ID (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteAnnotationAsync(String name, String annotationId, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteAnnotationValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteBookmark
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteBookmarkCall(String name, String bookmarkPath, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/bookmarks/bookmark/{bookmarkPath}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "bookmarkPath" + "\\}", apiClient.escapePathSegmentString(bookmarkPath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteBookmarkValidateBeforeCall(String name, String bookmarkPath, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteBookmark(Async)");
        }
        
        // verify the required parameter 'bookmarkPath' is set
        if (bookmarkPath == null) {
            throw new ApiException("Missing the required parameter 'bookmarkPath' when calling deleteBookmark(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteBookmarkCall(name, bookmarkPath, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete document bookmark by ID.
     * 
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteBookmark(String name, String bookmarkPath, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteBookmarkWithHttpInfo(name, bookmarkPath, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteBookmarkWithHttpInfo(name, bookmarkPath, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete document bookmark by ID.
     * 
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteBookmarkWithHttpInfo(String name, String bookmarkPath, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = deleteBookmarkValidateBeforeCall(name, bookmarkPath, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete document bookmark by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteBookmarkAsync(String name, String bookmarkPath, String folder, String storage, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteBookmarkValidateBeforeCall(name, bookmarkPath, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteDocumentAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDocumentAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteDocumentAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteDocumentAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all annotations from the document
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteDocumentAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteDocumentAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteDocumentAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete all annotations from the document
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteDocumentAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deleteDocumentAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all annotations from the document (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentAnnotationsAsync(String name, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteDocumentAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteDocumentBookmarks
     * @param name The document name. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentBookmarksCall(String name, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/bookmarks/tree"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDocumentBookmarksValidateBeforeCall(String name, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteDocumentBookmarks(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteDocumentBookmarksCall(name, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all document bookmarks.
     * 
     * @param name The document name. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteDocumentBookmarks(String name, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteDocumentBookmarksWithHttpInfo(name, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteDocumentBookmarksWithHttpInfo(name, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete all document bookmarks.
     * 
     * @param name The document name. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteDocumentBookmarksWithHttpInfo(String name, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = deleteDocumentBookmarksValidateBeforeCall(name, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all document bookmarks. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentBookmarksAsync(String name, String folder, String storage, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteDocumentBookmarksValidateBeforeCall(name, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteDocumentLinkAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentLinkAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/links"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDocumentLinkAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteDocumentLinkAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteDocumentLinkAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all link annotations from the document
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteDocumentLinkAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteDocumentLinkAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteDocumentLinkAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete all link annotations from the document
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteDocumentLinkAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deleteDocumentLinkAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all link annotations from the document (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentLinkAnnotationsAsync(String name, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteDocumentLinkAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteDocumentStamps
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentStampsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/stamps"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDocumentStampsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteDocumentStamps(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteDocumentStampsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all stamps from the document
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteDocumentStamps(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteDocumentStampsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteDocumentStampsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete all stamps from the document
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteDocumentStampsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deleteDocumentStampsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all stamps from the document (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentStampsAsync(String name, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteDocumentStampsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteDocumentTables
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentTablesCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/tables"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDocumentTablesValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteDocumentTables(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteDocumentTablesCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all tables from the document
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteDocumentTables(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteDocumentTablesWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteDocumentTablesWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete all tables from the document
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteDocumentTablesWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deleteDocumentTablesValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all tables from the document (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteDocumentTablesAsync(String name, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteDocumentTablesValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteField
     * @param name The document name. (required)
     * @param fieldName The field name/ (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFieldCall(String name, String fieldName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/{fieldName}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "fieldName" + "\\}", apiClient.escapePathSegmentString(fieldName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFieldValidateBeforeCall(String name, String fieldName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteField(Async)");
        }
        
        // verify the required parameter 'fieldName' is set
        if (fieldName == null) {
            throw new ApiException("Missing the required parameter 'fieldName' when calling deleteField(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteFieldCall(name, fieldName, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete document field by name.
     * 
     * @param name The document name. (required)
     * @param fieldName The field name/ (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteField(String name, String fieldName, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteFieldWithHttpInfo(name, fieldName, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteFieldWithHttpInfo(name, fieldName, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete document field by name.
     * 
     * @param name The document name. (required)
     * @param fieldName The field name/ (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteFieldWithHttpInfo(String name, String fieldName, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deleteFieldValidateBeforeCall(name, fieldName, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete document field by name. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param fieldName The field name/ (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteFieldAsync(String name, String fieldName, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFieldValidateBeforeCall(name, fieldName, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteFile
     * @param path File path e.g. &#39;/folder/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @param versionId File version ID to delete (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFileCall(String path, String storageName, String versionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/storage/file/{path}"
            .replaceAll("\\{" + "path" + "\\}", apiClient.escapePathSegmentString(path.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storageName", storageName));
        if (versionId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("versionId", versionId));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFileValidateBeforeCall(String path, String storageName, String versionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling deleteFile(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteFileCall(path, storageName, versionId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete file
     * 
     * @param path File path e.g. &#39;/folder/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @param versionId File version ID to delete (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteFile(String path, String storageName, String versionId) throws ApiException {
        try
        {
            deleteFileWithHttpInfo(path, storageName, versionId);
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                deleteFileWithHttpInfo(path, storageName, versionId);
            }
            throw ex;
        }
    }

    /**
     * Delete file
     * 
     * @param path File path e.g. &#39;/folder/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @param versionId File version ID to delete (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteFileWithHttpInfo(String path, String storageName, String versionId) throws ApiException {
        com.squareup.okhttp.Call call = deleteFileValidateBeforeCall(path, storageName, versionId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete file (asynchronously)
     * 
     * @param path File path e.g. &#39;/folder/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @param versionId File version ID to delete (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteFileAsync(String path, String storageName, String versionId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFileValidateBeforeCall(path, storageName, versionId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteFolder
     * @param path Folder path e.g. &#39;/folder&#39; (required)
     * @param storageName Storage name (optional)
     * @param recursive Enable to delete folders, subfolders and files (optional, default to false)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFolderCall(String path, String storageName, Boolean recursive, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/storage/folder/{path}"
            .replaceAll("\\{" + "path" + "\\}", apiClient.escapePathSegmentString(path.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storageName", storageName));
        if (recursive != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("recursive", recursive));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFolderValidateBeforeCall(String path, String storageName, Boolean recursive, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling deleteFolder(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteFolderCall(path, storageName, recursive, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete folder
     * 
     * @param path Folder path e.g. &#39;/folder&#39; (required)
     * @param storageName Storage name (optional)
     * @param recursive Enable to delete folders, subfolders and files (optional, default to false)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteFolder(String path, String storageName, Boolean recursive) throws ApiException {
        try
        {
            deleteFolderWithHttpInfo(path, storageName, recursive);
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                deleteFolderWithHttpInfo(path, storageName, recursive);
            }
            throw ex;
        }
    }

    /**
     * Delete folder
     * 
     * @param path Folder path e.g. &#39;/folder&#39; (required)
     * @param storageName Storage name (optional)
     * @param recursive Enable to delete folders, subfolders and files (optional, default to false)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteFolderWithHttpInfo(String path, String storageName, Boolean recursive) throws ApiException {
        com.squareup.okhttp.Call call = deleteFolderValidateBeforeCall(path, storageName, recursive, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete folder (asynchronously)
     * 
     * @param path Folder path e.g. &#39;/folder&#39; (required)
     * @param storageName Storage name (optional)
     * @param recursive Enable to delete folders, subfolders and files (optional, default to false)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteFolderAsync(String path, String storageName, Boolean recursive, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFolderValidateBeforeCall(path, storageName, recursive, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteImage
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteImageCall(String name, String imageId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/images/{imageId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "imageId" + "\\}", apiClient.escapePathSegmentString(imageId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteImageValidateBeforeCall(String name, String imageId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteImage(Async)");
        }
        
        // verify the required parameter 'imageId' is set
        if (imageId == null) {
            throw new ApiException("Missing the required parameter 'imageId' when calling deleteImage(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteImageCall(name, imageId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete image from document page.
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteImage(String name, String imageId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteImageWithHttpInfo(name, imageId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteImageWithHttpInfo(name, imageId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete image from document page.
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteImageWithHttpInfo(String name, String imageId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deleteImageValidateBeforeCall(name, imageId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete image from document page. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteImageAsync(String name, String imageId, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteImageValidateBeforeCall(name, imageId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteLinkAnnotation
     * @param name The document name. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteLinkAnnotationCall(String name, String linkId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/links/{linkId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "linkId" + "\\}", apiClient.escapePathSegmentString(linkId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteLinkAnnotationValidateBeforeCall(String name, String linkId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteLinkAnnotation(Async)");
        }
        
        // verify the required parameter 'linkId' is set
        if (linkId == null) {
            throw new ApiException("Missing the required parameter 'linkId' when calling deleteLinkAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteLinkAnnotationCall(name, linkId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete document page link annotation by ID
     * 
     * @param name The document name. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteLinkAnnotation(String name, String linkId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteLinkAnnotationWithHttpInfo(name, linkId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteLinkAnnotationWithHttpInfo(name, linkId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete document page link annotation by ID
     * 
     * @param name The document name. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteLinkAnnotationWithHttpInfo(String name, String linkId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deleteLinkAnnotationValidateBeforeCall(name, linkId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete document page link annotation by ID (asynchronously)
     * 
     * @param name The document name. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteLinkAnnotationAsync(String name, String linkId, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteLinkAnnotationValidateBeforeCall(name, linkId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deletePage
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletePageCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletePageValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deletePage(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling deletePage(Async)");
        }
        

        com.squareup.okhttp.Call call = deletePageCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete document page by its number.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deletePage(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deletePageWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deletePageWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete document page by its number.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deletePageWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deletePageValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete document page by its number. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletePageAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletePageValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deletePageAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletePageAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletePageAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deletePageAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling deletePageAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = deletePageAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all annotations from the page
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deletePageAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deletePageAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deletePageAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete all annotations from the page
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deletePageAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deletePageAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all annotations from the page (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletePageAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletePageAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deletePageLinkAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletePageLinkAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/links"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletePageLinkAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deletePageLinkAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling deletePageLinkAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = deletePageLinkAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all link annotations from the page
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deletePageLinkAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deletePageLinkAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deletePageLinkAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete all link annotations from the page
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deletePageLinkAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deletePageLinkAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all link annotations from the page (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletePageLinkAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletePageLinkAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deletePageStamps
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletePageStampsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/stamps"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletePageStampsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deletePageStamps(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling deletePageStamps(Async)");
        }
        

        com.squareup.okhttp.Call call = deletePageStampsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all stamps from the page
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deletePageStamps(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deletePageStampsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deletePageStampsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete all stamps from the page
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deletePageStampsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deletePageStampsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all stamps from the page (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletePageStampsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletePageStampsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deletePageTables
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletePageTablesCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/tables"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletePageTablesValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deletePageTables(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling deletePageTables(Async)");
        }
        

        com.squareup.okhttp.Call call = deletePageTablesCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete all tables from the page
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deletePageTables(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deletePageTablesWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deletePageTablesWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete all tables from the page
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deletePageTablesWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deletePageTablesValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete all tables from the page (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletePageTablesAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletePageTablesValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteProperties
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletePropertiesCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/documentproperties"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletePropertiesValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteProperties(Async)");
        }
        

        com.squareup.okhttp.Call call = deletePropertiesCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete custom document properties.
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteProperties(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deletePropertiesWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deletePropertiesWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete custom document properties.
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deletePropertiesWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deletePropertiesValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete custom document properties. (asynchronously)
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletePropertiesAsync(String name, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletePropertiesValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteProperty
     * @param name  (required)
     * @param propertyName  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletePropertyCall(String name, String propertyName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/documentproperties/{propertyName}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "propertyName" + "\\}", apiClient.escapePathSegmentString(propertyName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletePropertyValidateBeforeCall(String name, String propertyName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteProperty(Async)");
        }
        
        // verify the required parameter 'propertyName' is set
        if (propertyName == null) {
            throw new ApiException("Missing the required parameter 'propertyName' when calling deleteProperty(Async)");
        }
        

        com.squareup.okhttp.Call call = deletePropertyCall(name, propertyName, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete document property.
     * 
     * @param name  (required)
     * @param propertyName  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteProperty(String name, String propertyName, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deletePropertyWithHttpInfo(name, propertyName, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deletePropertyWithHttpInfo(name, propertyName, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete document property.
     * 
     * @param name  (required)
     * @param propertyName  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deletePropertyWithHttpInfo(String name, String propertyName, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deletePropertyValidateBeforeCall(name, propertyName, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete document property. (asynchronously)
     * 
     * @param name  (required)
     * @param propertyName  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletePropertyAsync(String name, String propertyName, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletePropertyValidateBeforeCall(name, propertyName, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteStamp
     * @param name The document name. (required)
     * @param stampId The stamp ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteStampCall(String name, String stampId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/stamps/{stampId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "stampId" + "\\}", apiClient.escapePathSegmentString(stampId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteStampValidateBeforeCall(String name, String stampId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteStamp(Async)");
        }
        
        // verify the required parameter 'stampId' is set
        if (stampId == null) {
            throw new ApiException("Missing the required parameter 'stampId' when calling deleteStamp(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteStampCall(name, stampId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete document stamp by ID
     * 
     * @param name The document name. (required)
     * @param stampId The stamp ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteStamp(String name, String stampId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteStampWithHttpInfo(name, stampId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteStampWithHttpInfo(name, stampId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete document stamp by ID
     * 
     * @param name The document name. (required)
     * @param stampId The stamp ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteStampWithHttpInfo(String name, String stampId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deleteStampValidateBeforeCall(name, stampId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete document stamp by ID (asynchronously)
     * 
     * @param name The document name. (required)
     * @param stampId The stamp ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteStampAsync(String name, String stampId, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteStampValidateBeforeCall(name, stampId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteTable
     * @param name The document name. (required)
     * @param tableId The table ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteTableCall(String name, String tableId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/tables/{tableId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "tableId" + "\\}", apiClient.escapePathSegmentString(tableId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteTableValidateBeforeCall(String name, String tableId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteTable(Async)");
        }
        
        // verify the required parameter 'tableId' is set
        if (tableId == null) {
            throw new ApiException("Missing the required parameter 'tableId' when calling deleteTable(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteTableCall(name, tableId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete document table by ID
     * 
     * @param name The document name. (required)
     * @param tableId The table ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AsposeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AsposeResponse deleteTable(String name, String tableId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AsposeResponse> resp = deleteTableWithHttpInfo(name, tableId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AsposeResponse> resp = deleteTableWithHttpInfo(name, tableId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Delete document table by ID
     * 
     * @param name The document name. (required)
     * @param tableId The table ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AsposeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AsposeResponse> deleteTableWithHttpInfo(String name, String tableId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = deleteTableValidateBeforeCall(name, tableId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete document table by ID (asynchronously)
     * 
     * @param name The document name. (required)
     * @param tableId The table ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteTableAsync(String name, String tableId, String storage, String folder, final ApiCallback<AsposeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteTableValidateBeforeCall(name, tableId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AsposeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for downloadFile
     * @param path File path e.g. &#39;/folder/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @param versionId File version ID to download (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call downloadFileCall(String path, String storageName, String versionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/storage/file/{path}"
            .replaceAll("\\{" + "path" + "\\}", apiClient.escapePathSegmentString(path.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storageName", storageName));
        if (versionId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("versionId", versionId));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call downloadFileValidateBeforeCall(String path, String storageName, String versionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling downloadFile(Async)");
        }
        

        com.squareup.okhttp.Call call = downloadFileCall(path, storageName, versionId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Download file
     * 
     * @param path File path e.g. &#39;/folder/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @param versionId File version ID to download (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File downloadFile(String path, String storageName, String versionId) throws ApiException {
        try
        {
            ApiResponse<File> resp = downloadFileWithHttpInfo(path, storageName, versionId);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = downloadFileWithHttpInfo(path, storageName, versionId);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Download file
     * 
     * @param path File path e.g. &#39;/folder/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @param versionId File version ID to download (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> downloadFileWithHttpInfo(String path, String storageName, String versionId) throws ApiException {
        com.squareup.okhttp.Call call = downloadFileValidateBeforeCall(path, storageName, versionId, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Download file (asynchronously)
     * 
     * @param path File path e.g. &#39;/folder/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @param versionId File version ID to download (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call downloadFileAsync(String path, String storageName, String versionId, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = downloadFileValidateBeforeCall(path, storageName, versionId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getBookmark
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBookmarkCall(String name, String bookmarkPath, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/bookmarks/bookmark/{bookmarkPath}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "bookmarkPath" + "\\}", apiClient.escapePathSegmentString(bookmarkPath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBookmarkValidateBeforeCall(String name, String bookmarkPath, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getBookmark(Async)");
        }
        
        // verify the required parameter 'bookmarkPath' is set
        if (bookmarkPath == null) {
            throw new ApiException("Missing the required parameter 'bookmarkPath' when calling getBookmark(Async)");
        }
        

        com.squareup.okhttp.Call call = getBookmarkCall(name, bookmarkPath, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document bookmark.
     * 
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return BookmarkResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BookmarkResponse getBookmark(String name, String bookmarkPath, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<BookmarkResponse> resp = getBookmarkWithHttpInfo(name, bookmarkPath, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<BookmarkResponse> resp = getBookmarkWithHttpInfo(name, bookmarkPath, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document bookmark.
     * 
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;BookmarkResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BookmarkResponse> getBookmarkWithHttpInfo(String name, String bookmarkPath, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getBookmarkValidateBeforeCall(name, bookmarkPath, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<BookmarkResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document bookmark. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getBookmarkAsync(String name, String bookmarkPath, String folder, String storage, final ApiCallback<BookmarkResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBookmarkValidateBeforeCall(name, bookmarkPath, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BookmarkResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getBookmarks
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBookmarksCall(String name, String bookmarkPath, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/bookmarks/list/{bookmarkPath}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "bookmarkPath" + "\\}", apiClient.escapePathSegmentString(bookmarkPath.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBookmarksValidateBeforeCall(String name, String bookmarkPath, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getBookmarks(Async)");
        }
        
        // verify the required parameter 'bookmarkPath' is set
        if (bookmarkPath == null) {
            throw new ApiException("Missing the required parameter 'bookmarkPath' when calling getBookmarks(Async)");
        }
        

        com.squareup.okhttp.Call call = getBookmarksCall(name, bookmarkPath, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document bookmarks node list.
     * 
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return BookmarksResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BookmarksResponse getBookmarks(String name, String bookmarkPath, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<BookmarksResponse> resp = getBookmarksWithHttpInfo(name, bookmarkPath, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<BookmarksResponse> resp = getBookmarksWithHttpInfo(name, bookmarkPath, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document bookmarks node list.
     * 
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;BookmarksResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BookmarksResponse> getBookmarksWithHttpInfo(String name, String bookmarkPath, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getBookmarksValidateBeforeCall(name, bookmarkPath, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<BookmarksResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document bookmarks node list. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param bookmarkPath The bookmark path. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getBookmarksAsync(String name, String bookmarkPath, String folder, String storage, final ApiCallback<BookmarksResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBookmarksValidateBeforeCall(name, bookmarkPath, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BookmarksResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCaretAnnotation
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCaretAnnotationCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/caret/{annotationId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCaretAnnotationValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getCaretAnnotation(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling getCaretAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = getCaretAnnotationCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page caret annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return CaretAnnotationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CaretAnnotationResponse getCaretAnnotation(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<CaretAnnotationResponse> resp = getCaretAnnotationWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<CaretAnnotationResponse> resp = getCaretAnnotationWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page caret annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;CaretAnnotationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CaretAnnotationResponse> getCaretAnnotationWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getCaretAnnotationValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<CaretAnnotationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page caret annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCaretAnnotationAsync(String name, String annotationId, String storage, String folder, final ApiCallback<CaretAnnotationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCaretAnnotationValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CaretAnnotationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCheckBoxField
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCheckBoxFieldCall(String name, String fieldName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/checkbox/{fieldName}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "fieldName" + "\\}", apiClient.escapePathSegmentString(fieldName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCheckBoxFieldValidateBeforeCall(String name, String fieldName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getCheckBoxField(Async)");
        }
        
        // verify the required parameter 'fieldName' is set
        if (fieldName == null) {
            throw new ApiException("Missing the required parameter 'fieldName' when calling getCheckBoxField(Async)");
        }
        

        com.squareup.okhttp.Call call = getCheckBoxFieldCall(name, fieldName, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document checkbox field by name.
     * 
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return CheckBoxFieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CheckBoxFieldResponse getCheckBoxField(String name, String fieldName, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<CheckBoxFieldResponse> resp = getCheckBoxFieldWithHttpInfo(name, fieldName, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<CheckBoxFieldResponse> resp = getCheckBoxFieldWithHttpInfo(name, fieldName, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document checkbox field by name.
     * 
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;CheckBoxFieldResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CheckBoxFieldResponse> getCheckBoxFieldWithHttpInfo(String name, String fieldName, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getCheckBoxFieldValidateBeforeCall(name, fieldName, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<CheckBoxFieldResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document checkbox field by name. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCheckBoxFieldAsync(String name, String fieldName, String storage, String folder, final ApiCallback<CheckBoxFieldResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCheckBoxFieldValidateBeforeCall(name, fieldName, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CheckBoxFieldResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCircleAnnotation
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCircleAnnotationCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/circle/{annotationId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCircleAnnotationValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getCircleAnnotation(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling getCircleAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = getCircleAnnotationCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page circle annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return CircleAnnotationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CircleAnnotationResponse getCircleAnnotation(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<CircleAnnotationResponse> resp = getCircleAnnotationWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<CircleAnnotationResponse> resp = getCircleAnnotationWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page circle annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;CircleAnnotationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CircleAnnotationResponse> getCircleAnnotationWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getCircleAnnotationValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<CircleAnnotationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page circle annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCircleAnnotationAsync(String name, String annotationId, String storage, String folder, final ApiCallback<CircleAnnotationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCircleAnnotationValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CircleAnnotationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getComboBoxField
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getComboBoxFieldCall(String name, String fieldName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/combobox/{fieldName}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "fieldName" + "\\}", apiClient.escapePathSegmentString(fieldName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getComboBoxFieldValidateBeforeCall(String name, String fieldName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getComboBoxField(Async)");
        }
        
        // verify the required parameter 'fieldName' is set
        if (fieldName == null) {
            throw new ApiException("Missing the required parameter 'fieldName' when calling getComboBoxField(Async)");
        }
        

        com.squareup.okhttp.Call call = getComboBoxFieldCall(name, fieldName, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document combobox field by name.
     * 
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ComboBoxFieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ComboBoxFieldResponse getComboBoxField(String name, String fieldName, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<ComboBoxFieldResponse> resp = getComboBoxFieldWithHttpInfo(name, fieldName, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<ComboBoxFieldResponse> resp = getComboBoxFieldWithHttpInfo(name, fieldName, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document combobox field by name.
     * 
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;ComboBoxFieldResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ComboBoxFieldResponse> getComboBoxFieldWithHttpInfo(String name, String fieldName, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getComboBoxFieldValidateBeforeCall(name, fieldName, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<ComboBoxFieldResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document combobox field by name. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getComboBoxFieldAsync(String name, String fieldName, String storage, String folder, final ApiCallback<ComboBoxFieldResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getComboBoxFieldValidateBeforeCall(name, fieldName, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ComboBoxFieldResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDiscUsage
     * @param storageName Storage name (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDiscUsageCall(String storageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/storage/disc";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storageName", storageName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDiscUsageValidateBeforeCall(String storageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getDiscUsageCall(storageName, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get disc usage
     * 
     * @param storageName Storage name (optional)
     * @return DiscUsage
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DiscUsage getDiscUsage(String storageName) throws ApiException {
        try
        {
            ApiResponse<DiscUsage> resp = getDiscUsageWithHttpInfo(storageName);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<DiscUsage> resp = getDiscUsageWithHttpInfo(storageName);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Get disc usage
     * 
     * @param storageName Storage name (optional)
     * @return ApiResponse&lt;DiscUsage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DiscUsage> getDiscUsageWithHttpInfo(String storageName) throws ApiException {
        com.squareup.okhttp.Call call = getDiscUsageValidateBeforeCall(storageName, null, null);
        Type localVarReturnType = new TypeToken<DiscUsage>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get disc usage (asynchronously)
     * 
     * @param storageName Storage name (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDiscUsageAsync(String storageName, final ApiCallback<DiscUsage> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDiscUsageValidateBeforeCall(storageName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DiscUsage>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocument
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocument(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read common document info.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return DocumentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DocumentResponse getDocument(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<DocumentResponse> resp = getDocumentWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<DocumentResponse> resp = getDocumentWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read common document info.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;DocumentResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DocumentResponse> getDocumentWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<DocumentResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read common document info. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentAsync(String name, String storage, String folder, final ApiCallback<DocumentResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read documant page annotations. Returns only FreeTextAnnotations, TextAnnotations, other annotations will implemented next releases.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AnnotationsInfoResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AnnotationsInfoResponse getDocumentAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AnnotationsInfoResponse> resp = getDocumentAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AnnotationsInfoResponse> resp = getDocumentAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read documant page annotations. Returns only FreeTextAnnotations, TextAnnotations, other annotations will implemented next releases.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AnnotationsInfoResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AnnotationsInfoResponse> getDocumentAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AnnotationsInfoResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read documant page annotations. Returns only FreeTextAnnotations, TextAnnotations, other annotations will implemented next releases. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentAnnotationsAsync(String name, String storage, String folder, final ApiCallback<AnnotationsInfoResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnnotationsInfoResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentAttachmentByIndex
     * @param name The document name. (required)
     * @param attachmentIndex The attachment index. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentAttachmentByIndexCall(String name, Integer attachmentIndex, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/attachments/{attachmentIndex}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "attachmentIndex" + "\\}", apiClient.escapePathSegmentString(attachmentIndex.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentAttachmentByIndexValidateBeforeCall(String name, Integer attachmentIndex, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentAttachmentByIndex(Async)");
        }
        
        // verify the required parameter 'attachmentIndex' is set
        if (attachmentIndex == null) {
            throw new ApiException("Missing the required parameter 'attachmentIndex' when calling getDocumentAttachmentByIndex(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentAttachmentByIndexCall(name, attachmentIndex, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document attachment info by its index.
     * 
     * @param name The document name. (required)
     * @param attachmentIndex The attachment index. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AttachmentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AttachmentResponse getDocumentAttachmentByIndex(String name, Integer attachmentIndex, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AttachmentResponse> resp = getDocumentAttachmentByIndexWithHttpInfo(name, attachmentIndex, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AttachmentResponse> resp = getDocumentAttachmentByIndexWithHttpInfo(name, attachmentIndex, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document attachment info by its index.
     * 
     * @param name The document name. (required)
     * @param attachmentIndex The attachment index. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AttachmentResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AttachmentResponse> getDocumentAttachmentByIndexWithHttpInfo(String name, Integer attachmentIndex, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentAttachmentByIndexValidateBeforeCall(name, attachmentIndex, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AttachmentResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document attachment info by its index. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param attachmentIndex The attachment index. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentAttachmentByIndexAsync(String name, Integer attachmentIndex, String storage, String folder, final ApiCallback<AttachmentResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentAttachmentByIndexValidateBeforeCall(name, attachmentIndex, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AttachmentResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentAttachments
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentAttachmentsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/attachments"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentAttachmentsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentAttachments(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentAttachmentsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document attachments info.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AttachmentsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AttachmentsResponse getDocumentAttachments(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AttachmentsResponse> resp = getDocumentAttachmentsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AttachmentsResponse> resp = getDocumentAttachmentsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document attachments info.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AttachmentsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AttachmentsResponse> getDocumentAttachmentsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentAttachmentsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AttachmentsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document attachments info. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentAttachmentsAsync(String name, String storage, String folder, final ApiCallback<AttachmentsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentAttachmentsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AttachmentsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentBookmarks
     * @param name The document name. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentBookmarksCall(String name, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/bookmarks/tree"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentBookmarksValidateBeforeCall(String name, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentBookmarks(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentBookmarksCall(name, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document bookmarks tree.
     * 
     * @param name The document name. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return BookmarksResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BookmarksResponse getDocumentBookmarks(String name, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<BookmarksResponse> resp = getDocumentBookmarksWithHttpInfo(name, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<BookmarksResponse> resp = getDocumentBookmarksWithHttpInfo(name, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document bookmarks tree.
     * 
     * @param name The document name. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;BookmarksResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BookmarksResponse> getDocumentBookmarksWithHttpInfo(String name, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentBookmarksValidateBeforeCall(name, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<BookmarksResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document bookmarks tree. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentBookmarksAsync(String name, String folder, String storage, final ApiCallback<BookmarksResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentBookmarksValidateBeforeCall(name, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BookmarksResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentCaretAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentCaretAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/caret"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentCaretAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentCaretAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentCaretAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document caret annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return CaretAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CaretAnnotationsResponse getDocumentCaretAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<CaretAnnotationsResponse> resp = getDocumentCaretAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<CaretAnnotationsResponse> resp = getDocumentCaretAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document caret annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;CaretAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CaretAnnotationsResponse> getDocumentCaretAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentCaretAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<CaretAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document caret annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentCaretAnnotationsAsync(String name, String storage, String folder, final ApiCallback<CaretAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentCaretAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CaretAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentCheckBoxFields
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentCheckBoxFieldsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/checkbox"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentCheckBoxFieldsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentCheckBoxFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentCheckBoxFieldsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document checkbox fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return CheckBoxFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CheckBoxFieldsResponse getDocumentCheckBoxFields(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<CheckBoxFieldsResponse> resp = getDocumentCheckBoxFieldsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<CheckBoxFieldsResponse> resp = getDocumentCheckBoxFieldsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document checkbox fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;CheckBoxFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CheckBoxFieldsResponse> getDocumentCheckBoxFieldsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentCheckBoxFieldsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<CheckBoxFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document checkbox fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentCheckBoxFieldsAsync(String name, String storage, String folder, final ApiCallback<CheckBoxFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentCheckBoxFieldsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CheckBoxFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentCircleAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentCircleAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/circle"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentCircleAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentCircleAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentCircleAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document circle annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return CircleAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CircleAnnotationsResponse getDocumentCircleAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<CircleAnnotationsResponse> resp = getDocumentCircleAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<CircleAnnotationsResponse> resp = getDocumentCircleAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document circle annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;CircleAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CircleAnnotationsResponse> getDocumentCircleAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentCircleAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<CircleAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document circle annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentCircleAnnotationsAsync(String name, String storage, String folder, final ApiCallback<CircleAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentCircleAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CircleAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentComboBoxFields
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentComboBoxFieldsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/combobox"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentComboBoxFieldsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentComboBoxFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentComboBoxFieldsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document combobox fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ComboBoxFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ComboBoxFieldsResponse getDocumentComboBoxFields(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<ComboBoxFieldsResponse> resp = getDocumentComboBoxFieldsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<ComboBoxFieldsResponse> resp = getDocumentComboBoxFieldsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document combobox fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;ComboBoxFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ComboBoxFieldsResponse> getDocumentComboBoxFieldsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentComboBoxFieldsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<ComboBoxFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document combobox fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentComboBoxFieldsAsync(String name, String storage, String folder, final ApiCallback<ComboBoxFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentComboBoxFieldsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ComboBoxFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentDisplayProperties
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentDisplayPropertiesCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/displayproperties"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentDisplayPropertiesValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentDisplayProperties(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentDisplayPropertiesCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document display properties.
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return DisplayPropertiesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DisplayPropertiesResponse getDocumentDisplayProperties(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<DisplayPropertiesResponse> resp = getDocumentDisplayPropertiesWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<DisplayPropertiesResponse> resp = getDocumentDisplayPropertiesWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document display properties.
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return ApiResponse&lt;DisplayPropertiesResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DisplayPropertiesResponse> getDocumentDisplayPropertiesWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentDisplayPropertiesValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<DisplayPropertiesResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document display properties. (asynchronously)
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentDisplayPropertiesAsync(String name, String storage, String folder, final ApiCallback<DisplayPropertiesResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentDisplayPropertiesValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DisplayPropertiesResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentFileAttachmentAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentFileAttachmentAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/fileattachment"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentFileAttachmentAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentFileAttachmentAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentFileAttachmentAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document FileAttachment annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return FileAttachmentAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FileAttachmentAnnotationsResponse getDocumentFileAttachmentAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<FileAttachmentAnnotationsResponse> resp = getDocumentFileAttachmentAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<FileAttachmentAnnotationsResponse> resp = getDocumentFileAttachmentAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document FileAttachment annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;FileAttachmentAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FileAttachmentAnnotationsResponse> getDocumentFileAttachmentAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentFileAttachmentAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<FileAttachmentAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document FileAttachment annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentFileAttachmentAnnotationsAsync(String name, String storage, String folder, final ApiCallback<FileAttachmentAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentFileAttachmentAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileAttachmentAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentFreeTextAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentFreeTextAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/freetext"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentFreeTextAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentFreeTextAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentFreeTextAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document free text annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return FreeTextAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FreeTextAnnotationsResponse getDocumentFreeTextAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<FreeTextAnnotationsResponse> resp = getDocumentFreeTextAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<FreeTextAnnotationsResponse> resp = getDocumentFreeTextAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document free text annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;FreeTextAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FreeTextAnnotationsResponse> getDocumentFreeTextAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentFreeTextAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<FreeTextAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document free text annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentFreeTextAnnotationsAsync(String name, String storage, String folder, final ApiCallback<FreeTextAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentFreeTextAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FreeTextAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentHighlightAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentHighlightAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/highlight"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentHighlightAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentHighlightAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentHighlightAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document highlight annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return HighlightAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public HighlightAnnotationsResponse getDocumentHighlightAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<HighlightAnnotationsResponse> resp = getDocumentHighlightAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<HighlightAnnotationsResponse> resp = getDocumentHighlightAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document highlight annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;HighlightAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<HighlightAnnotationsResponse> getDocumentHighlightAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentHighlightAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<HighlightAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document highlight annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentHighlightAnnotationsAsync(String name, String storage, String folder, final ApiCallback<HighlightAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentHighlightAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<HighlightAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentInkAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentInkAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/ink"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentInkAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentInkAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentInkAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document ink annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return InkAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InkAnnotationsResponse getDocumentInkAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<InkAnnotationsResponse> resp = getDocumentInkAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<InkAnnotationsResponse> resp = getDocumentInkAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document ink annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;InkAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InkAnnotationsResponse> getDocumentInkAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentInkAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<InkAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document ink annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentInkAnnotationsAsync(String name, String storage, String folder, final ApiCallback<InkAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentInkAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InkAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentLineAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentLineAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/line"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentLineAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentLineAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentLineAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document line annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return LineAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public LineAnnotationsResponse getDocumentLineAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<LineAnnotationsResponse> resp = getDocumentLineAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<LineAnnotationsResponse> resp = getDocumentLineAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document line annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;LineAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<LineAnnotationsResponse> getDocumentLineAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentLineAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<LineAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document line annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentLineAnnotationsAsync(String name, String storage, String folder, final ApiCallback<LineAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentLineAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LineAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentListBoxFields
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentListBoxFieldsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/listbox"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentListBoxFieldsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentListBoxFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentListBoxFieldsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document listbox fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ListBoxFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListBoxFieldsResponse getDocumentListBoxFields(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<ListBoxFieldsResponse> resp = getDocumentListBoxFieldsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<ListBoxFieldsResponse> resp = getDocumentListBoxFieldsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document listbox fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;ListBoxFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListBoxFieldsResponse> getDocumentListBoxFieldsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentListBoxFieldsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<ListBoxFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document listbox fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentListBoxFieldsAsync(String name, String storage, String folder, final ApiCallback<ListBoxFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentListBoxFieldsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListBoxFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentMovieAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentMovieAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/movie"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentMovieAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentMovieAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentMovieAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document movie annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return MovieAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public MovieAnnotationsResponse getDocumentMovieAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<MovieAnnotationsResponse> resp = getDocumentMovieAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<MovieAnnotationsResponse> resp = getDocumentMovieAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document movie annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;MovieAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<MovieAnnotationsResponse> getDocumentMovieAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentMovieAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<MovieAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document movie annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentMovieAnnotationsAsync(String name, String storage, String folder, final ApiCallback<MovieAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentMovieAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MovieAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentPolyLineAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentPolyLineAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/polyline"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentPolyLineAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentPolyLineAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentPolyLineAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document polyline annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return PolyLineAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PolyLineAnnotationsResponse getDocumentPolyLineAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<PolyLineAnnotationsResponse> resp = getDocumentPolyLineAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<PolyLineAnnotationsResponse> resp = getDocumentPolyLineAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document polyline annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;PolyLineAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PolyLineAnnotationsResponse> getDocumentPolyLineAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentPolyLineAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<PolyLineAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document polyline annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentPolyLineAnnotationsAsync(String name, String storage, String folder, final ApiCallback<PolyLineAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentPolyLineAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PolyLineAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentPolygonAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentPolygonAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/polygon"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentPolygonAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentPolygonAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentPolygonAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document polygon annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return PolygonAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PolygonAnnotationsResponse getDocumentPolygonAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<PolygonAnnotationsResponse> resp = getDocumentPolygonAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<PolygonAnnotationsResponse> resp = getDocumentPolygonAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document polygon annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;PolygonAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PolygonAnnotationsResponse> getDocumentPolygonAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentPolygonAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<PolygonAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document polygon annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentPolygonAnnotationsAsync(String name, String storage, String folder, final ApiCallback<PolygonAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentPolygonAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PolygonAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentPopupAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentPopupAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/popup"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentPopupAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentPopupAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentPopupAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document popup annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return PopupAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PopupAnnotationsResponse getDocumentPopupAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<PopupAnnotationsResponse> resp = getDocumentPopupAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<PopupAnnotationsResponse> resp = getDocumentPopupAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document popup annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;PopupAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PopupAnnotationsResponse> getDocumentPopupAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentPopupAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<PopupAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document popup annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentPopupAnnotationsAsync(String name, String storage, String folder, final ApiCallback<PopupAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentPopupAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PopupAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentPopupAnnotationsByParent
     * @param name The document name. (required)
     * @param annotationId The parent annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentPopupAnnotationsByParentCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/{annotationId}/popup"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentPopupAnnotationsByParentValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentPopupAnnotationsByParent(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling getDocumentPopupAnnotationsByParent(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentPopupAnnotationsByParentCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document popup annotations by parent id.
     * 
     * @param name The document name. (required)
     * @param annotationId The parent annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return PopupAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PopupAnnotationsResponse getDocumentPopupAnnotationsByParent(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<PopupAnnotationsResponse> resp = getDocumentPopupAnnotationsByParentWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<PopupAnnotationsResponse> resp = getDocumentPopupAnnotationsByParentWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document popup annotations by parent id.
     * 
     * @param name The document name. (required)
     * @param annotationId The parent annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;PopupAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PopupAnnotationsResponse> getDocumentPopupAnnotationsByParentWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentPopupAnnotationsByParentValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<PopupAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document popup annotations by parent id. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The parent annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentPopupAnnotationsByParentAsync(String name, String annotationId, String storage, String folder, final ApiCallback<PopupAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentPopupAnnotationsByParentValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PopupAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentProperties
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentPropertiesCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/documentproperties"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentPropertiesValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentProperties(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentPropertiesCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document properties.
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return DocumentPropertiesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DocumentPropertiesResponse getDocumentProperties(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<DocumentPropertiesResponse> resp = getDocumentPropertiesWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<DocumentPropertiesResponse> resp = getDocumentPropertiesWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document properties.
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return ApiResponse&lt;DocumentPropertiesResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DocumentPropertiesResponse> getDocumentPropertiesWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentPropertiesValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<DocumentPropertiesResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document properties. (asynchronously)
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentPropertiesAsync(String name, String storage, String folder, final ApiCallback<DocumentPropertiesResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentPropertiesValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentPropertiesResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentProperty
     * @param name  (required)
     * @param propertyName  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentPropertyCall(String name, String propertyName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/documentproperties/{propertyName}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "propertyName" + "\\}", apiClient.escapePathSegmentString(propertyName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentPropertyValidateBeforeCall(String name, String propertyName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentProperty(Async)");
        }
        
        // verify the required parameter 'propertyName' is set
        if (propertyName == null) {
            throw new ApiException("Missing the required parameter 'propertyName' when calling getDocumentProperty(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentPropertyCall(name, propertyName, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document property by name.
     * 
     * @param name  (required)
     * @param propertyName  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return DocumentPropertyResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DocumentPropertyResponse getDocumentProperty(String name, String propertyName, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<DocumentPropertyResponse> resp = getDocumentPropertyWithHttpInfo(name, propertyName, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<DocumentPropertyResponse> resp = getDocumentPropertyWithHttpInfo(name, propertyName, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document property by name.
     * 
     * @param name  (required)
     * @param propertyName  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return ApiResponse&lt;DocumentPropertyResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DocumentPropertyResponse> getDocumentPropertyWithHttpInfo(String name, String propertyName, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentPropertyValidateBeforeCall(name, propertyName, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<DocumentPropertyResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document property by name. (asynchronously)
     * 
     * @param name  (required)
     * @param propertyName  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentPropertyAsync(String name, String propertyName, String storage, String folder, final ApiCallback<DocumentPropertyResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentPropertyValidateBeforeCall(name, propertyName, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentPropertyResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentRadioButtonFields
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentRadioButtonFieldsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/radiobutton"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentRadioButtonFieldsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentRadioButtonFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentRadioButtonFieldsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document radiobutton fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return RadioButtonFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RadioButtonFieldsResponse getDocumentRadioButtonFields(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<RadioButtonFieldsResponse> resp = getDocumentRadioButtonFieldsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<RadioButtonFieldsResponse> resp = getDocumentRadioButtonFieldsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document radiobutton fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;RadioButtonFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RadioButtonFieldsResponse> getDocumentRadioButtonFieldsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentRadioButtonFieldsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<RadioButtonFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document radiobutton fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentRadioButtonFieldsAsync(String name, String storage, String folder, final ApiCallback<RadioButtonFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentRadioButtonFieldsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RadioButtonFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentRedactionAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentRedactionAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/redaction"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentRedactionAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentRedactionAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentRedactionAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document redaction annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return RedactionAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RedactionAnnotationsResponse getDocumentRedactionAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<RedactionAnnotationsResponse> resp = getDocumentRedactionAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<RedactionAnnotationsResponse> resp = getDocumentRedactionAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document redaction annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;RedactionAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RedactionAnnotationsResponse> getDocumentRedactionAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentRedactionAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<RedactionAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document redaction annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentRedactionAnnotationsAsync(String name, String storage, String folder, final ApiCallback<RedactionAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentRedactionAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RedactionAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentScreenAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentScreenAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/screen"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentScreenAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentScreenAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentScreenAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document screen annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ScreenAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ScreenAnnotationsResponse getDocumentScreenAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<ScreenAnnotationsResponse> resp = getDocumentScreenAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<ScreenAnnotationsResponse> resp = getDocumentScreenAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document screen annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;ScreenAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ScreenAnnotationsResponse> getDocumentScreenAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentScreenAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<ScreenAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document screen annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentScreenAnnotationsAsync(String name, String storage, String folder, final ApiCallback<ScreenAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentScreenAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ScreenAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentSignatureFields
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentSignatureFieldsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/signature"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentSignatureFieldsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentSignatureFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentSignatureFieldsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document signature fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return SignatureFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SignatureFieldsResponse getDocumentSignatureFields(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<SignatureFieldsResponse> resp = getDocumentSignatureFieldsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<SignatureFieldsResponse> resp = getDocumentSignatureFieldsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document signature fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;SignatureFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SignatureFieldsResponse> getDocumentSignatureFieldsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentSignatureFieldsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<SignatureFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document signature fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentSignatureFieldsAsync(String name, String storage, String folder, final ApiCallback<SignatureFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentSignatureFieldsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SignatureFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentSoundAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentSoundAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/sound"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentSoundAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentSoundAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentSoundAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document sound annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return SoundAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SoundAnnotationsResponse getDocumentSoundAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<SoundAnnotationsResponse> resp = getDocumentSoundAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<SoundAnnotationsResponse> resp = getDocumentSoundAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document sound annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;SoundAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SoundAnnotationsResponse> getDocumentSoundAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentSoundAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<SoundAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document sound annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentSoundAnnotationsAsync(String name, String storage, String folder, final ApiCallback<SoundAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentSoundAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SoundAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentSquareAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentSquareAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/square"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentSquareAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentSquareAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentSquareAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document square annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return SquareAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SquareAnnotationsResponse getDocumentSquareAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<SquareAnnotationsResponse> resp = getDocumentSquareAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<SquareAnnotationsResponse> resp = getDocumentSquareAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document square annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;SquareAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SquareAnnotationsResponse> getDocumentSquareAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentSquareAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<SquareAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document square annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentSquareAnnotationsAsync(String name, String storage, String folder, final ApiCallback<SquareAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentSquareAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SquareAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentSquigglyAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentSquigglyAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/squiggly"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentSquigglyAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentSquigglyAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentSquigglyAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document squiggly annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return SquigglyAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SquigglyAnnotationsResponse getDocumentSquigglyAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<SquigglyAnnotationsResponse> resp = getDocumentSquigglyAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<SquigglyAnnotationsResponse> resp = getDocumentSquigglyAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document squiggly annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;SquigglyAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SquigglyAnnotationsResponse> getDocumentSquigglyAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentSquigglyAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<SquigglyAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document squiggly annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentSquigglyAnnotationsAsync(String name, String storage, String folder, final ApiCallback<SquigglyAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentSquigglyAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SquigglyAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentStampAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentStampAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/stamp"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentStampAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentStampAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentStampAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document stamp annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return StampAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public StampAnnotationsResponse getDocumentStampAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<StampAnnotationsResponse> resp = getDocumentStampAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<StampAnnotationsResponse> resp = getDocumentStampAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document stamp annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;StampAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<StampAnnotationsResponse> getDocumentStampAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentStampAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<StampAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document stamp annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentStampAnnotationsAsync(String name, String storage, String folder, final ApiCallback<StampAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentStampAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<StampAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentStamps
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentStampsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/stamps"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentStampsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentStamps(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentStampsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document stamps.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return StampsInfoResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public StampsInfoResponse getDocumentStamps(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<StampsInfoResponse> resp = getDocumentStampsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<StampsInfoResponse> resp = getDocumentStampsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document stamps.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;StampsInfoResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<StampsInfoResponse> getDocumentStampsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentStampsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<StampsInfoResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document stamps. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentStampsAsync(String name, String storage, String folder, final ApiCallback<StampsInfoResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentStampsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<StampsInfoResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentStrikeOutAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentStrikeOutAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/strikeout"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentStrikeOutAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentStrikeOutAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentStrikeOutAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document StrikeOut annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return StrikeOutAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public StrikeOutAnnotationsResponse getDocumentStrikeOutAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<StrikeOutAnnotationsResponse> resp = getDocumentStrikeOutAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<StrikeOutAnnotationsResponse> resp = getDocumentStrikeOutAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document StrikeOut annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;StrikeOutAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<StrikeOutAnnotationsResponse> getDocumentStrikeOutAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentStrikeOutAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<StrikeOutAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document StrikeOut annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentStrikeOutAnnotationsAsync(String name, String storage, String folder, final ApiCallback<StrikeOutAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentStrikeOutAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<StrikeOutAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentTables
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentTablesCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/tables"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentTablesValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentTables(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentTablesCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document tables.
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return TablesRecognizedResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public TablesRecognizedResponse getDocumentTables(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<TablesRecognizedResponse> resp = getDocumentTablesWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<TablesRecognizedResponse> resp = getDocumentTablesWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document tables.
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @return ApiResponse&lt;TablesRecognizedResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<TablesRecognizedResponse> getDocumentTablesWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentTablesValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<TablesRecognizedResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document tables. (asynchronously)
     * 
     * @param name  (required)
     * @param storage  (optional)
     * @param folder  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentTablesAsync(String name, String storage, String folder, final ApiCallback<TablesRecognizedResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentTablesValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TablesRecognizedResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentTextAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentTextAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/text"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentTextAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentTextAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentTextAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document text annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return TextAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public TextAnnotationsResponse getDocumentTextAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<TextAnnotationsResponse> resp = getDocumentTextAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<TextAnnotationsResponse> resp = getDocumentTextAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document text annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;TextAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<TextAnnotationsResponse> getDocumentTextAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentTextAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<TextAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document text annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentTextAnnotationsAsync(String name, String storage, String folder, final ApiCallback<TextAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentTextAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TextAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentTextBoxFields
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentTextBoxFieldsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/textbox"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentTextBoxFieldsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentTextBoxFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentTextBoxFieldsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document text box fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return TextBoxFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public TextBoxFieldsResponse getDocumentTextBoxFields(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<TextBoxFieldsResponse> resp = getDocumentTextBoxFieldsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<TextBoxFieldsResponse> resp = getDocumentTextBoxFieldsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document text box fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;TextBoxFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<TextBoxFieldsResponse> getDocumentTextBoxFieldsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentTextBoxFieldsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<TextBoxFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document text box fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentTextBoxFieldsAsync(String name, String storage, String folder, final ApiCallback<TextBoxFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentTextBoxFieldsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TextBoxFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDocumentUnderlineAnnotations
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDocumentUnderlineAnnotationsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/underline"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDocumentUnderlineAnnotationsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDocumentUnderlineAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getDocumentUnderlineAnnotationsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document underline annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return UnderlineAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UnderlineAnnotationsResponse getDocumentUnderlineAnnotations(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<UnderlineAnnotationsResponse> resp = getDocumentUnderlineAnnotationsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<UnderlineAnnotationsResponse> resp = getDocumentUnderlineAnnotationsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document underline annotations.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;UnderlineAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UnderlineAnnotationsResponse> getDocumentUnderlineAnnotationsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDocumentUnderlineAnnotationsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<UnderlineAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document underline annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDocumentUnderlineAnnotationsAsync(String name, String storage, String folder, final ApiCallback<UnderlineAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDocumentUnderlineAnnotationsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UnderlineAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDownloadDocumentAttachmentByIndex
     * @param name The document name. (required)
     * @param attachmentIndex The attachment index. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDownloadDocumentAttachmentByIndexCall(String name, Integer attachmentIndex, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/attachments/{attachmentIndex}/download"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "attachmentIndex" + "\\}", apiClient.escapePathSegmentString(attachmentIndex.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDownloadDocumentAttachmentByIndexValidateBeforeCall(String name, Integer attachmentIndex, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDownloadDocumentAttachmentByIndex(Async)");
        }
        
        // verify the required parameter 'attachmentIndex' is set
        if (attachmentIndex == null) {
            throw new ApiException("Missing the required parameter 'attachmentIndex' when calling getDownloadDocumentAttachmentByIndex(Async)");
        }
        

        com.squareup.okhttp.Call call = getDownloadDocumentAttachmentByIndexCall(name, attachmentIndex, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Download document attachment content by its index.
     * 
     * @param name The document name. (required)
     * @param attachmentIndex The attachment index. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getDownloadDocumentAttachmentByIndex(String name, Integer attachmentIndex, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getDownloadDocumentAttachmentByIndexWithHttpInfo(name, attachmentIndex, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getDownloadDocumentAttachmentByIndexWithHttpInfo(name, attachmentIndex, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Download document attachment content by its index.
     * 
     * @param name The document name. (required)
     * @param attachmentIndex The attachment index. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getDownloadDocumentAttachmentByIndexWithHttpInfo(String name, Integer attachmentIndex, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getDownloadDocumentAttachmentByIndexValidateBeforeCall(name, attachmentIndex, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Download document attachment content by its index. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param attachmentIndex The attachment index. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDownloadDocumentAttachmentByIndexAsync(String name, Integer attachmentIndex, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDownloadDocumentAttachmentByIndexValidateBeforeCall(name, attachmentIndex, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getEpubInStorageToPdf
     * @param srcPath Full source filename (ex. /folder1/folder2/template.epub) (required)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getEpubInStorageToPdfCall(String srcPath, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/create/epub";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (srcPath != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("srcPath", srcPath));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getEpubInStorageToPdfValidateBeforeCall(String srcPath, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'srcPath' is set
        if (srcPath == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling getEpubInStorageToPdf(Async)");
        }
        

        com.squareup.okhttp.Call call = getEpubInStorageToPdfCall(srcPath, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert EPUB file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.epub) (required)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getEpubInStorageToPdf(String srcPath, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getEpubInStorageToPdfWithHttpInfo(srcPath, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getEpubInStorageToPdfWithHttpInfo(srcPath, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert EPUB file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.epub) (required)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getEpubInStorageToPdfWithHttpInfo(String srcPath, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getEpubInStorageToPdfValidateBeforeCall(srcPath, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert EPUB file (located on storage) to PDF format and return resulting file in response.  (asynchronously)
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.epub) (required)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getEpubInStorageToPdfAsync(String srcPath, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getEpubInStorageToPdfValidateBeforeCall(srcPath, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getExportFieldsFromPdfToFdfInStorage
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getExportFieldsFromPdfToFdfInStorageCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/export/fdf"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getExportFieldsFromPdfToFdfInStorageValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getExportFieldsFromPdfToFdfInStorage(Async)");
        }
        

        com.squareup.okhttp.Call call = getExportFieldsFromPdfToFdfInStorageCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Export fields from from PDF in storage to FDF file.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getExportFieldsFromPdfToFdfInStorage(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getExportFieldsFromPdfToFdfInStorageWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getExportFieldsFromPdfToFdfInStorageWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Export fields from from PDF in storage to FDF file.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getExportFieldsFromPdfToFdfInStorageWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getExportFieldsFromPdfToFdfInStorageValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Export fields from from PDF in storage to FDF file. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getExportFieldsFromPdfToFdfInStorageAsync(String name, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getExportFieldsFromPdfToFdfInStorageValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getExportFieldsFromPdfToXfdfInStorage
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getExportFieldsFromPdfToXfdfInStorageCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/export/xfdf"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getExportFieldsFromPdfToXfdfInStorageValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getExportFieldsFromPdfToXfdfInStorage(Async)");
        }
        

        com.squareup.okhttp.Call call = getExportFieldsFromPdfToXfdfInStorageCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Export fields from from PDF in storage to XFDF file.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getExportFieldsFromPdfToXfdfInStorage(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getExportFieldsFromPdfToXfdfInStorageWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getExportFieldsFromPdfToXfdfInStorageWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Export fields from from PDF in storage to XFDF file.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getExportFieldsFromPdfToXfdfInStorageWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getExportFieldsFromPdfToXfdfInStorageValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Export fields from from PDF in storage to XFDF file. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getExportFieldsFromPdfToXfdfInStorageAsync(String name, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getExportFieldsFromPdfToXfdfInStorageValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getExportFieldsFromPdfToXmlInStorage
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getExportFieldsFromPdfToXmlInStorageCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/export/xml"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getExportFieldsFromPdfToXmlInStorageValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getExportFieldsFromPdfToXmlInStorage(Async)");
        }
        

        com.squareup.okhttp.Call call = getExportFieldsFromPdfToXmlInStorageCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Export fields from from PDF in storage to XML file.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getExportFieldsFromPdfToXmlInStorage(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getExportFieldsFromPdfToXmlInStorageWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getExportFieldsFromPdfToXmlInStorageWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Export fields from from PDF in storage to XML file.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getExportFieldsFromPdfToXmlInStorageWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getExportFieldsFromPdfToXmlInStorageValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Export fields from from PDF in storage to XML file. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getExportFieldsFromPdfToXmlInStorageAsync(String name, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getExportFieldsFromPdfToXmlInStorageValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getField
     * @param name The document name. (required)
     * @param fieldName The field name (name should be encoded). (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFieldCall(String name, String fieldName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/{fieldName}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "fieldName" + "\\}", apiClient.escapePathSegmentString(fieldName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFieldValidateBeforeCall(String name, String fieldName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getField(Async)");
        }
        
        // verify the required parameter 'fieldName' is set
        if (fieldName == null) {
            throw new ApiException("Missing the required parameter 'fieldName' when calling getField(Async)");
        }
        

        com.squareup.okhttp.Call call = getFieldCall(name, fieldName, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get document field by name.
     * 
     * @param name The document name. (required)
     * @param fieldName The field name (name should be encoded). (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return FieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FieldResponse getField(String name, String fieldName, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<FieldResponse> resp = getFieldWithHttpInfo(name, fieldName, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<FieldResponse> resp = getFieldWithHttpInfo(name, fieldName, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Get document field by name.
     * 
     * @param name The document name. (required)
     * @param fieldName The field name (name should be encoded). (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;FieldResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FieldResponse> getFieldWithHttpInfo(String name, String fieldName, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getFieldValidateBeforeCall(name, fieldName, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<FieldResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get document field by name. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param fieldName The field name (name should be encoded). (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFieldAsync(String name, String fieldName, String storage, String folder, final ApiCallback<FieldResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFieldValidateBeforeCall(name, fieldName, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FieldResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFields
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFieldsCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFieldsValidateBeforeCall(String name, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getFieldsCall(name, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get document fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return FieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FieldsResponse getFields(String name, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<FieldsResponse> resp = getFieldsWithHttpInfo(name, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<FieldsResponse> resp = getFieldsWithHttpInfo(name, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Get document fields.
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;FieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FieldsResponse> getFieldsWithHttpInfo(String name, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getFieldsValidateBeforeCall(name, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<FieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get document fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFieldsAsync(String name, String storage, String folder, final ApiCallback<FieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFieldsValidateBeforeCall(name, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFileAttachmentAnnotation
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFileAttachmentAnnotationCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/fileattachment/{annotationId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFileAttachmentAnnotationValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getFileAttachmentAnnotation(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling getFileAttachmentAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = getFileAttachmentAnnotationCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page FileAttachment annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return FileAttachmentAnnotationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FileAttachmentAnnotationResponse getFileAttachmentAnnotation(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<FileAttachmentAnnotationResponse> resp = getFileAttachmentAnnotationWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<FileAttachmentAnnotationResponse> resp = getFileAttachmentAnnotationWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page FileAttachment annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;FileAttachmentAnnotationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FileAttachmentAnnotationResponse> getFileAttachmentAnnotationWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getFileAttachmentAnnotationValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<FileAttachmentAnnotationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page FileAttachment annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFileAttachmentAnnotationAsync(String name, String annotationId, String storage, String folder, final ApiCallback<FileAttachmentAnnotationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFileAttachmentAnnotationValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileAttachmentAnnotationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFileAttachmentAnnotationData
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFileAttachmentAnnotationDataCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/fileattachment/{annotationId}/data"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFileAttachmentAnnotationDataValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getFileAttachmentAnnotationData(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling getFileAttachmentAnnotationData(Async)");
        }
        

        com.squareup.okhttp.Call call = getFileAttachmentAnnotationDataCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page FileAttachment annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getFileAttachmentAnnotationData(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getFileAttachmentAnnotationDataWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getFileAttachmentAnnotationDataWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page FileAttachment annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getFileAttachmentAnnotationDataWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getFileAttachmentAnnotationDataValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page FileAttachment annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFileAttachmentAnnotationDataAsync(String name, String annotationId, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFileAttachmentAnnotationDataValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFileVersions
     * @param path File path e.g. &#39;/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFileVersionsCall(String path, String storageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/storage/version/{path}"
            .replaceAll("\\{" + "path" + "\\}", apiClient.escapePathSegmentString(path.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storageName", storageName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFileVersionsValidateBeforeCall(String path, String storageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling getFileVersions(Async)");
        }
        

        com.squareup.okhttp.Call call = getFileVersionsCall(path, storageName, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get file versions
     * 
     * @param path File path e.g. &#39;/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @return FileVersions
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FileVersions getFileVersions(String path, String storageName) throws ApiException {
        try
        {
            ApiResponse<FileVersions> resp = getFileVersionsWithHttpInfo(path, storageName);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<FileVersions> resp = getFileVersionsWithHttpInfo(path, storageName);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Get file versions
     * 
     * @param path File path e.g. &#39;/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @return ApiResponse&lt;FileVersions&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FileVersions> getFileVersionsWithHttpInfo(String path, String storageName) throws ApiException {
        com.squareup.okhttp.Call call = getFileVersionsValidateBeforeCall(path, storageName, null, null);
        Type localVarReturnType = new TypeToken<FileVersions>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get file versions (asynchronously)
     * 
     * @param path File path e.g. &#39;/file.ext&#39; (required)
     * @param storageName Storage name (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFileVersionsAsync(String path, String storageName, final ApiCallback<FileVersions> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFileVersionsValidateBeforeCall(path, storageName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileVersions>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFilesList
     * @param path Folder path e.g. &#39;/folder&#39; (required)
     * @param storageName Storage name (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFilesListCall(String path, String storageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/storage/folder/{path}"
            .replaceAll("\\{" + "path" + "\\}", apiClient.escapePathSegmentString(path.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storageName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storageName", storageName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFilesListValidateBeforeCall(String path, String storageName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling getFilesList(Async)");
        }
        

        com.squareup.okhttp.Call call = getFilesListCall(path, storageName, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all files and folders within a folder
     * 
     * @param path Folder path e.g. &#39;/folder&#39; (required)
     * @param storageName Storage name (optional)
     * @return FilesList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FilesList getFilesList(String path, String storageName) throws ApiException {
        try
        {
            ApiResponse<FilesList> resp = getFilesListWithHttpInfo(path, storageName);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<FilesList> resp = getFilesListWithHttpInfo(path, storageName);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Get all files and folders within a folder
     * 
     * @param path Folder path e.g. &#39;/folder&#39; (required)
     * @param storageName Storage name (optional)
     * @return ApiResponse&lt;FilesList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FilesList> getFilesListWithHttpInfo(String path, String storageName) throws ApiException {
        com.squareup.okhttp.Call call = getFilesListValidateBeforeCall(path, storageName, null, null);
        Type localVarReturnType = new TypeToken<FilesList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all files and folders within a folder (asynchronously)
     * 
     * @param path Folder path e.g. &#39;/folder&#39; (required)
     * @param storageName Storage name (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFilesListAsync(String path, String storageName, final ApiCallback<FilesList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFilesListValidateBeforeCall(path, storageName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FilesList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFreeTextAnnotation
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFreeTextAnnotationCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/freetext/{annotationId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFreeTextAnnotationValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getFreeTextAnnotation(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling getFreeTextAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = getFreeTextAnnotationCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page free text annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return FreeTextAnnotationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FreeTextAnnotationResponse getFreeTextAnnotation(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<FreeTextAnnotationResponse> resp = getFreeTextAnnotationWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<FreeTextAnnotationResponse> resp = getFreeTextAnnotationWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page free text annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;FreeTextAnnotationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FreeTextAnnotationResponse> getFreeTextAnnotationWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getFreeTextAnnotationValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<FreeTextAnnotationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page free text annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFreeTextAnnotationAsync(String name, String annotationId, String storage, String folder, final ApiCallback<FreeTextAnnotationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFreeTextAnnotationValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FreeTextAnnotationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getHighlightAnnotation
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getHighlightAnnotationCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/highlight/{annotationId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getHighlightAnnotationValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getHighlightAnnotation(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling getHighlightAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = getHighlightAnnotationCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page highlight annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return HighlightAnnotationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public HighlightAnnotationResponse getHighlightAnnotation(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<HighlightAnnotationResponse> resp = getHighlightAnnotationWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<HighlightAnnotationResponse> resp = getHighlightAnnotationWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page highlight annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;HighlightAnnotationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<HighlightAnnotationResponse> getHighlightAnnotationWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getHighlightAnnotationValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<HighlightAnnotationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page highlight annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getHighlightAnnotationAsync(String name, String annotationId, String storage, String folder, final ApiCallback<HighlightAnnotationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getHighlightAnnotationValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<HighlightAnnotationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getHtmlInStorageToPdf
     * @param srcPath Full source filename (ex. /folder1/folder2/template.zip) (required)
     * @param htmlFileName Name of HTML file in ZIP. (optional)
     * @param height Page height (optional)
     * @param width Page width (optional)
     * @param isLandscape Is page landscaped (optional)
     * @param marginLeft Page margin left (optional)
     * @param marginBottom Page margin bottom (optional)
     * @param marginRight Page margin right (optional)
     * @param marginTop Page margin top (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getHtmlInStorageToPdfCall(String srcPath, String htmlFileName, Double height, Double width, Boolean isLandscape, Double marginLeft, Double marginBottom, Double marginRight, Double marginTop, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/create/html";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (srcPath != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("srcPath", srcPath));
        if (htmlFileName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("htmlFileName", htmlFileName));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (isLandscape != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isLandscape", isLandscape));
        if (marginLeft != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("marginLeft", marginLeft));
        if (marginBottom != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("marginBottom", marginBottom));
        if (marginRight != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("marginRight", marginRight));
        if (marginTop != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("marginTop", marginTop));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getHtmlInStorageToPdfValidateBeforeCall(String srcPath, String htmlFileName, Double height, Double width, Boolean isLandscape, Double marginLeft, Double marginBottom, Double marginRight, Double marginTop, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'srcPath' is set
        if (srcPath == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling getHtmlInStorageToPdf(Async)");
        }
        

        com.squareup.okhttp.Call call = getHtmlInStorageToPdfCall(srcPath, htmlFileName, height, width, isLandscape, marginLeft, marginBottom, marginRight, marginTop, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert HTML file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.zip) (required)
     * @param htmlFileName Name of HTML file in ZIP. (optional)
     * @param height Page height (optional)
     * @param width Page width (optional)
     * @param isLandscape Is page landscaped (optional)
     * @param marginLeft Page margin left (optional)
     * @param marginBottom Page margin bottom (optional)
     * @param marginRight Page margin right (optional)
     * @param marginTop Page margin top (optional)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getHtmlInStorageToPdf(String srcPath, String htmlFileName, Double height, Double width, Boolean isLandscape, Double marginLeft, Double marginBottom, Double marginRight, Double marginTop, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getHtmlInStorageToPdfWithHttpInfo(srcPath, htmlFileName, height, width, isLandscape, marginLeft, marginBottom, marginRight, marginTop, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getHtmlInStorageToPdfWithHttpInfo(srcPath, htmlFileName, height, width, isLandscape, marginLeft, marginBottom, marginRight, marginTop, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert HTML file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.zip) (required)
     * @param htmlFileName Name of HTML file in ZIP. (optional)
     * @param height Page height (optional)
     * @param width Page width (optional)
     * @param isLandscape Is page landscaped (optional)
     * @param marginLeft Page margin left (optional)
     * @param marginBottom Page margin bottom (optional)
     * @param marginRight Page margin right (optional)
     * @param marginTop Page margin top (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getHtmlInStorageToPdfWithHttpInfo(String srcPath, String htmlFileName, Double height, Double width, Boolean isLandscape, Double marginLeft, Double marginBottom, Double marginRight, Double marginTop, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getHtmlInStorageToPdfValidateBeforeCall(srcPath, htmlFileName, height, width, isLandscape, marginLeft, marginBottom, marginRight, marginTop, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert HTML file (located on storage) to PDF format and return resulting file in response.  (asynchronously)
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.zip) (required)
     * @param htmlFileName Name of HTML file in ZIP. (optional)
     * @param height Page height (optional)
     * @param width Page width (optional)
     * @param isLandscape Is page landscaped (optional)
     * @param marginLeft Page margin left (optional)
     * @param marginBottom Page margin bottom (optional)
     * @param marginRight Page margin right (optional)
     * @param marginTop Page margin top (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getHtmlInStorageToPdfAsync(String srcPath, String htmlFileName, Double height, Double width, Boolean isLandscape, Double marginLeft, Double marginBottom, Double marginRight, Double marginTop, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getHtmlInStorageToPdfValidateBeforeCall(srcPath, htmlFileName, height, width, isLandscape, marginLeft, marginBottom, marginRight, marginTop, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getImage
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getImageCall(String name, String imageId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/images/{imageId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "imageId" + "\\}", apiClient.escapePathSegmentString(imageId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getImageValidateBeforeCall(String name, String imageId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getImage(Async)");
        }
        
        // verify the required parameter 'imageId' is set
        if (imageId == null) {
            throw new ApiException("Missing the required parameter 'imageId' when calling getImage(Async)");
        }
        

        com.squareup.okhttp.Call call = getImageCall(name, imageId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document image by ID.
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ImageResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ImageResponse getImage(String name, String imageId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<ImageResponse> resp = getImageWithHttpInfo(name, imageId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<ImageResponse> resp = getImageWithHttpInfo(name, imageId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document image by ID.
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;ImageResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ImageResponse> getImageWithHttpInfo(String name, String imageId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getImageValidateBeforeCall(name, imageId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<ImageResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document image by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getImageAsync(String name, String imageId, String storage, String folder, final ApiCallback<ImageResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getImageValidateBeforeCall(name, imageId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ImageResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getImageExtractAsGif
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getImageExtractAsGifCall(String name, String imageId, Integer width, Integer height, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/images/{imageId}/extract/gif"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "imageId" + "\\}", apiClient.escapePathSegmentString(imageId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getImageExtractAsGifValidateBeforeCall(String name, String imageId, Integer width, Integer height, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getImageExtractAsGif(Async)");
        }
        
        // verify the required parameter 'imageId' is set
        if (imageId == null) {
            throw new ApiException("Missing the required parameter 'imageId' when calling getImageExtractAsGif(Async)");
        }
        

        com.squareup.okhttp.Call call = getImageExtractAsGifCall(name, imageId, width, height, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Extract document image in GIF format
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getImageExtractAsGif(String name, String imageId, Integer width, Integer height, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getImageExtractAsGifWithHttpInfo(name, imageId, width, height, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getImageExtractAsGifWithHttpInfo(name, imageId, width, height, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Extract document image in GIF format
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getImageExtractAsGifWithHttpInfo(String name, String imageId, Integer width, Integer height, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getImageExtractAsGifValidateBeforeCall(name, imageId, width, height, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Extract document image in GIF format (asynchronously)
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getImageExtractAsGifAsync(String name, String imageId, Integer width, Integer height, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getImageExtractAsGifValidateBeforeCall(name, imageId, width, height, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getImageExtractAsJpeg
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getImageExtractAsJpegCall(String name, String imageId, Integer width, Integer height, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/images/{imageId}/extract/jpeg"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "imageId" + "\\}", apiClient.escapePathSegmentString(imageId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getImageExtractAsJpegValidateBeforeCall(String name, String imageId, Integer width, Integer height, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getImageExtractAsJpeg(Async)");
        }
        
        // verify the required parameter 'imageId' is set
        if (imageId == null) {
            throw new ApiException("Missing the required parameter 'imageId' when calling getImageExtractAsJpeg(Async)");
        }
        

        com.squareup.okhttp.Call call = getImageExtractAsJpegCall(name, imageId, width, height, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Extract document image in JPEG format
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getImageExtractAsJpeg(String name, String imageId, Integer width, Integer height, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getImageExtractAsJpegWithHttpInfo(name, imageId, width, height, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getImageExtractAsJpegWithHttpInfo(name, imageId, width, height, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Extract document image in JPEG format
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getImageExtractAsJpegWithHttpInfo(String name, String imageId, Integer width, Integer height, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getImageExtractAsJpegValidateBeforeCall(name, imageId, width, height, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Extract document image in JPEG format (asynchronously)
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getImageExtractAsJpegAsync(String name, String imageId, Integer width, Integer height, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getImageExtractAsJpegValidateBeforeCall(name, imageId, width, height, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getImageExtractAsPng
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getImageExtractAsPngCall(String name, String imageId, Integer width, Integer height, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/images/{imageId}/extract/png"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "imageId" + "\\}", apiClient.escapePathSegmentString(imageId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getImageExtractAsPngValidateBeforeCall(String name, String imageId, Integer width, Integer height, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getImageExtractAsPng(Async)");
        }
        
        // verify the required parameter 'imageId' is set
        if (imageId == null) {
            throw new ApiException("Missing the required parameter 'imageId' when calling getImageExtractAsPng(Async)");
        }
        

        com.squareup.okhttp.Call call = getImageExtractAsPngCall(name, imageId, width, height, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Extract document image in PNG format
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getImageExtractAsPng(String name, String imageId, Integer width, Integer height, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getImageExtractAsPngWithHttpInfo(name, imageId, width, height, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getImageExtractAsPngWithHttpInfo(name, imageId, width, height, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Extract document image in PNG format
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getImageExtractAsPngWithHttpInfo(String name, String imageId, Integer width, Integer height, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getImageExtractAsPngValidateBeforeCall(name, imageId, width, height, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Extract document image in PNG format (asynchronously)
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getImageExtractAsPngAsync(String name, String imageId, Integer width, Integer height, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getImageExtractAsPngValidateBeforeCall(name, imageId, width, height, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getImageExtractAsTiff
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getImageExtractAsTiffCall(String name, String imageId, Integer width, Integer height, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/images/{imageId}/extract/tiff"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "imageId" + "\\}", apiClient.escapePathSegmentString(imageId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getImageExtractAsTiffValidateBeforeCall(String name, String imageId, Integer width, Integer height, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getImageExtractAsTiff(Async)");
        }
        
        // verify the required parameter 'imageId' is set
        if (imageId == null) {
            throw new ApiException("Missing the required parameter 'imageId' when calling getImageExtractAsTiff(Async)");
        }
        

        com.squareup.okhttp.Call call = getImageExtractAsTiffCall(name, imageId, width, height, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Extract document image in TIFF format
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getImageExtractAsTiff(String name, String imageId, Integer width, Integer height, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getImageExtractAsTiffWithHttpInfo(name, imageId, width, height, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getImageExtractAsTiffWithHttpInfo(name, imageId, width, height, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Extract document image in TIFF format
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getImageExtractAsTiffWithHttpInfo(String name, String imageId, Integer width, Integer height, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getImageExtractAsTiffValidateBeforeCall(name, imageId, width, height, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Extract document image in TIFF format (asynchronously)
     * 
     * @param name The document name. (required)
     * @param imageId Image ID. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getImageExtractAsTiffAsync(String name, String imageId, Integer width, Integer height, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getImageExtractAsTiffValidateBeforeCall(name, imageId, width, height, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getImages
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getImagesCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/images"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getImagesValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getImages(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getImages(Async)");
        }
        

        com.squareup.okhttp.Call call = getImagesCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document images.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ImagesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ImagesResponse getImages(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<ImagesResponse> resp = getImagesWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<ImagesResponse> resp = getImagesWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document images.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;ImagesResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ImagesResponse> getImagesWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getImagesValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<ImagesResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document images. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getImagesAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<ImagesResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getImagesValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ImagesResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getImportFieldsFromFdfInStorage
     * @param name The document name. (required)
     * @param fdfFilePath The Fdf file path. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getImportFieldsFromFdfInStorageCall(String name, String fdfFilePath, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/import/fdf"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (fdfFilePath != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("fdfFilePath", fdfFilePath));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getImportFieldsFromFdfInStorageValidateBeforeCall(String name, String fdfFilePath, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getImportFieldsFromFdfInStorage(Async)");
        }
        
        // verify the required parameter 'fdfFilePath' is set
        if (fdfFilePath == null) {
            throw new ApiException("Missing the required parameter 'fdfFilePath' when calling getImportFieldsFromFdfInStorage(Async)");
        }
        

        com.squareup.okhttp.Call call = getImportFieldsFromFdfInStorageCall(name, fdfFilePath, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update fields from FDF file in storage.
     * 
     * @param name The document name. (required)
     * @param fdfFilePath The Fdf file path. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getImportFieldsFromFdfInStorage(String name, String fdfFilePath, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getImportFieldsFromFdfInStorageWithHttpInfo(name, fdfFilePath, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getImportFieldsFromFdfInStorageWithHttpInfo(name, fdfFilePath, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Update fields from FDF file in storage.
     * 
     * @param name The document name. (required)
     * @param fdfFilePath The Fdf file path. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getImportFieldsFromFdfInStorageWithHttpInfo(String name, String fdfFilePath, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getImportFieldsFromFdfInStorageValidateBeforeCall(name, fdfFilePath, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update fields from FDF file in storage. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param fdfFilePath The Fdf file path. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getImportFieldsFromFdfInStorageAsync(String name, String fdfFilePath, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getImportFieldsFromFdfInStorageValidateBeforeCall(name, fdfFilePath, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getImportFieldsFromXfdfInStorage
     * @param name The document name. (required)
     * @param xfdfFilePath The XFDF file path. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getImportFieldsFromXfdfInStorageCall(String name, String xfdfFilePath, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/import/xfdf"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (xfdfFilePath != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("xfdfFilePath", xfdfFilePath));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getImportFieldsFromXfdfInStorageValidateBeforeCall(String name, String xfdfFilePath, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getImportFieldsFromXfdfInStorage(Async)");
        }
        
        // verify the required parameter 'xfdfFilePath' is set
        if (xfdfFilePath == null) {
            throw new ApiException("Missing the required parameter 'xfdfFilePath' when calling getImportFieldsFromXfdfInStorage(Async)");
        }
        

        com.squareup.okhttp.Call call = getImportFieldsFromXfdfInStorageCall(name, xfdfFilePath, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update fields from XFDF file in storage.
     * 
     * @param name The document name. (required)
     * @param xfdfFilePath The XFDF file path. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getImportFieldsFromXfdfInStorage(String name, String xfdfFilePath, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getImportFieldsFromXfdfInStorageWithHttpInfo(name, xfdfFilePath, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getImportFieldsFromXfdfInStorageWithHttpInfo(name, xfdfFilePath, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Update fields from XFDF file in storage.
     * 
     * @param name The document name. (required)
     * @param xfdfFilePath The XFDF file path. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getImportFieldsFromXfdfInStorageWithHttpInfo(String name, String xfdfFilePath, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getImportFieldsFromXfdfInStorageValidateBeforeCall(name, xfdfFilePath, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update fields from XFDF file in storage. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param xfdfFilePath The XFDF file path. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getImportFieldsFromXfdfInStorageAsync(String name, String xfdfFilePath, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getImportFieldsFromXfdfInStorageValidateBeforeCall(name, xfdfFilePath, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getImportFieldsFromXmlInStorage
     * @param name The document name. (required)
     * @param xmlFilePath Full source filename (ex. /folder1/folder2/template.xml) (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getImportFieldsFromXmlInStorageCall(String name, String xmlFilePath, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/import/xml"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (xmlFilePath != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("xmlFilePath", xmlFilePath));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getImportFieldsFromXmlInStorageValidateBeforeCall(String name, String xmlFilePath, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getImportFieldsFromXmlInStorage(Async)");
        }
        
        // verify the required parameter 'xmlFilePath' is set
        if (xmlFilePath == null) {
            throw new ApiException("Missing the required parameter 'xmlFilePath' when calling getImportFieldsFromXmlInStorage(Async)");
        }
        

        com.squareup.okhttp.Call call = getImportFieldsFromXmlInStorageCall(name, xmlFilePath, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Import from XML file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param name The document name. (required)
     * @param xmlFilePath Full source filename (ex. /folder1/folder2/template.xml) (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getImportFieldsFromXmlInStorage(String name, String xmlFilePath, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<File> resp = getImportFieldsFromXmlInStorageWithHttpInfo(name, xmlFilePath, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getImportFieldsFromXmlInStorageWithHttpInfo(name, xmlFilePath, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Import from XML file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param name The document name. (required)
     * @param xmlFilePath Full source filename (ex. /folder1/folder2/template.xml) (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getImportFieldsFromXmlInStorageWithHttpInfo(String name, String xmlFilePath, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getImportFieldsFromXmlInStorageValidateBeforeCall(name, xmlFilePath, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Import from XML file (located on storage) to PDF format and return resulting file in response.  (asynchronously)
     * 
     * @param name The document name. (required)
     * @param xmlFilePath Full source filename (ex. /folder1/folder2/template.xml) (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getImportFieldsFromXmlInStorageAsync(String name, String xmlFilePath, String storage, String folder, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getImportFieldsFromXmlInStorageValidateBeforeCall(name, xmlFilePath, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getInkAnnotation
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getInkAnnotationCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/ink/{annotationId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getInkAnnotationValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getInkAnnotation(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling getInkAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = getInkAnnotationCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page ink annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return InkAnnotationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InkAnnotationResponse getInkAnnotation(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<InkAnnotationResponse> resp = getInkAnnotationWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<InkAnnotationResponse> resp = getInkAnnotationWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page ink annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;InkAnnotationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InkAnnotationResponse> getInkAnnotationWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getInkAnnotationValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<InkAnnotationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page ink annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getInkAnnotationAsync(String name, String annotationId, String storage, String folder, final ApiCallback<InkAnnotationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getInkAnnotationValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InkAnnotationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getLaTeXInStorageToPdf
     * @param srcPath Full source filename (ex. /folder1/folder2/template.tex) (required)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLaTeXInStorageToPdfCall(String srcPath, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/create/latex";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (srcPath != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("srcPath", srcPath));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLaTeXInStorageToPdfValidateBeforeCall(String srcPath, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'srcPath' is set
        if (srcPath == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling getLaTeXInStorageToPdf(Async)");
        }
        

        com.squareup.okhttp.Call call = getLaTeXInStorageToPdfCall(srcPath, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert LaTeX file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.tex) (required)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getLaTeXInStorageToPdf(String srcPath, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getLaTeXInStorageToPdfWithHttpInfo(srcPath, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getLaTeXInStorageToPdfWithHttpInfo(srcPath, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert LaTeX file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.tex) (required)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getLaTeXInStorageToPdfWithHttpInfo(String srcPath, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getLaTeXInStorageToPdfValidateBeforeCall(srcPath, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert LaTeX file (located on storage) to PDF format and return resulting file in response.  (asynchronously)
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.tex) (required)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLaTeXInStorageToPdfAsync(String srcPath, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getLaTeXInStorageToPdfValidateBeforeCall(srcPath, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getLineAnnotation
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLineAnnotationCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/line/{annotationId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLineAnnotationValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getLineAnnotation(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling getLineAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = getLineAnnotationCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page line annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return LineAnnotationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public LineAnnotationResponse getLineAnnotation(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<LineAnnotationResponse> resp = getLineAnnotationWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<LineAnnotationResponse> resp = getLineAnnotationWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page line annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;LineAnnotationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<LineAnnotationResponse> getLineAnnotationWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getLineAnnotationValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<LineAnnotationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page line annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLineAnnotationAsync(String name, String annotationId, String storage, String folder, final ApiCallback<LineAnnotationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getLineAnnotationValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LineAnnotationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getLinkAnnotation
     * @param name The document name. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLinkAnnotationCall(String name, String linkId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/links/{linkId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "linkId" + "\\}", apiClient.escapePathSegmentString(linkId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLinkAnnotationValidateBeforeCall(String name, String linkId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getLinkAnnotation(Async)");
        }
        
        // verify the required parameter 'linkId' is set
        if (linkId == null) {
            throw new ApiException("Missing the required parameter 'linkId' when calling getLinkAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = getLinkAnnotationCall(name, linkId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document link annotation by ID.
     * 
     * @param name The document name. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return LinkAnnotationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public LinkAnnotationResponse getLinkAnnotation(String name, String linkId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<LinkAnnotationResponse> resp = getLinkAnnotationWithHttpInfo(name, linkId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<LinkAnnotationResponse> resp = getLinkAnnotationWithHttpInfo(name, linkId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document link annotation by ID.
     * 
     * @param name The document name. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;LinkAnnotationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<LinkAnnotationResponse> getLinkAnnotationWithHttpInfo(String name, String linkId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getLinkAnnotationValidateBeforeCall(name, linkId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<LinkAnnotationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document link annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLinkAnnotationAsync(String name, String linkId, String storage, String folder, final ApiCallback<LinkAnnotationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getLinkAnnotationValidateBeforeCall(name, linkId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LinkAnnotationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getListBoxField
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getListBoxFieldCall(String name, String fieldName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/fields/listbox/{fieldName}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "fieldName" + "\\}", apiClient.escapePathSegmentString(fieldName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getListBoxFieldValidateBeforeCall(String name, String fieldName, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getListBoxField(Async)");
        }
        
        // verify the required parameter 'fieldName' is set
        if (fieldName == null) {
            throw new ApiException("Missing the required parameter 'fieldName' when calling getListBoxField(Async)");
        }
        

        com.squareup.okhttp.Call call = getListBoxFieldCall(name, fieldName, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document listbox field by name.
     * 
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ListBoxFieldResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListBoxFieldResponse getListBoxField(String name, String fieldName, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<ListBoxFieldResponse> resp = getListBoxFieldWithHttpInfo(name, fieldName, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<ListBoxFieldResponse> resp = getListBoxFieldWithHttpInfo(name, fieldName, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document listbox field by name.
     * 
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;ListBoxFieldResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListBoxFieldResponse> getListBoxFieldWithHttpInfo(String name, String fieldName, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getListBoxFieldValidateBeforeCall(name, fieldName, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<ListBoxFieldResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document listbox field by name. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param fieldName The field name. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getListBoxFieldAsync(String name, String fieldName, String storage, String folder, final ApiCallback<ListBoxFieldResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getListBoxFieldValidateBeforeCall(name, fieldName, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListBoxFieldResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getMarkdownInStorageToPdf
     * @param srcPath Full source filename (ex. /folder1/folder2/template.md) (required)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getMarkdownInStorageToPdfCall(String srcPath, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/create/markdown";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (srcPath != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("srcPath", srcPath));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getMarkdownInStorageToPdfValidateBeforeCall(String srcPath, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'srcPath' is set
        if (srcPath == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling getMarkdownInStorageToPdf(Async)");
        }
        

        com.squareup.okhttp.Call call = getMarkdownInStorageToPdfCall(srcPath, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert MD file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.md) (required)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getMarkdownInStorageToPdf(String srcPath, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getMarkdownInStorageToPdfWithHttpInfo(srcPath, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getMarkdownInStorageToPdfWithHttpInfo(srcPath, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert MD file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.md) (required)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getMarkdownInStorageToPdfWithHttpInfo(String srcPath, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getMarkdownInStorageToPdfValidateBeforeCall(srcPath, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert MD file (located on storage) to PDF format and return resulting file in response.  (asynchronously)
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.md) (required)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getMarkdownInStorageToPdfAsync(String srcPath, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getMarkdownInStorageToPdfValidateBeforeCall(srcPath, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getMhtInStorageToPdf
     * @param srcPath Full source filename (ex. /folder1/folder2/template.mht) (required)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getMhtInStorageToPdfCall(String srcPath, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/create/mht";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (srcPath != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("srcPath", srcPath));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getMhtInStorageToPdfValidateBeforeCall(String srcPath, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'srcPath' is set
        if (srcPath == null) {
            throw new ApiException("Missing the required parameter 'srcPath' when calling getMhtInStorageToPdf(Async)");
        }
        

        com.squareup.okhttp.Call call = getMhtInStorageToPdfCall(srcPath, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert MHT file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.mht) (required)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getMhtInStorageToPdf(String srcPath, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getMhtInStorageToPdfWithHttpInfo(srcPath, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getMhtInStorageToPdfWithHttpInfo(srcPath, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert MHT file (located on storage) to PDF format and return resulting file in response. 
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.mht) (required)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getMhtInStorageToPdfWithHttpInfo(String srcPath, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getMhtInStorageToPdfValidateBeforeCall(srcPath, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert MHT file (located on storage) to PDF format and return resulting file in response.  (asynchronously)
     * 
     * @param srcPath Full source filename (ex. /folder1/folder2/template.mht) (required)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getMhtInStorageToPdfAsync(String srcPath, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getMhtInStorageToPdfValidateBeforeCall(srcPath, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getMovieAnnotation
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getMovieAnnotationCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/annotations/movie/{annotationId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "annotationId" + "\\}", apiClient.escapePathSegmentString(annotationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getMovieAnnotationValidateBeforeCall(String name, String annotationId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getMovieAnnotation(Async)");
        }
        
        // verify the required parameter 'annotationId' is set
        if (annotationId == null) {
            throw new ApiException("Missing the required parameter 'annotationId' when calling getMovieAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = getMovieAnnotationCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page movie annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return MovieAnnotationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public MovieAnnotationResponse getMovieAnnotation(String name, String annotationId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<MovieAnnotationResponse> resp = getMovieAnnotationWithHttpInfo(name, annotationId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<MovieAnnotationResponse> resp = getMovieAnnotationWithHttpInfo(name, annotationId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page movie annotation by ID.
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;MovieAnnotationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<MovieAnnotationResponse> getMovieAnnotationWithHttpInfo(String name, String annotationId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getMovieAnnotationValidateBeforeCall(name, annotationId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<MovieAnnotationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page movie annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param annotationId The annotation ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getMovieAnnotationAsync(String name, String annotationId, String storage, String folder, final ApiCallback<MovieAnnotationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getMovieAnnotationValidateBeforeCall(name, annotationId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MovieAnnotationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPage
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPage(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPage(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page info.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return DocumentPageResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DocumentPageResponse getPage(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<DocumentPageResponse> resp = getPageWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<DocumentPageResponse> resp = getPageWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page info.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;DocumentPageResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DocumentPageResponse> getPageWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<DocumentPageResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page info. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<DocumentPageResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentPageResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page annotations. Returns only FreeTextAnnotations, TextAnnotations, other annotations will implemented next releases.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return AnnotationsInfoResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AnnotationsInfoResponse getPageAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<AnnotationsInfoResponse> resp = getPageAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<AnnotationsInfoResponse> resp = getPageAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page annotations. Returns only FreeTextAnnotations, TextAnnotations, other annotations will implemented next releases.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;AnnotationsInfoResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AnnotationsInfoResponse> getPageAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<AnnotationsInfoResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page annotations. Returns only FreeTextAnnotations, TextAnnotations, other annotations will implemented next releases. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<AnnotationsInfoResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnnotationsInfoResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageCaretAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageCaretAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/caret"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageCaretAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageCaretAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageCaretAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageCaretAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page caret annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return CaretAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CaretAnnotationsResponse getPageCaretAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<CaretAnnotationsResponse> resp = getPageCaretAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<CaretAnnotationsResponse> resp = getPageCaretAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page caret annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;CaretAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CaretAnnotationsResponse> getPageCaretAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageCaretAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<CaretAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page caret annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageCaretAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<CaretAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageCaretAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CaretAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageCheckBoxFields
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageCheckBoxFieldsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/page/{pageNumber}/fields/checkbox"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageCheckBoxFieldsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageCheckBoxFields(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageCheckBoxFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageCheckBoxFieldsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page checkbox fields.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return CheckBoxFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CheckBoxFieldsResponse getPageCheckBoxFields(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<CheckBoxFieldsResponse> resp = getPageCheckBoxFieldsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<CheckBoxFieldsResponse> resp = getPageCheckBoxFieldsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page checkbox fields.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;CheckBoxFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CheckBoxFieldsResponse> getPageCheckBoxFieldsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageCheckBoxFieldsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<CheckBoxFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page checkbox fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageCheckBoxFieldsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<CheckBoxFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageCheckBoxFieldsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CheckBoxFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageCircleAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageCircleAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/circle"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageCircleAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageCircleAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageCircleAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageCircleAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page circle annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return CircleAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CircleAnnotationsResponse getPageCircleAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<CircleAnnotationsResponse> resp = getPageCircleAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<CircleAnnotationsResponse> resp = getPageCircleAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page circle annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;CircleAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CircleAnnotationsResponse> getPageCircleAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageCircleAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<CircleAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page circle annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageCircleAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<CircleAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageCircleAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CircleAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageComboBoxFields
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageComboBoxFieldsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/page/{pageNumber}/fields/combobox"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageComboBoxFieldsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageComboBoxFields(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageComboBoxFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageComboBoxFieldsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page combobox fields.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ComboBoxFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ComboBoxFieldsResponse getPageComboBoxFields(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<ComboBoxFieldsResponse> resp = getPageComboBoxFieldsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<ComboBoxFieldsResponse> resp = getPageComboBoxFieldsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page combobox fields.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;ComboBoxFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ComboBoxFieldsResponse> getPageComboBoxFieldsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageComboBoxFieldsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<ComboBoxFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page combobox fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageComboBoxFieldsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<ComboBoxFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageComboBoxFieldsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ComboBoxFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageConvertToBmp
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToBmpCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/convert/bmp"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageConvertToBmpValidateBeforeCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageConvertToBmp(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageConvertToBmp(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageConvertToBmpCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert document page to Bmp image and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getPageConvertToBmp(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getPageConvertToBmpWithHttpInfo(name, pageNumber, width, height, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getPageConvertToBmpWithHttpInfo(name, pageNumber, width, height, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert document page to Bmp image and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getPageConvertToBmpWithHttpInfo(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getPageConvertToBmpValidateBeforeCall(name, pageNumber, width, height, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert document page to Bmp image and return resulting file in response. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToBmpAsync(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageConvertToBmpValidateBeforeCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageConvertToEmf
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToEmfCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/convert/emf"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageConvertToEmfValidateBeforeCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageConvertToEmf(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageConvertToEmf(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageConvertToEmfCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert document page to Emf image and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getPageConvertToEmf(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getPageConvertToEmfWithHttpInfo(name, pageNumber, width, height, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getPageConvertToEmfWithHttpInfo(name, pageNumber, width, height, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert document page to Emf image and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getPageConvertToEmfWithHttpInfo(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getPageConvertToEmfValidateBeforeCall(name, pageNumber, width, height, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert document page to Emf image and return resulting file in response. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToEmfAsync(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageConvertToEmfValidateBeforeCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageConvertToGif
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToGifCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/convert/gif"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageConvertToGifValidateBeforeCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageConvertToGif(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageConvertToGif(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageConvertToGifCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert document page to Gif image and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getPageConvertToGif(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getPageConvertToGifWithHttpInfo(name, pageNumber, width, height, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getPageConvertToGifWithHttpInfo(name, pageNumber, width, height, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert document page to Gif image and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getPageConvertToGifWithHttpInfo(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getPageConvertToGifValidateBeforeCall(name, pageNumber, width, height, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert document page to Gif image and return resulting file in response. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToGifAsync(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageConvertToGifValidateBeforeCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageConvertToJpeg
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToJpegCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/convert/jpeg"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageConvertToJpegValidateBeforeCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageConvertToJpeg(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageConvertToJpeg(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageConvertToJpegCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert document page to Jpeg image and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getPageConvertToJpeg(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getPageConvertToJpegWithHttpInfo(name, pageNumber, width, height, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getPageConvertToJpegWithHttpInfo(name, pageNumber, width, height, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert document page to Jpeg image and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getPageConvertToJpegWithHttpInfo(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getPageConvertToJpegValidateBeforeCall(name, pageNumber, width, height, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert document page to Jpeg image and return resulting file in response. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToJpegAsync(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageConvertToJpegValidateBeforeCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageConvertToPng
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToPngCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/convert/png"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageConvertToPngValidateBeforeCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageConvertToPng(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageConvertToPng(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageConvertToPngCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert document page to Png image and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getPageConvertToPng(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getPageConvertToPngWithHttpInfo(name, pageNumber, width, height, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getPageConvertToPngWithHttpInfo(name, pageNumber, width, height, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert document page to Png image and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getPageConvertToPngWithHttpInfo(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getPageConvertToPngValidateBeforeCall(name, pageNumber, width, height, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert document page to Png image and return resulting file in response. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToPngAsync(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageConvertToPngValidateBeforeCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageConvertToTiff
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToTiffCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/convert/tiff"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (width != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("width", width));
        if (height != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("height", height));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageConvertToTiffValidateBeforeCall(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageConvertToTiff(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageConvertToTiff(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageConvertToTiffCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Convert document page to Tiff image  and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File getPageConvertToTiff(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        try
        {
            ApiResponse<File> resp = getPageConvertToTiffWithHttpInfo(name, pageNumber, width, height, folder, storage);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<File> resp = getPageConvertToTiffWithHttpInfo(name, pageNumber, width, height, folder, storage);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Convert document page to Tiff image  and return resulting file in response.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> getPageConvertToTiffWithHttpInfo(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage) throws ApiException {
        com.squareup.okhttp.Call call = getPageConvertToTiffValidateBeforeCall(name, pageNumber, width, height, folder, storage, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Convert document page to Tiff image  and return resulting file in response. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param width The converted image width. (optional, default to 0)
     * @param height The converted image height. (optional, default to 0)
     * @param folder The document folder. (optional)
     * @param storage The document storage. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageConvertToTiffAsync(String name, Integer pageNumber, Integer width, Integer height, String folder, String storage, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageConvertToTiffValidateBeforeCall(name, pageNumber, width, height, folder, storage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageFileAttachmentAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageFileAttachmentAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/fileattachment"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageFileAttachmentAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageFileAttachmentAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageFileAttachmentAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageFileAttachmentAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page FileAttachment annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return FileAttachmentAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FileAttachmentAnnotationsResponse getPageFileAttachmentAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<FileAttachmentAnnotationsResponse> resp = getPageFileAttachmentAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<FileAttachmentAnnotationsResponse> resp = getPageFileAttachmentAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page FileAttachment annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;FileAttachmentAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FileAttachmentAnnotationsResponse> getPageFileAttachmentAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageFileAttachmentAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<FileAttachmentAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page FileAttachment annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageFileAttachmentAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<FileAttachmentAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageFileAttachmentAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileAttachmentAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageFreeTextAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageFreeTextAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/freetext"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageFreeTextAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageFreeTextAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageFreeTextAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageFreeTextAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page free text annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return FreeTextAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FreeTextAnnotationsResponse getPageFreeTextAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<FreeTextAnnotationsResponse> resp = getPageFreeTextAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<FreeTextAnnotationsResponse> resp = getPageFreeTextAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page free text annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;FreeTextAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FreeTextAnnotationsResponse> getPageFreeTextAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageFreeTextAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<FreeTextAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page free text annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageFreeTextAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<FreeTextAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageFreeTextAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FreeTextAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageHighlightAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageHighlightAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/highlight"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageHighlightAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageHighlightAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageHighlightAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageHighlightAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page highlight annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return HighlightAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public HighlightAnnotationsResponse getPageHighlightAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<HighlightAnnotationsResponse> resp = getPageHighlightAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<HighlightAnnotationsResponse> resp = getPageHighlightAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page highlight annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;HighlightAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<HighlightAnnotationsResponse> getPageHighlightAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageHighlightAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<HighlightAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page highlight annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageHighlightAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<HighlightAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageHighlightAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<HighlightAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageInkAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageInkAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/ink"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageInkAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageInkAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageInkAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageInkAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page ink annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return InkAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InkAnnotationsResponse getPageInkAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<InkAnnotationsResponse> resp = getPageInkAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<InkAnnotationsResponse> resp = getPageInkAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page ink annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;InkAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InkAnnotationsResponse> getPageInkAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageInkAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<InkAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page ink annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageInkAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<InkAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageInkAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InkAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageLineAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageLineAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/line"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageLineAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageLineAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageLineAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageLineAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page line annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return LineAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public LineAnnotationsResponse getPageLineAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<LineAnnotationsResponse> resp = getPageLineAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<LineAnnotationsResponse> resp = getPageLineAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page line annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;LineAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<LineAnnotationsResponse> getPageLineAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageLineAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<LineAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page line annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageLineAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<LineAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageLineAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LineAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageLinkAnnotation
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call getPageLinkAnnotationCall(String name, Integer pageNumber, String linkId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/links/{linkId}"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()))
            .replaceAll("\\{" + "linkId" + "\\}", apiClient.escapePathSegmentString(linkId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageLinkAnnotationValidateBeforeCall(String name, Integer pageNumber, String linkId, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageLinkAnnotation(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageLinkAnnotation(Async)");
        }
        
        // verify the required parameter 'linkId' is set
        if (linkId == null) {
            throw new ApiException("Missing the required parameter 'linkId' when calling getPageLinkAnnotation(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageLinkAnnotationCall(name, pageNumber, linkId, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page link annotation by ID.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return LinkAnnotationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public LinkAnnotationResponse getPageLinkAnnotation(String name, Integer pageNumber, String linkId, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<LinkAnnotationResponse> resp = getPageLinkAnnotationWithHttpInfo(name, pageNumber, linkId, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<LinkAnnotationResponse> resp = getPageLinkAnnotationWithHttpInfo(name, pageNumber, linkId, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page link annotation by ID.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;LinkAnnotationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public ApiResponse<LinkAnnotationResponse> getPageLinkAnnotationWithHttpInfo(String name, Integer pageNumber, String linkId, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageLinkAnnotationValidateBeforeCall(name, pageNumber, linkId, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<LinkAnnotationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page link annotation by ID. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param linkId The link ID. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call getPageLinkAnnotationAsync(String name, Integer pageNumber, String linkId, String storage, String folder, final ApiCallback<LinkAnnotationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageLinkAnnotationValidateBeforeCall(name, pageNumber, linkId, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LinkAnnotationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageLinkAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageLinkAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/links"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageLinkAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageLinkAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageLinkAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageLinkAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page link annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return LinkAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public LinkAnnotationsResponse getPageLinkAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<LinkAnnotationsResponse> resp = getPageLinkAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<LinkAnnotationsResponse> resp = getPageLinkAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page link annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;LinkAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<LinkAnnotationsResponse> getPageLinkAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageLinkAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<LinkAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page link annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageLinkAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<LinkAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageLinkAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LinkAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageListBoxFields
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageListBoxFieldsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/page/{pageNumber}/fields/listbox"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageListBoxFieldsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageListBoxFields(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageListBoxFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageListBoxFieldsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page listbox fields.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ListBoxFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListBoxFieldsResponse getPageListBoxFields(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<ListBoxFieldsResponse> resp = getPageListBoxFieldsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<ListBoxFieldsResponse> resp = getPageListBoxFieldsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page listbox fields.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;ListBoxFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListBoxFieldsResponse> getPageListBoxFieldsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageListBoxFieldsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<ListBoxFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page listbox fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageListBoxFieldsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<ListBoxFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageListBoxFieldsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListBoxFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageMovieAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageMovieAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/movie"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageMovieAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageMovieAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageMovieAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageMovieAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page movie annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return MovieAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public MovieAnnotationsResponse getPageMovieAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<MovieAnnotationsResponse> resp = getPageMovieAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<MovieAnnotationsResponse> resp = getPageMovieAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page movie annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;MovieAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<MovieAnnotationsResponse> getPageMovieAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageMovieAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<MovieAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page movie annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageMovieAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<MovieAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageMovieAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MovieAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPagePolyLineAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPagePolyLineAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/polyline"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPagePolyLineAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPagePolyLineAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPagePolyLineAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPagePolyLineAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page polyline annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return PolyLineAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PolyLineAnnotationsResponse getPagePolyLineAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<PolyLineAnnotationsResponse> resp = getPagePolyLineAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<PolyLineAnnotationsResponse> resp = getPagePolyLineAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page polyline annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;PolyLineAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PolyLineAnnotationsResponse> getPagePolyLineAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPagePolyLineAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<PolyLineAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page polyline annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPagePolyLineAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<PolyLineAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPagePolyLineAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PolyLineAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPagePolygonAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPagePolygonAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/polygon"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPagePolygonAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPagePolygonAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPagePolygonAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPagePolygonAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page polygon annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return PolygonAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PolygonAnnotationsResponse getPagePolygonAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<PolygonAnnotationsResponse> resp = getPagePolygonAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<PolygonAnnotationsResponse> resp = getPagePolygonAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page polygon annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;PolygonAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PolygonAnnotationsResponse> getPagePolygonAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPagePolygonAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<PolygonAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page polygon annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPagePolygonAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<PolygonAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPagePolygonAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PolygonAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPagePopupAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPagePopupAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/popup"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPagePopupAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPagePopupAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPagePopupAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPagePopupAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page popup annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return PopupAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PopupAnnotationsResponse getPagePopupAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<PopupAnnotationsResponse> resp = getPagePopupAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<PopupAnnotationsResponse> resp = getPagePopupAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page popup annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;PopupAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PopupAnnotationsResponse> getPagePopupAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPagePopupAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<PopupAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page popup annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPagePopupAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<PopupAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPagePopupAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PopupAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageRadioButtonFields
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageRadioButtonFieldsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/page/{pageNumber}/fields/radiobutton"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageRadioButtonFieldsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageRadioButtonFields(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageRadioButtonFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageRadioButtonFieldsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page radiobutton fields.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return RadioButtonFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RadioButtonFieldsResponse getPageRadioButtonFields(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<RadioButtonFieldsResponse> resp = getPageRadioButtonFieldsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<RadioButtonFieldsResponse> resp = getPageRadioButtonFieldsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page radiobutton fields.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;RadioButtonFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RadioButtonFieldsResponse> getPageRadioButtonFieldsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageRadioButtonFieldsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<RadioButtonFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page radiobutton fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageRadioButtonFieldsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<RadioButtonFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageRadioButtonFieldsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RadioButtonFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageRedactionAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageRedactionAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/redaction"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageRedactionAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageRedactionAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageRedactionAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageRedactionAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page redaction annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return RedactionAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RedactionAnnotationsResponse getPageRedactionAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<RedactionAnnotationsResponse> resp = getPageRedactionAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<RedactionAnnotationsResponse> resp = getPageRedactionAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page redaction annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;RedactionAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RedactionAnnotationsResponse> getPageRedactionAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageRedactionAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<RedactionAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page redaction annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageRedactionAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<RedactionAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageRedactionAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RedactionAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageScreenAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageScreenAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/screen"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageScreenAnnotationsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageScreenAnnotations(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageScreenAnnotations(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageScreenAnnotationsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page screen annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ScreenAnnotationsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ScreenAnnotationsResponse getPageScreenAnnotations(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<ScreenAnnotationsResponse> resp = getPageScreenAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<ScreenAnnotationsResponse> resp = getPageScreenAnnotationsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page screen annotations.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;ScreenAnnotationsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ScreenAnnotationsResponse> getPageScreenAnnotationsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageScreenAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<ScreenAnnotationsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page screen annotations. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageScreenAnnotationsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<ScreenAnnotationsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageScreenAnnotationsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ScreenAnnotationsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageSignatureFields
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageSignatureFieldsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/page/{pageNumber}/fields/signature"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPageSignatureFieldsValidateBeforeCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPageSignatureFields(Async)");
        }
        
        // verify the required parameter 'pageNumber' is set
        if (pageNumber == null) {
            throw new ApiException("Missing the required parameter 'pageNumber' when calling getPageSignatureFields(Async)");
        }
        

        com.squareup.okhttp.Call call = getPageSignatureFieldsCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Read document page signature fields.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return SignatureFieldsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SignatureFieldsResponse getPageSignatureFields(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        try
        {
            ApiResponse<SignatureFieldsResponse> resp = getPageSignatureFieldsWithHttpInfo(name, pageNumber, storage, folder);
            return resp.getData();
        }
        catch (ApiException ex)
        {
            if (ex.getCode() == 401)
            {
                apiClient.requestToken();
                ApiResponse<SignatureFieldsResponse> resp = getPageSignatureFieldsWithHttpInfo(name, pageNumber, storage, folder);
                return resp.getData();
            }
            throw ex;
        }
    }

    /**
     * Read document page signature fields.
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @return ApiResponse&lt;SignatureFieldsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SignatureFieldsResponse> getPageSignatureFieldsWithHttpInfo(String name, Integer pageNumber, String storage, String folder) throws ApiException {
        com.squareup.okhttp.Call call = getPageSignatureFieldsValidateBeforeCall(name, pageNumber, storage, folder, null, null);
        Type localVarReturnType = new TypeToken<SignatureFieldsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Read document page signature fields. (asynchronously)
     * 
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPageSignatureFieldsAsync(String name, Integer pageNumber, String storage, String folder, final ApiCallback<SignatureFieldsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPageSignatureFieldsValidateBeforeCall(name, pageNumber, storage, folder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SignatureFieldsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPageSoundAnnotations
     * @param name The document name. (required)
     * @param pageNumber The page number. (required)
     * @param storage The document storage. (optional)
     * @param folder The document folder. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPageSoundAnnotationsCall(String name, Integer pageNumber, String storage, String folder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pdf/{name}/pages/{pageNumber}/annotations/sound"
            .replaceAll("\\{" + "name" + "\\}", apiClient.escapePathSegmentString(name.toString()))
            .replaceAll("\\{" + "pageNumber" + "\\}", apiClient.escapePathSegmentString(pageNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (storage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("storage", storage));
        if (folder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("folder", folder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "JWT" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    