/*
 * Decompiled with CFR 0.152.
 */
package com.asksira.bsimagepicker.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import com.asksira.bsimagepicker.R;

public class FitWidthRelativeLayout
extends RelativeLayout {
    protected float aspectRatio;

    public FitWidthRelativeLayout(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FitWidthRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AspectRatioView, 0, 0);
        try {
            this.aspectRatio = a.getFloat(R.styleable.AspectRatioView_view_aspectRatio, 0.0f);
        }
        finally {
            a.recycle();
        }
    }

    public FitWidthRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.aspectRatio > 0.0f) {
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height = Math.round((float)View.MeasureSpec.getSize((int)widthMeasureSpec) / this.aspectRatio);
            int finalWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            int finalHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
            super.onMeasure(finalWidthMeasureSpec, finalHeightMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

