/*
 * Decompiled with CFR 0.152.
 */
package com.asksira.bsimagepicker;

import android.content.Context;
import android.net.Uri;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.asksira.bsimagepicker.BSImagePicker;
import com.asksira.bsimagepicker.R;
import com.asksira.bsimagepicker.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImageTileAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    private static final int VIEWTYPE_CAMERA = 101;
    private static final int VIEWTYPE_GALLERY = 102;
    private static final int VIEWTYPE_IMAGE = 103;
    private static final int VIEWTYPE_DUMMY = 104;
    private static final int VIEWTYPE_BOTTOM_SPACE = 105;
    protected Context context;
    protected List<File> imageList;
    protected boolean isMultiSelect;
    protected List<File> selectedFiles;
    protected int maximumSelectionCount = Integer.MAX_VALUE;
    protected int nonListItemCount;
    private boolean showCameraTile;
    private boolean showGalleryTile;
    private View.OnClickListener cameraTileOnClickListener;
    private View.OnClickListener galleryTileOnClickListener;
    private View.OnClickListener imageTileOnClickListener;
    private OnSelectedCountChangeListener onSelectedCountChangeListener;
    private OnOverSelectListener onOverSelectListener;
    private BSImagePicker.ImageLoaderDelegate imageLoaderDelegate;

    public ImageTileAdapter(Context context, BSImagePicker.ImageLoaderDelegate imageLoaderDelegate, boolean isMultiSelect, boolean showCameraTile, boolean showGalleryTile) {
        this.context = context;
        this.isMultiSelect = isMultiSelect;
        this.selectedFiles = new ArrayList<File>();
        this.showCameraTile = showCameraTile;
        this.showGalleryTile = showGalleryTile;
        this.imageLoaderDelegate = imageLoaderDelegate;
        this.nonListItemCount = isMultiSelect ? 0 : (showCameraTile && showGalleryTile ? 2 : (showCameraTile || showGalleryTile ? 1 : 0));
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 101: {
                return new CameraTileViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.item_picker_camera_tile, parent, false));
            }
            case 102: {
                return new GalleryTileViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.item_picker_gallery_tile, parent, false));
            }
            case 104: {
                return new DummyViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.item_picker_dummy_tile, parent, false));
            }
            case 105: {
                View view = new View(this.context);
                ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, Utils.dp2px(48));
                view.setLayoutParams(lp);
                return new DummyViewHolder(view);
            }
        }
        return new ImageTileViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.item_picker_image_tile, parent, false));
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        holder.bind(position);
    }

    public int getItemCount() {
        if (!this.isMultiSelect) {
            return this.imageList == null ? 16 : this.nonListItemCount + this.imageList.size();
        }
        return this.imageList == null ? 16 : this.imageList.size() + 1;
    }

    public int getItemViewType(int position) {
        if (!this.isMultiSelect) {
            switch (position) {
                case 0: {
                    if (this.showCameraTile) {
                        return 101;
                    }
                    if (this.showGalleryTile) {
                        return 102;
                    }
                    return this.imageList == null ? 104 : 103;
                }
                case 1: {
                    return this.showCameraTile && this.showGalleryTile ? 102 : (this.imageList == null ? 104 : 103);
                }
            }
            return this.imageList == null ? 104 : 103;
        }
        if (position == this.getItemCount() - 1) {
            return 105;
        }
        return this.imageList == null ? 104 : 103;
    }

    public void setSelectedFiles(List<File> selectedFiles) {
        this.selectedFiles = selectedFiles;
        this.notifyDataSetChanged();
        if (this.onSelectedCountChangeListener != null) {
            this.onSelectedCountChangeListener.onSelectedCountChange(selectedFiles.size());
        }
    }

    public List<Uri> getSelectedUris() {
        ArrayList<Uri> result = new ArrayList<Uri>();
        for (File each : this.selectedFiles) {
            result.add(Uri.fromFile((File)each));
        }
        return result;
    }

    public void setImageList(List<File> imageList) {
        this.imageList = imageList;
        this.notifyDataSetChanged();
    }

    public void setCameraTileOnClickListener(View.OnClickListener cameraTileOnClickListener) {
        this.cameraTileOnClickListener = cameraTileOnClickListener;
    }

    public void setGalleryTileOnClickListener(View.OnClickListener galleryTileOnClickListener) {
        this.galleryTileOnClickListener = galleryTileOnClickListener;
    }

    public void setImageTileOnClickListener(View.OnClickListener imageTileOnClickListener) {
        this.imageTileOnClickListener = imageTileOnClickListener;
    }

    public void setOnSelectedCountChangeListener(OnSelectedCountChangeListener onSelectedCountChangeListener) {
        this.onSelectedCountChangeListener = onSelectedCountChangeListener;
    }

    public void setMaximumSelectionCount(int maximumSelectionCount) {
        this.maximumSelectionCount = maximumSelectionCount;
    }

    public void setOnOverSelectListener(OnOverSelectListener onOverSelectListener) {
        this.onOverSelectListener = onOverSelectListener;
    }

    public class DummyViewHolder
    extends BaseViewHolder {
        public DummyViewHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void bind(int position) {
        }
    }

    public class ImageTileViewHolder
    extends BaseViewHolder {
        View darken;
        ImageView ivImage;
        ImageView ivTick;

        public ImageTileViewHolder(View itemView) {
            super(itemView);
            this.ivImage = (ImageView)itemView.findViewById(R.id.item_imageTile);
            this.darken = itemView.findViewById(R.id.imageTile_selected_darken);
            this.ivTick = (ImageView)itemView.findViewById(R.id.imageTile_selected);
            if (!ImageTileAdapter.this.isMultiSelect) {
                itemView.setOnClickListener(ImageTileAdapter.this.imageTileOnClickListener);
            } else {
                itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        File thisFile = ImageTileAdapter.this.imageList.get(ImageTileViewHolder.this.getAdapterPosition());
                        if (ImageTileAdapter.this.selectedFiles.contains(thisFile)) {
                            ImageTileAdapter.this.selectedFiles.remove(thisFile);
                            ImageTileAdapter.this.notifyItemChanged(ImageTileViewHolder.this.getAdapterPosition());
                        } else {
                            if (ImageTileAdapter.this.selectedFiles.size() == ImageTileAdapter.this.maximumSelectionCount) {
                                if (ImageTileAdapter.this.onOverSelectListener != null) {
                                    ImageTileAdapter.this.onOverSelectListener.onOverSelect();
                                }
                                return;
                            }
                            ImageTileAdapter.this.selectedFiles.add(thisFile);
                            ImageTileAdapter.this.notifyItemChanged(ImageTileViewHolder.this.getAdapterPosition());
                        }
                        if (ImageTileAdapter.this.onSelectedCountChangeListener != null) {
                            ImageTileAdapter.this.onSelectedCountChangeListener.onSelectedCountChange(ImageTileAdapter.this.selectedFiles.size());
                        }
                    }
                });
            }
        }

        @Override
        public void bind(int position) {
            if (ImageTileAdapter.this.imageList == null) {
                return;
            }
            File imageFile = ImageTileAdapter.this.imageList.get(position - ImageTileAdapter.this.nonListItemCount);
            this.itemView.setTag((Object)Uri.fromFile((File)imageFile));
            ImageTileAdapter.this.imageLoaderDelegate.loadImage(imageFile, this.ivImage);
            this.darken.setVisibility(ImageTileAdapter.this.selectedFiles.contains(imageFile) ? 0 : 4);
            this.ivTick.setVisibility(ImageTileAdapter.this.selectedFiles.contains(imageFile) ? 0 : 4);
        }
    }

    public class GalleryTileViewHolder
    extends BaseViewHolder {
        public GalleryTileViewHolder(View itemView) {
            super(itemView);
            itemView.setOnClickListener(ImageTileAdapter.this.galleryTileOnClickListener);
        }

        @Override
        public void bind(int position) {
        }
    }

    public class CameraTileViewHolder
    extends BaseViewHolder {
        public CameraTileViewHolder(View itemView) {
            super(itemView);
            itemView.setOnClickListener(ImageTileAdapter.this.cameraTileOnClickListener);
        }

        @Override
        public void bind(int position) {
        }
    }

    public static abstract class BaseViewHolder
    extends RecyclerView.ViewHolder {
        public BaseViewHolder(View itemView) {
            super(itemView);
        }

        public abstract void bind(int var1);
    }

    public static interface OnOverSelectListener {
        public void onOverSelect();
    }

    public static interface OnSelectedCountChangeListener {
        public void onSelectedCountChange(int var1);
    }
}

