/*
 * Decompiled with CFR 0.152.
 */
package com.asksira.bsimagepicker;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.design.R;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.FileProvider;
import android.support.v4.content.Loader;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.asksira.bsimagepicker.GridItemSpacingDecoration;
import com.asksira.bsimagepicker.ImageTileAdapter;
import com.asksira.bsimagepicker.R;
import com.asksira.bsimagepicker.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class BSImagePicker
extends BottomSheetDialogFragment
implements LoaderManager.LoaderCallbacks<Cursor> {
    private static final int LOADER_ID = 1000;
    private static final int PERMISSION_READ_STORAGE = 2001;
    private static final int PERMISSION_CAMERA = 2002;
    private static final int PERMISSION_WRITE_STORAGE = 2003;
    private static final int REQUEST_TAKE_PHOTO = 3001;
    private static final int REQUEST_SELECT_FROM_GALLERY = 3002;
    private RecyclerView recyclerView;
    private View bottomBarView;
    private TextView tvDone;
    private TextView tvMultiSelectMessage;
    private BottomSheetBehavior bottomSheetBehavior;
    private ImageTileAdapter adapter;
    private OnSingleImageSelectedListener onSingleImageSelectedListener;
    private OnMultiImageSelectedListener onMultiImageSelectedListener;
    private boolean isMultiSelection = false;
    private Uri currentPhotoUri;
    private int maximumDisplayingImages = Integer.MAX_VALUE;
    private int peekHeight = Utils.dp2px(360);
    private int minimumMultiSelectCount = 1;
    private int maximumMultiSelectCount = Integer.MAX_VALUE;
    private String providerAuthority;
    private boolean showCameraTile = true;
    private boolean showGalleryTile = true;
    private int spanCount = 3;
    private int gridSpacing = Utils.dp2px(2);
    private int multiSelectBarBgColor = 17170443;
    private int multiSelectTextColor = R.color.primary_text;
    private int multiSelectDoneTextColor = R.color.multiselect_done;
    private boolean showOverSelectMessage = true;
    private int overSelectTextColor = R.color.error_text;

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnSingleImageSelectedListener) {
            this.onSingleImageSelectedListener = (OnSingleImageSelectedListener)context;
        }
        if (context instanceof OnMultiImageSelectedListener) {
            this.onMultiImageSelectedListener = (OnMultiImageSelectedListener)context;
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.loadConfigFromBuilder();
        if (Utils.isReadStorageGranted(this.getContext())) {
            this.getLoaderManager().initLoader(1000, null, (LoaderManager.LoaderCallbacks)this);
        } else {
            Utils.checkPermission((Fragment)this, "android.permission.READ_EXTERNAL_STORAGE", 2001);
        }
        if (savedInstanceState != null) {
            this.currentPhotoUri = (Uri)savedInstanceState.getParcelable("currentPhotoUri");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.layout_imagepicker_sheet, container, false);
        this.bindViews(view);
        this.setupRecyclerView();
        if (this.getParentFragment() != null && this.getParentFragment() instanceof OnSingleImageSelectedListener) {
            this.onSingleImageSelectedListener = (OnSingleImageSelectedListener)this.getParentFragment();
        }
        if (this.getParentFragment() != null && this.getParentFragment() instanceof OnMultiImageSelectedListener) {
            this.onMultiImageSelectedListener = (OnMultiImageSelectedListener)this.getParentFragment();
        }
        return view;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        BottomSheetDialog dialog = (BottomSheetDialog)super.onCreateDialog(savedInstanceState);
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                BottomSheetDialog d = (BottomSheetDialog)dialog;
                FrameLayout bottomSheet = (FrameLayout)d.findViewById(R.id.design_bottom_sheet);
                if (bottomSheet != null) {
                    BSImagePicker.this.bottomSheetBehavior = BottomSheetBehavior.from((View)bottomSheet);
                    BSImagePicker.this.bottomSheetBehavior.setPeekHeight(BSImagePicker.this.peekHeight);
                    BSImagePicker.this.bottomSheetBehavior.setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

                        public void onStateChanged(@NonNull View bottomSheet, int newState) {
                            switch (newState) {
                                case 5: {
                                    BSImagePicker.this.dismiss();
                                }
                            }
                        }

                        public void onSlide(@NonNull View bottomSheet, float slideOffset) {
                            if (BSImagePicker.this.bottomBarView != null) {
                                BSImagePicker.this.bottomBarView.setAlpha(slideOffset < 0.0f ? 1.0f + slideOffset : 1.0f);
                            }
                        }
                    });
                }
            }
        });
        return dialog;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        ArrayList savedUriList;
        super.onActivityCreated(savedInstanceState);
        if (this.isMultiSelection) {
            this.setupBottomBar(this.getView());
        }
        if (savedInstanceState != null && this.adapter != null && (savedUriList = savedInstanceState.getParcelableArrayList("selectedImages")) != null) {
            ArrayList<File> fileList = new ArrayList<File>();
            for (Uri each : savedUriList) {
                File file = new File(URI.create(each.toString()));
                fileList.add(file);
            }
            this.adapter.setSelectedFiles(fileList);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (this.getContext() == null) {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            return;
        }
        switch (requestCode) {
            case 2001: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.getLoaderManager().initLoader(1000, null, (LoaderManager.LoaderCallbacks)this);
                    break;
                }
                this.dismiss();
                break;
            }
            case 2002: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    if (Utils.isWriteStorageGranted(this.getContext())) {
                        this.launchCamera();
                    } else {
                        Utils.checkPermission((Fragment)this, "android.permission.WRITE_EXTERNAL_STORAGE", 2003);
                    }
                }
            }
            case 2003: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    if (Utils.isCameraGranted(this.getContext())) {
                        this.launchCamera();
                    } else {
                        Utils.checkPermission((Fragment)this, "android.permission.CAMERA", 2002);
                    }
                }
            }
            default: {
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 3001: {
                if (resultCode == -1) {
                    this.notifyGallery();
                    if (this.onSingleImageSelectedListener == null) break;
                    this.onSingleImageSelectedListener.onSingleImageSelected(this.currentPhotoUri);
                    this.dismiss();
                    break;
                }
                try {
                    File file = new File(URI.create(this.currentPhotoUri.toString()));
                    file.delete();
                }
                catch (Exception e) {}
                break;
            }
            case 3002: {
                if (resultCode != -1 || this.onSingleImageSelectedListener == null) break;
                this.onSingleImageSelectedListener.onSingleImageSelected(data.getData());
                this.dismiss();
                break;
            }
            default: {
                super.onActivityResult(requestCode, resultCode, data);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelableArrayList("selectedImages", (ArrayList)this.adapter.getSelectedUris());
        outState.putParcelable("currentPhotoUri", (Parcelable)this.currentPhotoUri);
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        if (id2 == 1000 && this.getContext() != null) {
            Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            String[] projection = new String[]{"_data"};
            String sortOrder = "date_added DESC";
            return new CursorLoader(this.getContext(), uri, projection, null, null, sortOrder);
        }
        return null;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        if (cursor != null) {
            ArrayList<File> uriList = new ArrayList<File>();
            for (int index = 0; cursor.moveToNext() && index < this.maximumDisplayingImages; ++index) {
                String imagePath = cursor.getString(cursor.getColumnIndex("_data"));
                uriList.add(new File(imagePath));
            }
            cursor.moveToPosition(-1);
            this.adapter.setImageList(uriList);
        }
    }

    public void onLoaderReset(Loader loader) {
        this.adapter.setImageList(null);
    }

    private void loadConfigFromBuilder() {
        try {
            this.providerAuthority = this.getArguments().getString("providerAuthority");
            this.isMultiSelection = this.getArguments().getBoolean("isMultiSelect");
            this.maximumDisplayingImages = this.getArguments().getInt("maximumDisplayingImages");
            this.minimumMultiSelectCount = this.getArguments().getInt("minimumMultiSelectCount");
            this.maximumMultiSelectCount = this.getArguments().getInt("maximumMultiSelectCount");
            this.showCameraTile = this.getArguments().getBoolean("showCameraTile");
            this.showGalleryTile = this.getArguments().getBoolean("showGalleryTile");
            this.spanCount = this.getArguments().getInt("spanCount");
            this.peekHeight = this.getArguments().getInt("peekHeight");
            this.gridSpacing = this.getArguments().getInt("gridSpacing");
            this.multiSelectBarBgColor = this.getArguments().getInt("multiSelectBarBgColor");
            this.multiSelectTextColor = this.getArguments().getInt("multiSelectTextColor");
            this.multiSelectDoneTextColor = this.getArguments().getInt("multiSelectDoneTextColor");
            this.showOverSelectMessage = this.getArguments().getBoolean("showOverSelectMessage");
            this.overSelectTextColor = this.getArguments().getInt("overSelectTextColor");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bindViews(View rootView) {
        this.recyclerView = (RecyclerView)rootView.findViewById(R.id.picker_recyclerview);
    }

    private void setupRecyclerView() {
        GridLayoutManager gll = new GridLayoutManager(this.getContext(), this.spanCount);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)gll);
        ((SimpleItemAnimator)this.recyclerView.getItemAnimator()).setSupportsChangeAnimations(false);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridItemSpacingDecoration(this.spanCount, this.gridSpacing, false));
        if (this.adapter == null) {
            this.adapter = new ImageTileAdapter(this.getContext(), this.isMultiSelection, this.showCameraTile, this.showGalleryTile);
            this.adapter.setMaximumSelectionCount(this.maximumMultiSelectCount);
            this.adapter.setCameraTileOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (Utils.isCameraGranted(BSImagePicker.this.getContext()) && Utils.isWriteStorageGranted(BSImagePicker.this.getContext())) {
                        BSImagePicker.this.launchCamera();
                    } else if (Utils.isCameraGranted(BSImagePicker.this.getContext())) {
                        Utils.checkPermission((Fragment)BSImagePicker.this, "android.permission.WRITE_EXTERNAL_STORAGE", 2003);
                    } else {
                        Utils.checkPermission((Fragment)BSImagePicker.this, "android.permission.CAMERA", 2002);
                    }
                }
            });
            this.adapter.setGalleryTileOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!BSImagePicker.this.isMultiSelection) {
                        Intent intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                        BSImagePicker.this.startActivityForResult(intent, 3002);
                    }
                }
            });
            this.adapter.setImageTileOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (v.getTag() != null && v.getTag() instanceof Uri && BSImagePicker.this.onSingleImageSelectedListener != null) {
                        BSImagePicker.this.onSingleImageSelectedListener.onSingleImageSelected((Uri)v.getTag());
                        BSImagePicker.this.dismiss();
                    }
                }
            });
            if (this.isMultiSelection) {
                this.adapter.setOnSelectedCountChangeListener(new ImageTileAdapter.OnSelectedCountChangeListener(){

                    @Override
                    public void onSelectedCountChange(int currentCount) {
                        BSImagePicker.this.updateSelectCount(currentCount);
                    }
                });
                this.adapter.setOnOverSelectListener(new ImageTileAdapter.OnOverSelectListener(){

                    @Override
                    public void onOverSelect() {
                        if (BSImagePicker.this.showOverSelectMessage) {
                            BSImagePicker.this.showOverSelectMessage();
                        }
                    }
                });
            }
        }
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    private void setupBottomBar(View rootView) {
        CoordinatorLayout parentView = (CoordinatorLayout)rootView.getParent().getParent();
        this.bottomBarView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.item_picker_multiselection_bar, (ViewGroup)parentView, false);
        ViewCompat.setTranslationZ((View)this.bottomBarView, (float)ViewCompat.getZ((View)((View)rootView.getParent())));
        parentView.addView(this.bottomBarView, -1);
        this.bottomBarView.findViewById(R.id.multiselect_bar_bg).setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)this.multiSelectBarBgColor));
        this.tvMultiSelectMessage = (TextView)this.bottomBarView.findViewById(R.id.tv_multiselect_message);
        this.tvMultiSelectMessage.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)this.multiSelectTextColor));
        this.tvMultiSelectMessage.setText((CharSequence)(this.minimumMultiSelectCount == 1 ? this.getString(R.string.imagepicker_multiselect_not_enough_singular) : this.getString(R.string.imagepicker_multiselect_not_enough_plural, new Object[]{this.minimumMultiSelectCount})));
        this.tvDone = (TextView)this.bottomBarView.findViewById(R.id.tv_multiselect_done);
        this.tvDone.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)this.multiSelectDoneTextColor));
        this.tvDone.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BSImagePicker.this.onMultiImageSelectedListener != null) {
                    BSImagePicker.this.onMultiImageSelectedListener.onMultiImageSelected(BSImagePicker.this.adapter.getSelectedUris());
                    BSImagePicker.this.dismiss();
                }
            }
        });
        this.tvDone.setAlpha(0.4f);
        this.tvDone.setEnabled(false);
    }

    private void launchCamera() {
        if (this.getContext() == null) {
            return;
        }
        Intent takePhotoIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePhotoIntent.resolveActivity(this.getContext().getPackageManager()) != null) {
            File photoFile = null;
            try {
                photoFile = this.createImageFile();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (photoFile != null) {
                Uri photoURI = FileProvider.getUriForFile((Context)this.getContext(), (String)this.providerAuthority, (File)photoFile);
                takePhotoIntent.putExtra("output", (Parcelable)photoURI);
                List resolvedIntentActivities = this.getContext().getPackageManager().queryIntentActivities(takePhotoIntent, 65536);
                for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
                    String packageName = resolvedIntentInfo.activityInfo.packageName;
                    this.getContext().grantUriPermission(packageName, photoURI, 3);
                }
                this.startActivityForResult(takePhotoIntent, 3001);
            }
        }
    }

    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        File image = File.createTempFile(imageFileName, ".jpg", storageDir);
        this.currentPhotoUri = Uri.fromFile((File)image);
        return image;
    }

    private void notifyGallery() {
        if (this.getContext() == null) {
            return;
        }
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        mediaScanIntent.setData(this.currentPhotoUri);
        this.getContext().sendBroadcast(mediaScanIntent);
    }

    private void updateSelectCount(int newCount) {
        if (this.getContext() == null) {
            return;
        }
        if (this.tvMultiSelectMessage != null) {
            this.tvMultiSelectMessage.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)this.multiSelectTextColor));
            if (newCount < this.minimumMultiSelectCount) {
                this.tvMultiSelectMessage.setText((CharSequence)(this.minimumMultiSelectCount - newCount == 1 ? this.getString(R.string.imagepicker_multiselect_not_enough_singular) : this.getString(R.string.imagepicker_multiselect_not_enough_plural, new Object[]{this.minimumMultiSelectCount - newCount})));
                this.tvDone.setAlpha(0.4f);
                this.tvDone.setEnabled(false);
            } else {
                this.tvMultiSelectMessage.setText((CharSequence)(newCount == 1 ? this.getString(R.string.imagepicker_multiselect_enough_singular) : this.getString(R.string.imagepicker_multiselect_enough_plural, new Object[]{newCount})));
                this.tvDone.setAlpha(1.0f);
                this.tvDone.setEnabled(true);
            }
        }
    }

    private void showOverSelectMessage() {
        if (this.tvMultiSelectMessage != null && this.getContext() != null) {
            this.tvMultiSelectMessage.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)this.overSelectTextColor));
            this.tvMultiSelectMessage.setText((CharSequence)this.getString(R.string.imagepicker_multiselect_overselect, new Object[]{this.maximumMultiSelectCount}));
        }
    }

    public static class Builder {
        private String providerAuthority;
        private boolean isMultiSelect;
        private int maximumDisplayingImages = Integer.MAX_VALUE;
        private int minimumMultiSelectCount = 1;
        private int maximumMultiSelectCount = Integer.MAX_VALUE;
        private boolean showCameraTile = true;
        private boolean showGalleryTile = true;
        private int peekHeight = Utils.dp2px(360);
        private int spanCount = 3;
        private int gridSpacing = Utils.dp2px(2);
        private int multiSelectBarBgColor = 17170443;
        private int multiSelectTextColor = R.color.primary_text;
        private int multiSelectDoneTextColor = R.color.multiselect_done;
        private boolean showOverSelectMessage = true;
        private int overSelectTextColor = R.color.error_text;

        public Builder(String providerAuthority) {
            this.providerAuthority = providerAuthority;
        }

        public Builder isMultiSelect() {
            this.isMultiSelect = true;
            return this;
        }

        public Builder setMaximumDisplayingImages(int maximumDisplayingImages) {
            this.maximumDisplayingImages = maximumDisplayingImages;
            return this;
        }

        public Builder setMinimumMultiSelectCount(int minimumMultiSelectCount) {
            this.minimumMultiSelectCount = minimumMultiSelectCount;
            return this;
        }

        public Builder setMaximumMultiSelectCount(int maximumMultiSelectCount) {
            this.maximumMultiSelectCount = maximumMultiSelectCount;
            return this;
        }

        public Builder setGridSpacing(@Px int gridSpacing) {
            this.gridSpacing = gridSpacing;
            return this;
        }

        public Builder setMultiSelectBarBgColor(@ColorRes int multiSelectBarBgColor) {
            this.multiSelectBarBgColor = multiSelectBarBgColor;
            return this;
        }

        public Builder setMultiSelectDoneTextColor(@ColorRes int multiSelectDoneTextColor) {
            this.multiSelectDoneTextColor = multiSelectDoneTextColor;
            return this;
        }

        public Builder setMultiSelectTextColor(@ColorRes int multiSelectTextColor) {
            this.multiSelectTextColor = multiSelectTextColor;
            return this;
        }

        public Builder setOverSelectTextColor(@ColorRes int overSelectTextColor) {
            this.overSelectTextColor = overSelectTextColor;
            return this;
        }

        public Builder setPeekHeight(@Px int peekHeight) {
            this.peekHeight = peekHeight;
            return this;
        }

        public Builder hideCameraTile() {
            this.showCameraTile = false;
            return this;
        }

        public Builder hideGalleryTile() {
            this.showGalleryTile = false;
            return this;
        }

        public Builder disableOverSelectionMessage() {
            this.showOverSelectMessage = false;
            return this;
        }

        public Builder setSpanCount(int spanCount) {
            this.spanCount = spanCount;
            return this;
        }

        public BSImagePicker build() {
            Bundle args = new Bundle();
            args.putString("providerAuthority", this.providerAuthority);
            args.putBoolean("isMultiSelect", this.isMultiSelect);
            args.putInt("maximumDisplayingImages", this.maximumDisplayingImages);
            args.putInt("minimumMultiSelectCount", this.minimumMultiSelectCount);
            args.putInt("maximumMultiSelectCount", this.maximumMultiSelectCount);
            args.putBoolean("showCameraTile", this.showCameraTile);
            args.putBoolean("showGalleryTile", this.showGalleryTile);
            args.putInt("peekHeight", this.peekHeight);
            args.putInt("spanCount", this.spanCount);
            args.putInt("gridSpacing", this.gridSpacing);
            args.putInt("multiSelectBarBgColor", this.multiSelectBarBgColor);
            args.putInt("multiSelectTextColor", this.multiSelectTextColor);
            args.putInt("multiSelectDoneTextColor", this.multiSelectDoneTextColor);
            args.putBoolean("showOverSelectMessage", this.showOverSelectMessage);
            args.putInt("overSelectTextColor", this.overSelectTextColor);
            BSImagePicker fragment = new BSImagePicker();
            fragment.setArguments(args);
            return fragment;
        }
    }

    public static interface OnMultiImageSelectedListener {
        public void onMultiImageSelected(List<Uri> var1);
    }

    public static interface OnSingleImageSelectedListener {
        public void onSingleImageSelected(Uri var1);
    }
}

