/*
 * Decompiled with CFR 0.152.
 */
package com.arthurivanets.mvvm.navigation.util;

import android.os.Bundle;
import androidx.navigation.NavArgument;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\r"}, d2={"isOnStartDestination", "", "Landroidx/navigation/NavController;", "(Landroidx/navigation/NavController;)Z", "newNavArgument", "Landroidx/navigation/NavArgument;", "value", "", "addExtras", "", "Landroidx/navigation/NavGraph;", "extras", "Landroid/os/Bundle;", "mvvm-navigation_release"})
@JvmName(name="NavigationUtils")
public final class NavigationUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOnStartDestination(@NotNull NavController $this$isOnStartDestination) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isOnStartDestination, (String)"$this$isOnStartDestination");
        NavDestination navDestination = $this$isOnStartDestination.getCurrentDestination();
        if (navDestination == null) return false;
        int n = navDestination.getId();
        NavGraph navGraph = $this$isOnStartDestination.getGraph();
        Intrinsics.checkExpressionValueIsNotNull((Object)navGraph, (String)"this.graph");
        if (n != navGraph.getStartDestination()) return false;
        return true;
    }

    public static final void addExtras(@NotNull NavGraph $this$addExtras, @NotNull Bundle extras) {
        Intrinsics.checkParameterIsNotNull((Object)$this$addExtras, (String)"$this$addExtras");
        Intrinsics.checkParameterIsNotNull((Object)extras, (String)"extras");
        for (String key : extras.keySet()) {
            $this$addExtras.addArgument(key, NavigationUtils.newNavArgument(extras.get(key)));
        }
    }

    private static final NavArgument newNavArgument(Object value) {
        NavArgument navArgument = new NavArgument.Builder().setDefaultValue(value).setIsNullable(value == null).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)navArgument, (String)"NavArgument.Builder()\n  \u2026== null)\n        .build()");
        return navArgument;
    }
}

