/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.http.protocol;

import com.github.dockerjava.shaded.org.apache.http.HttpException;
import com.github.dockerjava.shaded.org.apache.http.HttpRequest;
import com.github.dockerjava.shaded.org.apache.http.HttpRequestInterceptor;
import com.github.dockerjava.shaded.org.apache.http.annotation.Contract;
import com.github.dockerjava.shaded.org.apache.http.annotation.ThreadingBehavior;
import com.github.dockerjava.shaded.org.apache.http.protocol.HttpContext;
import com.github.dockerjava.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

