/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.io.netty.handler.ssl;

import com.github.dockerjava.shaded.io.netty.handler.ssl.ApplicationProtocolAccessor;
import com.github.dockerjava.shaded.io.netty.handler.ssl.ExtendedOpenSslSession;
import com.github.dockerjava.shaded.io.netty.handler.ssl.JdkSslEngine;
import com.github.dockerjava.shaded.io.netty.util.internal.EmptyArrays;
import com.github.dockerjava.shaded.io.netty.util.internal.PlatformDependent;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.security.cert.X509Certificate;

final class OpenSslTlsv13X509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager tm;

    private OpenSslTlsv13X509ExtendedTrustManager(X509ExtendedTrustManager tm) {
        this.tm = tm;
    }

    static X509ExtendedTrustManager wrap(X509ExtendedTrustManager tm, boolean client) {
        if (PlatformDependent.javaVersion() < 11) {
            java.security.cert.X509Certificate[] certs = new java.security.cert.X509Certificate[1];
            try {
                if (client) {
                    tm.checkServerTrusted(certs, "RSA", new DummySSLEngine(true));
                } else {
                    tm.checkClientTrusted(certs, "RSA", new DummySSLEngine(false));
                }
            }
            catch (IllegalArgumentException e) {
                return new OpenSslTlsv13X509ExtendedTrustManager(tm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return tm;
    }

    @Override
    public void checkClientTrusted(java.security.cert.X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(x509Certificates, s, socket);
    }

    @Override
    public void checkServerTrusted(java.security.cert.X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(x509Certificates, s, socket);
    }

    private static SSLEngine wrapEngine(final SSLEngine engine) {
        final SSLSession session = engine.getHandshakeSession();
        if (session != null && "TLSv1.3".equals(session.getProtocol())) {
            return new JdkSslEngine(engine){

                @Override
                public String getNegotiatedApplicationProtocol() {
                    if (engine instanceof ApplicationProtocolAccessor) {
                        return ((ApplicationProtocolAccessor)((Object)engine)).getNegotiatedApplicationProtocol();
                    }
                    return super.getNegotiatedApplicationProtocol();
                }

                @Override
                public SSLSession getHandshakeSession() {
                    if (PlatformDependent.javaVersion() >= 7 && session instanceof ExtendedOpenSslSession) {
                        final ExtendedOpenSslSession extendedOpenSslSession = (ExtendedOpenSslSession)session;
                        return new ExtendedOpenSslSession(extendedOpenSslSession){

                            @Override
                            public List getRequestedServerNames() {
                                return extendedOpenSslSession.getRequestedServerNames();
                            }

                            @Override
                            public String[] getPeerSupportedSignatureAlgorithms() {
                                return extendedOpenSslSession.getPeerSupportedSignatureAlgorithms();
                            }

                            @Override
                            public String getProtocol() {
                                return "TLSv1.2";
                            }
                        };
                    }
                    return new SSLSession(){

                        @Override
                        public byte[] getId() {
                            return session.getId();
                        }

                        @Override
                        public SSLSessionContext getSessionContext() {
                            return session.getSessionContext();
                        }

                        @Override
                        public long getCreationTime() {
                            return session.getCreationTime();
                        }

                        @Override
                        public long getLastAccessedTime() {
                            return session.getLastAccessedTime();
                        }

                        @Override
                        public void invalidate() {
                            session.invalidate();
                        }

                        @Override
                        public boolean isValid() {
                            return session.isValid();
                        }

                        @Override
                        public void putValue(String s, Object o) {
                            session.putValue(s, o);
                        }

                        @Override
                        public Object getValue(String s) {
                            return session.getValue(s);
                        }

                        @Override
                        public void removeValue(String s) {
                            session.removeValue(s);
                        }

                        @Override
                        public String[] getValueNames() {
                            return session.getValueNames();
                        }

                        @Override
                        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
                            return session.getPeerCertificates();
                        }

                        @Override
                        public Certificate[] getLocalCertificates() {
                            return session.getLocalCertificates();
                        }

                        @Override
                        public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
                            return session.getPeerCertificateChain();
                        }

                        @Override
                        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
                            return session.getPeerPrincipal();
                        }

                        @Override
                        public Principal getLocalPrincipal() {
                            return session.getLocalPrincipal();
                        }

                        @Override
                        public String getCipherSuite() {
                            return session.getCipherSuite();
                        }

                        @Override
                        public String getProtocol() {
                            return "TLSv1.2";
                        }

                        @Override
                        public String getPeerHost() {
                            return session.getPeerHost();
                        }

                        @Override
                        public int getPeerPort() {
                            return session.getPeerPort();
                        }

                        @Override
                        public int getPacketBufferSize() {
                            return session.getPacketBufferSize();
                        }

                        @Override
                        public int getApplicationBufferSize() {
                            return session.getApplicationBufferSize();
                        }
                    };
                }
            };
        }
        return engine;
    }

    @Override
    public void checkClientTrusted(java.security.cert.X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        this.tm.checkClientTrusted(x509Certificates, s, OpenSslTlsv13X509ExtendedTrustManager.wrapEngine(sslEngine));
    }

    @Override
    public void checkServerTrusted(java.security.cert.X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        this.tm.checkServerTrusted(x509Certificates, s, OpenSslTlsv13X509ExtendedTrustManager.wrapEngine(sslEngine));
    }

    @Override
    public void checkClientTrusted(java.security.cert.X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.tm.checkClientTrusted(x509Certificates, s);
    }

    @Override
    public void checkServerTrusted(java.security.cert.X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.tm.checkServerTrusted(x509Certificates, s);
    }

    @Override
    public java.security.cert.X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }

    private static final class DummySSLEngine
    extends SSLEngine {
        private final boolean client;

        DummySSLEngine(boolean client) {
            this.client = client;
        }

        @Override
        public SSLSession getHandshakeSession() {
            return new SSLSession(){

                @Override
                public byte[] getId() {
                    return EmptyArrays.EMPTY_BYTES;
                }

                @Override
                public SSLSessionContext getSessionContext() {
                    return null;
                }

                @Override
                public long getCreationTime() {
                    return 0L;
                }

                @Override
                public long getLastAccessedTime() {
                    return 0L;
                }

                @Override
                public void invalidate() {
                }

                @Override
                public boolean isValid() {
                    return false;
                }

                @Override
                public void putValue(String s, Object o) {
                }

                @Override
                public Object getValue(String s) {
                    return null;
                }

                @Override
                public void removeValue(String s) {
                }

                @Override
                public String[] getValueNames() {
                    return EmptyArrays.EMPTY_STRINGS;
                }

                @Override
                public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
                    return EmptyArrays.EMPTY_CERTIFICATES;
                }

                @Override
                public Certificate[] getLocalCertificates() {
                    return EmptyArrays.EMPTY_CERTIFICATES;
                }

                @Override
                public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
                    return EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
                }

                @Override
                public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
                    return null;
                }

                @Override
                public Principal getLocalPrincipal() {
                    return null;
                }

                @Override
                public String getCipherSuite() {
                    return null;
                }

                @Override
                public String getProtocol() {
                    return "TLSv1.3";
                }

                @Override
                public String getPeerHost() {
                    return null;
                }

                @Override
                public int getPeerPort() {
                    return 0;
                }

                @Override
                public int getPacketBufferSize() {
                    return 0;
                }

                @Override
                public int getApplicationBufferSize() {
                    return 0;
                }
            };
        }

        @Override
        public SSLEngineResult wrap(ByteBuffer[] byteBuffers, int i, int i1, ByteBuffer byteBuffer) throws SSLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBuffers, int i, int i1) throws SSLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Runnable getDelegatedTask() {
            return null;
        }

        @Override
        public void closeInbound() throws SSLException {
        }

        @Override
        public boolean isInboundDone() {
            return true;
        }

        @Override
        public void closeOutbound() {
        }

        @Override
        public boolean isOutboundDone() {
            return true;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return EmptyArrays.EMPTY_STRINGS;
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return EmptyArrays.EMPTY_STRINGS;
        }

        @Override
        public void setEnabledCipherSuites(String[] strings) {
        }

        @Override
        public String[] getSupportedProtocols() {
            return new String[]{"TLSv1.3"};
        }

        @Override
        public String[] getEnabledProtocols() {
            return new String[]{"TLSv1.3"};
        }

        @Override
        public void setEnabledProtocols(String[] strings) {
        }

        @Override
        public SSLSession getSession() {
            return this.getHandshakeSession();
        }

        @Override
        public void beginHandshake() throws SSLException {
        }

        @Override
        public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }

        @Override
        public void setUseClientMode(boolean b) {
        }

        @Override
        public boolean getUseClientMode() {
            return this.client;
        }

        @Override
        public void setNeedClientAuth(boolean b) {
        }

        @Override
        public boolean getNeedClientAuth() {
            return false;
        }

        @Override
        public void setWantClientAuth(boolean b) {
        }

        @Override
        public boolean getWantClientAuth() {
            return false;
        }

        @Override
        public void setEnableSessionCreation(boolean b) {
        }

        @Override
        public boolean getEnableSessionCreation() {
            return false;
        }
    }
}

