/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ServiceGlobalModeOptions;
import com.github.dockerjava.api.model.ServiceMode;
import com.github.dockerjava.api.model.ServiceReplicatedModeOptions;
import com.github.dockerjava.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.shaded.javax.annotation.CheckForNull;
import com.github.dockerjava.shaded.org.apache.commons.lang.builder.EqualsBuilder;
import com.github.dockerjava.shaded.org.apache.commons.lang.builder.HashCodeBuilder;
import com.github.dockerjava.shaded.org.apache.commons.lang.builder.ToStringBuilder;
import com.github.dockerjava.shaded.org.apache.commons.lang.builder.ToStringStyle;
import java.io.Serializable;

public class ServiceModeConfig
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="Replicated")
    private ServiceReplicatedModeOptions replicated;
    @JsonProperty(value="Global")
    private ServiceGlobalModeOptions global;

    @CheckForNull
    public ServiceMode getMode() {
        if (this.replicated != null) {
            return ServiceMode.REPLICATED;
        }
        if (this.global != null) {
            return ServiceMode.GLOBAL;
        }
        return null;
    }

    @CheckForNull
    public ServiceReplicatedModeOptions getReplicated() {
        return this.replicated;
    }

    public ServiceModeConfig withReplicated(ServiceReplicatedModeOptions replicated) {
        if (replicated != null && this.global != null) {
            throw new IllegalStateException("Cannot set both replicated and global mode");
        }
        this.replicated = replicated;
        return this;
    }

    @CheckForNull
    public ServiceGlobalModeOptions getGlobal() {
        return this.global;
    }

    public ServiceModeConfig withGlobal(ServiceGlobalModeOptions global) {
        if (global != null && this.replicated != null) {
            throw new IllegalStateException("Cannot set both global and replicated mode");
        }
        this.global = global;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
}

