/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ContainerHostConfig;
import com.github.dockerjava.api.model.ContainerMount;
import com.github.dockerjava.api.model.ContainerNetworkSettings;
import com.github.dockerjava.api.model.ContainerPort;
import com.github.dockerjava.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.github.dockerjava.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import com.github.dockerjava.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.shaded.javax.annotation.CheckForNull;
import com.github.dockerjava.shaded.org.apache.commons.lang.builder.EqualsBuilder;
import com.github.dockerjava.shaded.org.apache.commons.lang.builder.HashCodeBuilder;
import com.github.dockerjava.shaded.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Container
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="Command")
    private String command;
    @JsonProperty(value="Created")
    private Long created;
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="ImageID")
    private String imageId;
    @JsonProperty(value="Names")
    private String[] names;
    @JsonProperty(value="Ports")
    public ContainerPort[] ports;
    @JsonProperty(value="Labels")
    public Map<String, String> labels;
    @JsonProperty(value="Status")
    private String status;
    @JsonProperty(value="State")
    private String state;
    @JsonProperty(value="SizeRw")
    private Long sizeRw;
    @JsonProperty(value="SizeRootFs")
    private Long sizeRootFs;
    @JsonProperty(value="HostConfig")
    private ContainerHostConfig hostConfig;
    @JsonProperty(value="NetworkSettings")
    private ContainerNetworkSettings networkSettings;
    @JsonProperty(value="Mounts")
    private List<ContainerMount> mounts;

    public String getId() {
        return this.id;
    }

    public String getCommand() {
        return this.command;
    }

    public String getImage() {
        return this.image;
    }

    @CheckForNull
    public String getImageId() {
        return this.imageId;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getStatus() {
        return this.status;
    }

    public String getState() {
        return this.state;
    }

    public ContainerPort[] getPorts() {
        return this.ports;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String[] getNames() {
        return this.names;
    }

    @CheckForNull
    public Long getSizeRw() {
        return this.sizeRw;
    }

    @CheckForNull
    public Long getSizeRootFs() {
        return this.sizeRootFs;
    }

    @CheckForNull
    public ContainerNetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    @CheckForNull
    public ContainerHostConfig getHostConfig() {
        return this.hostConfig;
    }

    public List<ContainerMount> getMounts() {
        return this.mounts;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
}

