/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.crypto.generators;

import com.github.dockerjava.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.github.dockerjava.shaded.org.bouncycastle.math.ec.ECConstants;
import com.github.dockerjava.shaded.org.bouncycastle.math.ec.ECMultiplier;
import com.github.dockerjava.shaded.org.bouncycastle.math.ec.ECPoint;
import com.github.dockerjava.shaded.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.github.dockerjava.shaded.org.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
        if (this.random == null) {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = new BigInteger(n, this.random)).compareTo(TWO) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

