/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.types.resources;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.Project;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Reference;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Resource;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.ResourceFactory;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.resources.Appendable;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.resources.FileProvider;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.resources.Touchable;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileResource
extends Resource
implements Touchable,
FileProvider,
ResourceFactory,
Appendable {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final int NULL_FILE = Resource.getMagicNumber("null file".getBytes());
    private File file;
    private File baseDir;

    public FileResource() {
    }

    public FileResource(File b, String name) {
        this.baseDir = b;
        this.file = FILE_UTILS.resolveFile(b, name);
    }

    public FileResource(File f) {
        this.setFile(f);
    }

    public FileResource(Project p, File f) {
        this(f);
        this.setProject(p);
    }

    public FileResource(Project p, String s) {
        this(p, p.resolveFile(s));
    }

    public void setFile(File f) {
        this.checkAttributesAllowed();
        this.file = f;
        if (!(f == null || this.getBaseDir() != null && FILE_UTILS.isLeadingPath(this.getBaseDir(), f))) {
            this.setBaseDir(f.getParentFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile() {
        if (this.isReference()) {
            return ((FileResource)this.getCheckedRef()).getFile();
        }
        this.dieOnCircularReference();
        FileResource fileResource = this;
        synchronized (fileResource) {
            if (this.file == null) {
                File d = this.getBaseDir();
                String n = super.getName();
                if (n != null) {
                    this.setFile(FILE_UTILS.resolveFile(d, n));
                }
            }
        }
        return this.file;
    }

    public void setBaseDir(File b) {
        this.checkAttributesAllowed();
        this.baseDir = b;
    }

    public File getBaseDir() {
        if (this.isReference()) {
            return ((FileResource)this.getCheckedRef()).getBaseDir();
        }
        this.dieOnCircularReference();
        return this.baseDir;
    }

    public void setRefid(Reference r) {
        if (this.file != null || this.baseDir != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public String getName() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getName();
        }
        File b = this.getBaseDir();
        return b == null ? this.getNotNullFile().getName() : FILE_UTILS.removeLeadingPath(b, this.getNotNullFile());
    }

    public boolean isExists() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).isExists() : this.getNotNullFile().exists();
    }

    public long getLastModified() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).getLastModified() : this.getNotNullFile().lastModified();
    }

    public boolean isDirectory() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).isDirectory() : this.getNotNullFile().isDirectory();
    }

    public long getSize() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).getSize() : this.getNotNullFile().length();
    }

    public InputStream getInputStream() throws IOException {
        return this.isReference() ? ((Resource)this.getCheckedRef()).getInputStream() : new FileInputStream(this.getNotNullFile());
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((FileResource)this.getCheckedRef()).getOutputStream();
        }
        return this.getOutputStream(false);
    }

    public OutputStream getAppendOutputStream() throws IOException {
        if (this.isReference()) {
            return ((FileResource)this.getCheckedRef()).getAppendOutputStream();
        }
        return this.getOutputStream(true);
    }

    private OutputStream getOutputStream(boolean append) throws IOException {
        File f = this.getNotNullFile();
        if (f.exists()) {
            if (f.isFile() && !append) {
                f.delete();
            }
        } else {
            File p = f.getParentFile();
            if (p != null && !p.exists()) {
                p.mkdirs();
            }
        }
        return append ? new FileOutputStream(f.getAbsolutePath(), true) : new FileOutputStream(f);
    }

    public int compareTo(Resource another) {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).compareTo(another);
        }
        if (this.equals(another)) {
            return 0;
        }
        FileProvider otherFP = another.as(FileProvider.class);
        if (otherFP != null) {
            File f = this.getFile();
            if (f == null) {
                return -1;
            }
            File of = otherFP.getFile();
            if (of == null) {
                return 1;
            }
            return f.compareTo(of);
        }
        return super.compareTo(another);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (this.isReference()) {
            return this.getCheckedRef().equals(another);
        }
        if (another == null || !another.getClass().equals(this.getClass())) {
            return false;
        }
        FileResource otherfr = (FileResource)another;
        return this.getFile() == null ? otherfr.getFile() == null : this.getFile().equals(otherfr.getFile());
    }

    public int hashCode() {
        if (this.isReference()) {
            return this.getCheckedRef().hashCode();
        }
        return MAGIC * (this.getFile() == null ? NULL_FILE : this.getFile().hashCode());
    }

    public String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        if (this.file == null) {
            return "(unbound file resource)";
        }
        String absolutePath = this.file.getAbsolutePath();
        return FILE_UTILS.normalize(absolutePath).getAbsolutePath();
    }

    public boolean isFilesystemOnly() {
        if (this.isReference()) {
            return ((FileResource)this.getCheckedRef()).isFilesystemOnly();
        }
        this.dieOnCircularReference();
        return true;
    }

    public void touch(long modTime) {
        if (this.isReference()) {
            ((FileResource)this.getCheckedRef()).touch(modTime);
            return;
        }
        if (!this.getNotNullFile().setLastModified(modTime)) {
            this.log("Failed to change file modification time", 1);
        }
    }

    protected File getNotNullFile() {
        if (this.getFile() == null) {
            throw new BuildException("file attribute is null!");
        }
        this.dieOnCircularReference();
        return this.getFile();
    }

    public Resource getResource(String path) {
        File newfile = FILE_UTILS.resolveFile(this.getFile(), path);
        FileResource fileResource = new FileResource(newfile);
        if (FILE_UTILS.isLeadingPath(this.getBaseDir(), newfile)) {
            fileResource.setBaseDir(this.getBaseDir());
        }
        return fileResource;
    }
}

