/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.net.sf.cglib.transform.impl;

import com.github.dockerjava.shaded.net.sf.cglib.core.Block;
import com.github.dockerjava.shaded.net.sf.cglib.core.CodeEmitter;
import com.github.dockerjava.shaded.net.sf.cglib.core.Constants;
import com.github.dockerjava.shaded.net.sf.cglib.core.EmitUtils;
import com.github.dockerjava.shaded.net.sf.cglib.core.Signature;
import com.github.dockerjava.shaded.net.sf.cglib.core.TypeUtils;
import com.github.dockerjava.shaded.net.sf.cglib.transform.ClassEmitterTransformer;
import com.github.dockerjava.shaded.org.objectweb.asm.Type;
import java.lang.reflect.Constructor;

public class UndeclaredThrowableTransformer
extends ClassEmitterTransformer {
    private Type wrapper;

    public UndeclaredThrowableTransformer(Class wrapper) {
        this.wrapper = Type.getType(wrapper);
        boolean found = false;
        Constructor<?>[] cstructs = wrapper.getConstructors();
        for (int i = 0; i < cstructs.length; ++i) {
            Class<?>[] types = cstructs[i].getParameterTypes();
            if (types.length != 1 || !types[0].equals(Throwable.class)) continue;
            found = true;
            break;
        }
        if (!found) {
            String string = String.valueOf(wrapper);
            throw new IllegalArgumentException(new StringBuilder(62 + String.valueOf(string).length()).append(string).append(" does not have a single-arg constructor that takes a Throwable").toString());
        }
    }

    public CodeEmitter begin_method(int access, Signature sig, final Type[] exceptions) {
        CodeEmitter e = super.begin_method(access, sig, exceptions);
        if (TypeUtils.isAbstract(access) || sig.equals(Constants.SIG_STATIC)) {
            return e;
        }
        return new CodeEmitter(e){
            private Block handler;
            {
                super(wrap);
                this.handler = this.begin_block();
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                this.handler.end();
                EmitUtils.wrap_undeclared_throwable(this, this.handler, exceptions, UndeclaredThrowableTransformer.this.wrapper);
                super.visitMaxs(maxStack, maxLocals);
            }
        };
    }
}

