/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.net.sf.cglib.transform.impl;

import com.github.dockerjava.shaded.net.sf.cglib.core.CodeEmitter;
import com.github.dockerjava.shaded.net.sf.cglib.core.Constants;
import com.github.dockerjava.shaded.net.sf.cglib.core.EmitUtils;
import com.github.dockerjava.shaded.net.sf.cglib.core.MethodInfo;
import com.github.dockerjava.shaded.net.sf.cglib.core.ReflectUtils;
import com.github.dockerjava.shaded.net.sf.cglib.core.TypeUtils;
import com.github.dockerjava.shaded.net.sf.cglib.transform.ClassEmitterTransformer;
import com.github.dockerjava.shaded.org.objectweb.asm.Type;
import java.lang.reflect.Method;

public class AddStaticInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddStaticInitTransformer(Method classInit) {
        this.info = ReflectUtils.getMethodInfo(classInit);
        if (!TypeUtils.isStatic(this.info.getModifiers())) {
            String string = String.valueOf(classInit);
            throw new IllegalArgumentException(new StringBuilder(14 + String.valueOf(string).length()).append(string).append(" is not static").toString());
        }
        Type[] types = this.info.getSignature().getArgumentTypes();
        if (types.length != 1 || !types[0].equals(Constants.TYPE_CLASS) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            String string = String.valueOf(classInit);
            throw new IllegalArgumentException(new StringBuilder(18 + String.valueOf(string).length()).append(string).append(" illegal signature").toString());
        }
    }

    protected void init() {
        if (!TypeUtils.isInterface(this.getAccess())) {
            CodeEmitter e = this.getStaticHook();
            EmitUtils.load_class_this(e);
            e.invoke(this.info);
        }
    }
}

