/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.jcajce.provider.asymmetric.dstu;

import com.github.dockerjava.shaded.org.bouncycastle.asn1.ASN1Object;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ASN1OctetString;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ASN1Primitive;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ASN1Sequence;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.DERBitString;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.DEROctetString;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ua.DSTU4145BinaryField;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ua.DSTU4145ECBinary;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ua.DSTU4145Params;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ua.DSTU4145PointEncoder;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ua.UAObjectIdentifiers;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x9.X962Parameters;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.github.dockerjava.shaded.org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.github.dockerjava.shaded.org.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.github.dockerjava.shaded.org.bouncycastle.jce.interfaces.ECPointEncoder;
import com.github.dockerjava.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.github.dockerjava.shaded.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.github.dockerjava.shaded.org.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.github.dockerjava.shaded.org.bouncycastle.jce.spec.ECParameterSpec;
import com.github.dockerjava.shaded.org.bouncycastle.jce.spec.ECPublicKeySpec;
import com.github.dockerjava.shaded.org.bouncycastle.math.ec.ECCurve;
import com.github.dockerjava.shaded.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class BCDSTU4145PublicKey
implements ECPublicKey,
com.github.dockerjava.shaded.org.bouncycastle.jce.interfaces.ECPublicKey,
ECPointEncoder {
    static final long serialVersionUID = 7026240464295649314L;
    private String algorithm = "DSTU4145";
    private boolean withCompression;
    private transient com.github.dockerjava.shaded.org.bouncycastle.math.ec.ECPoint q;
    private transient java.security.spec.ECParameterSpec ecSpec;
    private transient DSTU4145Params dstuParams;

    public BCDSTU4145PublicKey(BCDSTU4145PublicKey bCDSTU4145PublicKey) {
        this.q = bCDSTU4145PublicKey.q;
        this.ecSpec = bCDSTU4145PublicKey.ecSpec;
        this.withCompression = bCDSTU4145PublicKey.withCompression;
        this.dstuParams = bCDSTU4145PublicKey.dstuParams;
    }

    public BCDSTU4145PublicKey(java.security.spec.ECPublicKeySpec eCPublicKeySpec) {
        this.ecSpec = eCPublicKeySpec.getParams();
        this.q = EC5Util.convertPoint(this.ecSpec, eCPublicKeySpec.getW(), false);
    }

    public BCDSTU4145PublicKey(ECPublicKeySpec eCPublicKeySpec) {
        this.q = eCPublicKeySpec.getQ();
        if (eCPublicKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPublicKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPublicKeySpec.getParams().getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, eCPublicKeySpec.getParams());
        } else {
            if (this.q.getCurve() == null) {
                ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
                this.q = eCParameterSpec.getCurve().createPoint(this.q.getAffineXCoord().toBigInteger(), this.q.getAffineYCoord().toBigInteger());
            }
            this.ecSpec = null;
        }
    }

    public BCDSTU4145PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, java.security.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, eCDomainParameters);
        } else {
            this.ecSpec = eCParameterSpec;
        }
    }

    public BCDSTU4145PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, eCDomainParameters);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, eCParameterSpec);
        }
    }

    public BCDSTU4145PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters) {
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = null;
    }

    private java.security.spec.ECParameterSpec createSpec(EllipticCurve ellipticCurve, ECDomainParameters eCDomainParameters) {
        return new java.security.spec.ECParameterSpec(ellipticCurve, new ECPoint(eCDomainParameters.getG().getAffineXCoord().toBigInteger(), eCDomainParameters.getG().getAffineYCoord().toBigInteger()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
    }

    public BCDSTU4145PublicKey(ECPublicKey eCPublicKey) {
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParams();
        this.q = EC5Util.convertPoint(this.ecSpec, eCPublicKey.getW(), false);
    }

    BCDSTU4145PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    private void reverseBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length / 2; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[byArray.length - 1 - i];
            byArray[byArray.length - 1 - i] = by;
        }
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Object object;
        Object object2;
        ASN1OctetString aSN1OctetString;
        DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
        this.algorithm = "DSTU4145";
        try {
            aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(dERBitString.getBytes());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error recovering public key");
        }
        byte[] byArray = aSN1OctetString.getOctets();
        if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals(UAObjectIdentifiers.dstu4145le)) {
            this.reverseBytes(byArray);
        }
        this.dstuParams = DSTU4145Params.getInstance((ASN1Sequence)subjectPublicKeyInfo.getAlgorithm().getParameters());
        ECParameterSpec eCParameterSpec = null;
        if (this.dstuParams.isNamedCurve()) {
            object2 = this.dstuParams.getNamedCurve();
            object = DSTU4145NamedCurves.getByOID((ASN1ObjectIdentifier)object2);
            eCParameterSpec = new ECNamedCurveParameterSpec(((ASN1ObjectIdentifier)object2).getId(), ((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getG(), ((ECDomainParameters)object).getN(), ((ECDomainParameters)object).getH(), ((ECDomainParameters)object).getSeed());
        } else {
            object2 = this.dstuParams.getECBinary();
            object = ((DSTU4145ECBinary)object2).getB();
            if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals(UAObjectIdentifiers.dstu4145le)) {
                this.reverseBytes((byte[])object);
            }
            DSTU4145BinaryField dSTU4145BinaryField = ((DSTU4145ECBinary)object2).getField();
            ECCurve.F2m f2m = new ECCurve.F2m(dSTU4145BinaryField.getM(), dSTU4145BinaryField.getK1(), dSTU4145BinaryField.getK2(), dSTU4145BinaryField.getK3(), ((DSTU4145ECBinary)object2).getA(), new BigInteger(1, (byte[])object));
            byte[] byArray2 = ((DSTU4145ECBinary)object2).getG();
            if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals(UAObjectIdentifiers.dstu4145le)) {
                this.reverseBytes(byArray2);
            }
            eCParameterSpec = new ECParameterSpec(f2m, DSTU4145PointEncoder.decodePoint(f2m, byArray2), ((DSTU4145ECBinary)object2).getN());
        }
        object2 = eCParameterSpec.getCurve();
        object = EC5Util.convertCurve((ECCurve)object2, eCParameterSpec.getSeed());
        this.q = DSTU4145PointEncoder.decodePoint((ECCurve)object2, byArray);
        this.ecSpec = this.dstuParams.isNamedCurve() ? new ECNamedCurveSpec(this.dstuParams.getNamedCurve().getId(), (EllipticCurve)object, new ECPoint(eCParameterSpec.getG().getAffineXCoord().toBigInteger(), eCParameterSpec.getG().getAffineYCoord().toBigInteger()), eCParameterSpec.getN(), eCParameterSpec.getH()) : new java.security.spec.ECParameterSpec((EllipticCurve)object, new ECPoint(eCParameterSpec.getG().getAffineXCoord().toBigInteger(), eCParameterSpec.getG().getAffineYCoord().toBigInteger()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
    }

    public byte[] getSbox() {
        if (null != this.dstuParams) {
            return this.dstuParams.getDKE();
        }
        return DSTU4145Params.getDefaultDKE();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        Object object;
        ASN1Object aSN1Object;
        if (this.dstuParams != null) {
            aSN1Object = this.dstuParams;
        } else if (this.ecSpec instanceof ECNamedCurveSpec) {
            aSN1Object = new DSTU4145Params(new ASN1ObjectIdentifier(((ECNamedCurveSpec)this.ecSpec).getName()));
        } else {
            object = EC5Util.convertCurve(this.ecSpec.getCurve());
            X9ECParameters x9ECParameters = new X9ECParameters((ECCurve)object, EC5Util.convertPoint((ECCurve)object, this.ecSpec.getGenerator(), this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
            aSN1Object = new X962Parameters(x9ECParameters);
        }
        object = DSTU4145PointEncoder.encodePoint(this.q);
        try {
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, aSN1Object), new DEROctetString((byte[])object));
        }
        catch (IOException iOException) {
            return null;
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo(subjectPublicKeyInfo);
    }

    public java.security.spec.ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(this.ecSpec, this.withCompression);
    }

    public ECPoint getW() {
        return new ECPoint(this.q.getAffineXCoord().toBigInteger(), this.q.getAffineYCoord().toBigInteger());
    }

    public com.github.dockerjava.shaded.org.bouncycastle.math.ec.ECPoint getQ() {
        if (this.ecSpec == null) {
            return this.q.getDetachedPoint();
        }
        return this.q;
    }

    public com.github.dockerjava.shaded.org.bouncycastle.math.ec.ECPoint engineGetQ() {
        return this.q;
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec(this.ecSpec, this.withCompression);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("EC Public Key").append(string);
        stringBuffer.append("            X: ").append(this.q.getAffineXCoord().toBigInteger().toString(16)).append(string);
        stringBuffer.append("            Y: ").append(this.q.getAffineYCoord().toBigInteger().toString(16)).append(string);
        return stringBuffer.toString();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCDSTU4145PublicKey)) {
            return false;
        }
        BCDSTU4145PublicKey bCDSTU4145PublicKey = (BCDSTU4145PublicKey)object;
        return this.engineGetQ().equals(bCDSTU4145PublicKey.engineGetQ()) && this.engineGetSpec().equals(bCDSTU4145PublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.engineGetQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

