/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.dvcs;

import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.DigestInfo;
import com.github.dockerjava.shaded.org.bouncycastle.dvcs.DVCSException;
import com.github.dockerjava.shaded.org.bouncycastle.dvcs.MessageImprint;
import com.github.dockerjava.shaded.org.bouncycastle.operator.DigestCalculator;
import java.io.OutputStream;

public class MessageImprintBuilder {
    private final DigestCalculator digestCalculator;

    public MessageImprintBuilder(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public MessageImprint build(byte[] byArray) throws DVCSException {
        try {
            OutputStream outputStream = this.digestCalculator.getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
            return new MessageImprint(new DigestInfo(this.digestCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
        }
        catch (Exception exception) {
            throw new DVCSException("unable to build MessageImprint: " + exception.getMessage(), exception);
        }
    }
}

