/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.jersey.repackaged.com.google.common.base;

import com.github.dockerjava.shaded.javax.annotation.Nullable;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.base.Objects;
import com.github.dockerjava.shaded.jersey.repackaged.com.google.common.base.Supplier;
import java.io.Serializable;

public final class Suppliers {
    public static <T> Supplier<T> ofInstance(@Nullable T instance) {
        return new SupplierOfInstance<T>(instance);
    }

    private static class SupplierOfInstance<T>
    implements Serializable,
    Supplier<T> {
        final T instance;

        SupplierOfInstance(@Nullable T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof SupplierOfInstance) {
                SupplierOfInstance that = (SupplierOfInstance)obj;
                return Objects.equal(this.instance, that.instance);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.instance));
            return new StringBuilder(22 + string.length()).append("Suppliers.ofInstance(").append(string).append(")").toString();
        }
    }
}

