/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AgentConnector;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.AppOutputWithScreenshot;
import com.applitools.eyes.Eyes;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.EyesWebDriverScreenshot;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.Trigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageDeltaCompressor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebElement;

class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private Eyes eyes;
    private AgentConnector agentConnector;
    private RunningSession runningSession;
    private EyesWebDriver driver;
    private int maxWindowLoadTimeMilliSeconds;
    private MatchResult matchResult;
    private BufferedImage currentScreenshot;

    public MatchWindowTask(Eyes eyes, AgentConnector agentConnector, RunningSession runningSession, EyesWebDriver driver, int maxWindowLoadTime) {
        ArgumentGuard.notNull((Object)((Object)eyes), (String)"eyes");
        ArgumentGuard.notNull((Object)agentConnector, (String)"agentConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.greaterThanOrEqualToZero((int)maxWindowLoadTime, (String)"maxWindowLoadTime");
        this.eyes = eyes;
        this.agentConnector = agentConnector;
        this.runningSession = runningSession;
        this.driver = driver;
        this.maxWindowLoadTimeMilliSeconds = maxWindowLoadTime * 1000;
        this.matchResult = null;
        this.currentScreenshot = null;
    }

    protected MatchResult match(MatchDataCreator matchDataCreator, boolean shouldRunOnceOnTimeout) throws EyesException {
        MatchDataWithScreenshot matchDataWithScreenshot;
        if (0 == this.maxWindowLoadTimeMilliSeconds || shouldRunOnceOnTimeout) {
            if (shouldRunOnceOnTimeout) {
                GeneralUtils.sleep((long)this.maxWindowLoadTimeMilliSeconds);
            }
            matchDataWithScreenshot = matchDataCreator.create(false);
            this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchDataWithScreenshot.getMatchData());
        } else {
            matchDataWithScreenshot = matchDataCreator.create(true);
            long retry = this.maxWindowLoadTimeMilliSeconds;
            long start = System.currentTimeMillis();
            this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchDataWithScreenshot.getMatchData());
            retry -= System.currentTimeMillis() - start;
            while (retry > 0L && !this.matchResult.getAsExpected()) {
                GeneralUtils.sleep((long)500L);
                matchDataWithScreenshot = matchDataCreator.create(true);
                this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchDataWithScreenshot.getMatchData());
                retry -= System.currentTimeMillis() - start;
            }
            if (!this.matchResult.getAsExpected()) {
                matchDataWithScreenshot = matchDataCreator.create(false);
                this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchDataWithScreenshot.getMatchData());
            }
        }
        this.matchResult.setScreenshot(matchDataWithScreenshot.getScreenshot());
        return this.matchResult;
    }

    public MatchResult matchWindow(String tag, boolean shouldForceFullPageScreenshot, Trigger[] userInputs, EyesScreenshot lastScreenshot, boolean shouldRunOnceOnTimeout) {
        MatchWindowDataCreator dataCreator = new MatchWindowDataCreator(this.driver, this.eyes.getTitle(), tag, shouldForceFullPageScreenshot, userInputs, lastScreenshot);
        return this.match(dataCreator, shouldRunOnceOnTimeout);
    }

    public MatchResult matchWindow(String tag, boolean shouldForceFullPageScreenshot, Trigger[] userInputs, EyesScreenshot lastScreenshot) {
        return this.matchWindow(tag, shouldForceFullPageScreenshot, userInputs, lastScreenshot, false);
    }

    public MatchResult matchRegion(Region region, String tag, boolean shouldForceFullPageScreenshot, Trigger[] userInputs, EyesScreenshot lastScreenshot, boolean shouldRunOnceOnTimeout) {
        MatchRegionDataCreator dataCreator = new MatchRegionDataCreator(this.driver, region, this.eyes.getTitle(), tag, shouldForceFullPageScreenshot, userInputs, lastScreenshot);
        return this.match(dataCreator, shouldRunOnceOnTimeout);
    }

    public MatchResult matchRegion(Region region, String tag, boolean shouldForceFullPageScreenshot, Trigger[] userInputs, EyesScreenshot lastScreenshot) {
        return this.matchRegion(region, tag, shouldForceFullPageScreenshot, userInputs, lastScreenshot, false);
    }

    public MatchResult matchElement(WebElement element, String tag, boolean shouldForceFullPageScreenshot, Trigger[] userInputs, EyesScreenshot lastScreenshot, boolean shouldRunOnceOnTimeout) {
        MatchElementDataCreator dataCreator = new MatchElementDataCreator(this.driver, element, this.eyes.getTitle(), tag, shouldForceFullPageScreenshot, userInputs, lastScreenshot);
        return this.match(dataCreator, shouldRunOnceOnTimeout);
    }

    public MatchResult matchElement(WebElement element, String tag, boolean shouldForceFullPageScreenshot, Trigger[] userInputs, EyesScreenshot lastScreenshot) {
        return this.matchElement(element, tag, shouldForceFullPageScreenshot, userInputs, lastScreenshot, false);
    }

    protected static class MatchElementDataCreator
    extends MatchDataCreator {
        private WebElement element;

        public MatchElementDataCreator(EyesWebDriver driver, WebElement element, String title, String tag, boolean shouldForceFullPageScreenshot, Trigger[] userInputs, EyesScreenshot lastScreenshot) {
            super(driver, title, tag, shouldForceFullPageScreenshot, userInputs, lastScreenshot);
            this.element = element;
        }

        public MatchDataWithScreenshot create(boolean ignoreMismatch) {
            EyesWebDriverScreenshot screenshot = this.getScreenshot().getSubScreenshot(this.element);
            MatchWindowData matchData = this.createMatchData(screenshot, ignoreMismatch);
            return new MatchDataWithScreenshot(matchData, screenshot);
        }
    }

    protected static class MatchRegionDataCreator
    extends MatchDataCreator {
        private Region region;

        public MatchRegionDataCreator(EyesWebDriver driver, Region region, String title, String tag, boolean shouldForceFullPageScreenshot, Trigger[] userInputs, EyesScreenshot lastScreenshot) {
            super(driver, title, tag, shouldForceFullPageScreenshot, userInputs, lastScreenshot);
            this.region = region;
        }

        public MatchDataWithScreenshot create(boolean ignoreMismatch) {
            EyesWebDriverScreenshot screenshot = this.getScreenshot().getSubScreenshot(this.region);
            MatchWindowData matchData = this.createMatchData(screenshot, ignoreMismatch);
            return new MatchDataWithScreenshot(matchData, screenshot);
        }
    }

    protected static class MatchWindowDataCreator
    extends MatchDataCreator {
        public MatchWindowDataCreator(EyesWebDriver driver, String title, String tag, boolean shouldForceFullPageScreenshot, Trigger[] userInputs, EyesScreenshot lastScreenshot) {
            super(driver, title, tag, shouldForceFullPageScreenshot, userInputs, lastScreenshot);
        }

        public MatchDataWithScreenshot create(boolean ignoreMismatch) {
            EyesWebDriverScreenshot screenshot = this.getScreenshot();
            MatchWindowData matchData = this.createMatchData(screenshot, ignoreMismatch);
            return new MatchDataWithScreenshot(matchData, screenshot);
        }
    }

    protected static abstract class MatchDataCreator {
        protected final EyesWebDriver driver;
        protected final String title;
        protected final String tag;
        protected final boolean shouldForceFullPageScreenshot;
        protected final Trigger[] userInputs;
        protected final EyesScreenshot lastScreenshot;

        public MatchDataCreator(EyesWebDriver driver, String title, String tag, boolean shouldForceFullPageScreenshot, Trigger[] userInputs, EyesScreenshot lastScreenshot) {
            this.driver = driver;
            this.title = title;
            this.tag = tag;
            this.shouldForceFullPageScreenshot = shouldForceFullPageScreenshot;
            this.userInputs = userInputs;
            this.lastScreenshot = lastScreenshot;
        }

        public abstract MatchDataWithScreenshot create(boolean var1);

        protected EyesWebDriverScreenshot getScreenshot() {
            BufferedImage image;
            if (this.shouldForceFullPageScreenshot) {
                BufferedImage image2 = this.driver.getFullPageScreenshot();
                return new EyesWebDriverScreenshot(this.driver, image2);
            }
            String image64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            byte[] currentScreenshotEncoded = Base64.decodeBase64((byte[])image64.getBytes(Charset.forName("UTF-8")));
            try {
                ByteArrayInputStream screenshotStream = new ByteArrayInputStream(currentScreenshotEncoded);
                image = ImageIO.read(screenshotStream);
                screenshotStream.close();
            }
            catch (IOException e) {
                throw new EyesException("Failed to parse screenshot!", (Throwable)e);
            }
            return new EyesWebDriverScreenshot(this.driver, image);
        }

        protected AppOutputWithScreenshot getAppOutput(EyesScreenshot screenshot) {
            byte[] compressedScreenshot;
            byte[] screenshotImageEncoded;
            BufferedImage screenshotImage = screenshot.getImage();
            ByteArrayOutputStream pngBytesStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)screenshotImage, "png", pngBytesStream);
                pngBytesStream.flush();
                screenshotImageEncoded = pngBytesStream.toByteArray();
                pngBytesStream.close();
            }
            catch (IOException e) {
                throw new EyesException("Failed to encode region", (Throwable)e);
            }
            BufferedImage source = this.lastScreenshot != null ? this.lastScreenshot.getImage() : null;
            try {
                compressedScreenshot = ImageDeltaCompressor.compressByRawBlocks((BufferedImage)screenshotImage, (byte[])screenshotImageEncoded, (BufferedImage)source);
            }
            catch (IOException e) {
                throw new EyesException("Failed to compress screenshot!", (Throwable)e);
            }
            AppOutput appOutput = new AppOutput(this.title, null);
            return new AppOutputWithScreenshot(appOutput, compressedScreenshot);
        }

        protected MatchWindowData createMatchData(EyesScreenshot screenshot, boolean ignoreMismatch) {
            AppOutputWithScreenshot appOutput = this.getAppOutput(screenshot);
            return new MatchWindowData(this.userInputs, appOutput.getAppOutput(), this.tag, ignoreMismatch, appOutput.getScreenshot());
        }
    }

    protected static class MatchDataWithScreenshot {
        private final MatchWindowData matchData;
        private final EyesScreenshot screenshot;

        public MatchDataWithScreenshot(MatchWindowData matchData, EyesScreenshot screenshot) {
            this.matchData = matchData;
            this.screenshot = screenshot;
        }

        public MatchWindowData getMatchData() {
            return this.matchData;
        }

        public EyesScreenshot getScreenshot() {
            return this.screenshot;
        }
    }
}

