/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.RestClient;
import com.applitools.eyes.WebDriverScreenshot;
import com.applitools.utils.ArgumentGuard;
import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

class ScreenshotTaker
extends RestClient {
    public ScreenshotTaker(URI driverServerUri, String driverSessionId) {
        super(driverServerUri);
        ArgumentGuard.notNullOrEmpty((String)driverSessionId, (String)"driverSessionId");
        this.endPoint = this.endPoint.path("/session/" + driverSessionId + "/screenshot");
    }

    public String getScreenshot() {
        Response response = this.endPoint.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        WebDriverScreenshot screenshot = (WebDriverScreenshot)this.parseResponseWithJsonData(response, validStatusCodes, WebDriverScreenshot.class);
        return screenshot.getValue();
    }
}

