/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.video;

import androidx.annotation.Nullable;
import com.appier.ads.common.ArrayUtil;
import com.appier.ads.video.TrackingEventType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TrackingEvents {
    public final Map<TrackingEventType, List<String>> eventTrackerMap = new HashMap<TrackingEventType, List<String>>();
    public final Map<Long, List<String>> progressTrackerMap = new TreeMap<Long, List<String>>();
    @Nullable
    private final ArrayBlockingQueue<Long> progressPositionQueue;

    public TrackingEvents(JSONArray events) throws JSONException {
        int l = events.length();
        block9: for (int i = 0; i < l; ++i) {
            JSONObject event = events.getJSONObject(i);
            String type = event.getString("event");
            String[] uriArray = ArrayUtil.getStringArray(event.optJSONArray("uri"));
            if (uriArray == null) continue;
            switch (type) {
                case "firstQuartile": 
                case "midpoint": 
                case "thirdQuartile": 
                case "progress": {
                    long pos = event.getLong("position");
                    if (pos <= 0L) continue block9;
                    if (this.progressTrackerMap.containsKey(pos)) {
                        this.progressTrackerMap.get(pos).addAll(Arrays.asList(uriArray));
                        continue block9;
                    }
                    this.progressTrackerMap.put(pos, new ArrayList<String>(Arrays.asList(uriArray)));
                    continue block9;
                }
                default: {
                    TrackingEventType eventType = TrackingEventType.getEventType(type);
                    if (eventType == null) continue block9;
                    if (this.eventTrackerMap.containsKey((Object)eventType)) {
                        this.eventTrackerMap.get((Object)eventType).addAll(Arrays.asList(uriArray));
                        continue block9;
                    }
                    this.eventTrackerMap.put(eventType, new ArrayList<String>(Arrays.asList(uriArray)));
                }
            }
        }
        if (this.progressTrackerMap.size() > 0) {
            this.progressPositionQueue = new ArrayBlockingQueue(this.progressTrackerMap.size());
            this.progressPositionQueue.addAll(this.progressTrackerMap.keySet());
        } else {
            this.progressPositionQueue = null;
        }
    }

    @Nullable
    public List<String> getTrackingUrlFromEvent(TrackingEventType eventType) {
        return this.eventTrackerMap.get((Object)eventType);
    }

    @Nullable
    public List<String> popTrackingUrlFromPosition(long position) {
        if (this.progressPositionQueue == null || this.progressPositionQueue.isEmpty() || this.progressPositionQueue.peek() > position) {
            return null;
        }
        ArrayList<String> uriArray = new ArrayList<String>();
        while (!this.progressPositionQueue.isEmpty() && this.progressPositionQueue.peek() <= position) {
            long key = this.progressPositionQueue.poll();
            uriArray.addAll((Collection<String>)this.progressTrackerMap.get(key));
        }
        return uriArray;
    }

    @Nullable
    public ArrayBlockingQueue<Long> getProgressPositionQueue() {
        return this.progressPositionQueue;
    }
}

