/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.video;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appier.ads.Appier;
import com.appier.ads.R;
import com.appier.ads.common.FileUtil;
import com.appier.ads.network.AppierVolley;
import com.appier.ads.video.PlayerOverlayTemplate;
import com.appier.volley.Response;
import com.appier.volley.VolleyError;
import com.appier.volley.toolbox.StringRequest;
import java.io.File;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PlayerOverlay {
    @NonNull
    public final String uri;
    @NonNull
    public final String version;
    @NonNull
    public final ArrayList<Replacement> replacements;

    public PlayerOverlay(JSONObject overlayObj) throws JSONException {
        this.uri = overlayObj.getString("uri");
        this.version = overlayObj.getString("version");
        this.replacements = new ArrayList();
        this.appendReplacements(overlayObj.optJSONArray("replacements"));
    }

    public void appendReplacements(@Nullable JSONArray replacementJsonArray) throws JSONException {
        if (replacementJsonArray == null) {
            return;
        }
        int l = replacementJsonArray.length();
        for (int i = 0; i < l; ++i) {
            JSONObject r = replacementJsonArray.getJSONObject(i);
            this.replacements.add(new Replacement(r.getString("macro"), r.getString("value")));
        }
    }

    public void getOverlayContent(final Context context, final CompletionHandler completionHandler) {
        final String templateFileName = this.uri.replaceAll("[^A-Za-z0-9]", "") + ".html";
        File templateFile = new File(context.getFilesDir(), templateFileName);
        if (templateFile.exists()) {
            String templateString = FileUtil.readFile(context, templateFileName);
            String htmlContent = new PlayerOverlayTemplate(templateString).execute(this.replacements);
            Appier.log("[Appier SDK]", "Success to load overlay from local");
            completionHandler.onComplete(htmlContent);
        } else {
            StringRequest req = new StringRequest(this.uri, (Response.Listener)new Response.Listener<String>(){

                public void onResponse(String response) {
                    if (response == null || response.equals("")) {
                        return;
                    }
                    FileUtil.writeFile(context, templateFileName, response);
                    String htmlContent = new PlayerOverlayTemplate(response).execute(PlayerOverlay.this.replacements);
                    Appier.log("[Appier SDK]", "Success to load overlay from server");
                    completionHandler.onComplete(htmlContent);
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    Appier.log("Download video player overlay html file error: ", error.toString(), "Fall back to default script file.");
                    String templateString = FileUtil.readFileFromResource(context, R.raw.video_overlay_default);
                    String htmlContent = new PlayerOverlayTemplate(templateString).execute(PlayerOverlay.this.replacements);
                    completionHandler.onComplete(htmlContent);
                }
            });
            AppierVolley.getInstance(context).addToRequestQueue(req);
        }
    }

    public static class Replacement {
        @NonNull
        public final String macro;
        @NonNull
        public final String value;

        public Replacement(@NonNull String macro, @NonNull String value) {
            this.macro = macro;
            this.value = value;
        }
    }

    public static interface CompletionHandler {
        public void onComplete(String var1);
    }
}

