/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.network;

import android.content.Context;
import androidx.annotation.Nullable;
import com.appier.ads.Appier;
import com.appier.ads.network.AppierVolley;
import com.appier.volley.DefaultRetryPolicy;
import com.appier.volley.RetryPolicy;
import com.appier.volley.toolbox.StringRequest;
import java.util.List;

public class EventTracker {
    Context context;
    AppierVolley appierVolley;

    public EventTracker(Context context) {
        this.context = context;
        this.appierVolley = AppierVolley.getInstance(context);
    }

    public void trackUri(String uri) {
        StringRequest stringRequest = new StringRequest(0, uri, null, null);
        stringRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy());
        this.appierVolley.addToRequestQueue(stringRequest);
        Appier.log("[Appier SDK]", "[EventTracker]", "Tracking Event: " + uri);
    }

    public void trackUri(@Nullable List<String> uriList) {
        if (uriList == null) {
            return;
        }
        for (String uri : uriList) {
            this.trackUri(uri);
        }
    }

    public void trackUri(String ... uriArray) {
        if (uriArray == null) {
            return;
        }
        for (String uri : uriArray) {
            this.trackUri(uri);
        }
    }
}

