/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.media2.common.MediaItem;
import androidx.media2.common.UriMediaItem;
import androidx.media2.player.MediaPlayer;
import com.appier.ads.Appier;
import com.appier.ads.AppierBaseAd;
import com.appier.ads.AppierError;
import com.appier.ads.AppierPredictCache;
import com.appier.ads.VideoInterstitialActivity;
import com.appier.ads.common.AdUnitIdentifier;
import com.appier.ads.common.AdUrlGenerator;
import com.appier.ads.common.ObjectWrapperForBinder;
import com.appier.ads.video.PlayerOverlay;
import com.appier.ads.video.PlayerOverlayLayout;
import com.appier.ads.video.VastAdConfiguration;
import com.appier.ads.video.VideoActivityArgs;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoAd
extends AppierBaseAd
implements AppierBaseAd.BaseAdEventListener {
    private final EventListener eventListener;
    private VastAdConfiguration vastAdConfiguration;
    private PlayerOverlayLayout playerOverlayLayout;
    private MediaPlayer mediaPlayer;
    private boolean isPlayerOverlayLayoutReady = false;
    private boolean isMediaPlayReady = false;
    private int orientation = 1;

    public VideoAd(Context context, @NonNull AdUnitIdentifier adUnitId, EventListener eventListener) {
        super(context, adUnitId);
        this.setBaseAdEventListener(this);
        this.eventListener = eventListener;
    }

    private JSONObject getAd() throws JSONException {
        return this.getAdJSON().getJSONArray("adUnits").getJSONObject(0).getJSONObject("ad");
    }

    private void loadVastAdConfiguration() throws JSONException {
        this.vastAdConfiguration = new VastAdConfiguration(this.getAd());
    }

    private VastAdConfiguration getVastAdConfiguration() {
        return this.vastAdConfiguration;
    }

    @Override
    public void loadAd() {
        super.loadAd();
        this.orientation = this.getContext().getResources().getConfiguration().orientation;
    }

    public void showAd() {
        if (!this.isLoaded()) {
            Appier.log("[Appier SDK]", "You are trying to show video ad before it is ready");
            return;
        }
        Intent intent = VideoInterstitialActivity.getIntent(this.getContext());
        Bundle bundle = new Bundle();
        VideoActivityArgs args = new VideoActivityArgs(this.getVastAdConfiguration(), this.orientation, this.playerOverlayLayout, this.mediaPlayer, new VastVideoInterstitialActivityListener());
        bundle.putBinder("VIDEO_BUNDLE_BINDER", (IBinder)new ObjectWrapperForBinder(args));
        intent.putExtra("VIDEO_INTENT_EXTRA_BUNDLE", bundle);
        this.getContext().startActivity(intent);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public String getAdUri() {
        String predictId = AppierPredictCache.getInstance().getActivatedPredictId(this.getAdUnitId());
        AdUrlGenerator adUrlGenerator = new AdUrlGenerator(this.getContext(), this.getNetworkHost(), this.getAdPath()).withZoneId(this.getZoneId()).withPredictId(predictId);
        return adUrlGenerator.generateUrlString();
    }

    @Override
    public void onBaseAdLoaded(AppierBaseAd ad, boolean isNoBid) {
        Appier.log("[Appier SDK]", "AppierVastVideoAd.onBaseAdLoaded()", "isNoBid =", isNoBid);
        if (isNoBid) {
            this.eventListener.onAdNoBid(this);
            return;
        }
        try {
            this.loadVastAdConfiguration();
            this.setupMediaPlayer();
            this.setupOverlayLayout();
            this.prepareVideo();
        }
        catch (JSONException e) {
            this.eventListener.onAdLoadFail(AppierError.INVALID_JSON, this);
        }
        catch (Exception e) {
            this.eventListener.onAdLoadFail(AppierError.UNKNOWN_ERROR, this);
        }
    }

    @Override
    public void onBaseAdLoadFail(AppierError appierError) {
        Appier.log("[Appier SDK]", "AppierVastVideoAd.onBaseAdLoadFail():", appierError.toString());
        this.eventListener.onAdLoadFail(appierError, this);
    }

    private void setupMediaPlayer() {
        this.mediaPlayer = new MediaPlayer(this.getContext());
        Uri uri = Uri.parse((String)this.vastAdConfiguration.linearCreative.mediaFile.uri);
        UriMediaItem mediaItem = new UriMediaItem.Builder(uri).build();
        this.mediaPlayer.setMediaItem((MediaItem)mediaItem);
    }

    private void setupOverlayLayout() {
        this.vastAdConfiguration.playerOverlay.getOverlayContent(this.getContext(), new PlayerOverlay.CompletionHandler(){

            @Override
            public void onComplete(String htmlContent) {
                VideoAd.this.playerOverlayLayout = new PlayerOverlayLayout(VideoAd.this.getContext(), htmlContent);
                VideoAd.this.isPlayerOverlayLayoutReady = true;
                VideoAd.this.contentReady();
            }
        });
    }

    private void prepareVideo() {
        this.mediaPlayer.prepare().addListener(new Runnable(){

            @Override
            public void run() {
                VideoAd.this.isMediaPlayReady = true;
                VideoAd.this.contentReady();
            }
        }, ContextCompat.getMainExecutor((Context)this.getContext()));
    }

    private void contentReady() {
        if (this.isPlayerOverlayLayoutReady && this.isMediaPlayReady) {
            this.eventListener.onAdLoaded(this);
        }
    }

    public static interface EventListener {
        public void onAdLoaded(VideoAd var1);

        public void onAdNoBid(VideoAd var1);

        public void onAdLoadFail(AppierError var1, VideoAd var2);

        public void onViewClick(VideoAd var1);

        public void onViewClickFail(AppierError var1, VideoAd var2);

        public void onShown(VideoAd var1);

        public void onAdVideoComplete(VideoAd var1);

        public void onShowFail(AppierError var1, VideoAd var2);

        public void onDismiss(VideoAd var1);
    }

    private class VastVideoInterstitialActivityListener
    implements VideoInterstitialActivity.EventListener {
        private VastVideoInterstitialActivityListener() {
        }

        @Override
        public void onShown() {
            VideoAd.this.eventListener.onShown(VideoAd.this);
        }

        @Override
        public void onShowFail(AppierError appierError) {
            VideoAd.this.eventListener.onShowFail(appierError, VideoAd.this);
        }

        @Override
        public void onClick() {
            VideoAd.this.eventListener.onViewClick(VideoAd.this);
        }

        @Override
        public void onClickFail(AppierError appierError) {
            VideoAd.this.eventListener.onViewClickFail(appierError, VideoAd.this);
        }

        @Override
        public void onVideoComplete() {
            VideoAd.this.eventListener.onAdVideoComplete(VideoAd.this);
        }

        @Override
        public void onDismiss() {
            VideoAd.this.eventListener.onDismiss(VideoAd.this);
        }
    }
}

