/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appier.ads.common.ArrayUtil;
import com.appier.ads.video.PlayerLayout;
import com.appier.ads.video.PlayerOverlay;
import com.appier.ads.video.Reward;
import com.appier.ads.video.TrackingEvents;
import com.appier.ads.video.VastAdMediaFile;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VastAdConfiguration {
    @NonNull
    public final String version;
    @NonNull
    public final String adId;
    @NonNull
    public final String adSystem;
    @Nullable
    public final String[] surveyUri;
    @Nullable
    public final String[] errorUri;
    @Nullable
    public final String[] impressionUri;
    @NonNull
    public final LinearCreative linearCreative;
    @Nullable
    public final CompanionAd endCardCompanionAd;
    @NonNull
    public final PlayerLayout playerLayout;
    @NonNull
    public final PlayerOverlay playerOverlay;
    public final Reward reward;

    public VastAdConfiguration(JSONObject vastObj) throws JSONException {
        this.version = vastObj.getString("version");
        this.adId = vastObj.getString("adId");
        this.adSystem = vastObj.getString("adSystem");
        this.surveyUri = ArrayUtil.getStringArray(vastObj.optJSONArray("survey"));
        this.impressionUri = ArrayUtil.getStringArray(vastObj.optJSONArray("impression"));
        this.errorUri = ArrayUtil.getStringArray(vastObj.optJSONArray("error"));
        JSONObject creative = vastObj.getJSONObject("creative");
        this.linearCreative = new LinearCreative(creative.getJSONObject("linear"));
        this.endCardCompanionAd = creative.has("endCard") ? new CompanionAd(creative.getJSONObject("endCard")) : null;
        JSONObject configJson = vastObj.getJSONObject("config");
        this.playerLayout = new PlayerLayout(configJson.getJSONObject("videoLayout"));
        this.playerOverlay = new PlayerOverlay(configJson.getJSONObject("overlay"));
        this.reward = new Reward(vastObj.optJSONObject("reward"));
        if (creative.has("callToAction")) {
            this.playerOverlay.appendReplacements(creative.getJSONObject("callToAction").optJSONArray("replacements"));
        }
    }

    public class CompanionAd
    extends VastCreative {
        public final int height;
        public final int width;
        public final String htmlResource;
        @NonNull
        public final String altText;
        @NonNull
        public final String clickThroughUri;

        public CompanionAd(JSONObject creativeObj) throws JSONException {
            super(creativeObj);
            this.height = creativeObj.getInt("height");
            this.width = creativeObj.getInt("width");
            this.htmlResource = creativeObj.getJSONObject("htmlResource").getString("creative");
            this.altText = creativeObj.optString("altText");
            this.clickThroughUri = creativeObj.getString("clickThrough");
        }
    }

    public class LinearCreative
    extends VastCreative {
        public final long duration;
        public final long skipPosition;
        @NonNull
        public final String clickThroughUri;
        @Nullable
        public final String[] clickTrackingUri;
        @NonNull
        public final VastAdMediaFile[] mediaFileArray;
        @NonNull
        public VastAdMediaFile mediaFile;

        public LinearCreative(JSONObject creativeObj) throws JSONException {
            super(creativeObj);
            this.duration = creativeObj.getLong("duration");
            this.skipPosition = creativeObj.getLong("skipPosition");
            this.clickThroughUri = creativeObj.getJSONObject("videoClicks").getString("clickThrough");
            this.clickTrackingUri = ArrayUtil.getStringArray(creativeObj.getJSONObject("videoClicks").optJSONArray("clickTracking"));
            JSONArray mediaFileJsonArray = creativeObj.getJSONArray("mediaFiles");
            this.mediaFileArray = new VastAdMediaFile[mediaFileJsonArray.length()];
            int l = mediaFileJsonArray.length();
            for (int i = 0; i < l; ++i) {
                VastAdMediaFile vFile;
                this.mediaFileArray[i] = vFile = new VastAdMediaFile(mediaFileJsonArray.getJSONObject(i));
                this.mediaFile = vFile;
            }
        }
    }

    public abstract class VastCreative {
        @NonNull
        public final TrackingEvents trackingEvents;

        public VastCreative(JSONObject creativeObj) throws JSONException {
            this.trackingEvents = new TrackingEvents(creativeObj.getJSONArray("trackingEvents"));
        }
    }
}

