/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.appier.ads.AppierAdPlacer;
import com.appier.ads.AppierBannerAd;
import com.appier.ads.AppierBannerWebView;
import com.appier.ads.AppierNativeAd;

public class AppierRecyclerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private RecyclerView.Adapter mOriginalAdapter;
    private AppierAdPlacer mAppierAdPlacer;

    public AppierRecyclerAdapter(RecyclerView.Adapter originalAdapter) {
        this.mOriginalAdapter = originalAdapter;
        this.mAppierAdPlacer = new AppierAdPlacer(this.mOriginalAdapter.getItemCount());
    }

    public void destroy() {
        if (this.mAppierAdPlacer != null) {
            this.mAppierAdPlacer.destroy();
        }
    }

    public void insertAd(int originalPosition, Object ad) {
        int insertedPosition = this.mAppierAdPlacer.insertAdAtOriginalPosition(originalPosition, ad);
        this.notifyItemRangeInserted(insertedPosition, 1);
    }

    public int getItemViewType(int position) {
        return this.mAppierAdPlacer.getItemViewType(position);
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.mAppierAdPlacer.isAdViewType(viewType)) {
            RelativeLayout view = new RelativeLayout(parent.getContext());
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            return new AppierAdViewHolder(view);
        }
        return this.mOriginalAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        int itemViewType = this.mAppierAdPlacer.getItemViewType(position);
        if (itemViewType == 1) {
            AppierNativeAd appierNativeAd = (AppierNativeAd)this.mAppierAdPlacer.getAd(position);
            ((AppierAdViewHolder)holder).setAdView(appierNativeAd.getAdView());
        } else if (itemViewType == 2) {
            AppierBannerAd appierBannerAd = (AppierBannerAd)this.mAppierAdPlacer.getAd(position);
            AppierBannerWebView appierBannerWebView = appierBannerAd.getView();
            if (appierBannerWebView.getParent() != null) {
                ((ViewGroup)appierBannerWebView.getParent()).removeView((View)appierBannerWebView);
            }
            appierBannerWebView.setCenterInParent();
            ((AppierAdViewHolder)holder).setAdView((View)appierBannerWebView);
        } else {
            int originalPosition = this.mAppierAdPlacer.getOriginalPosition(position);
            this.mOriginalAdapter.onBindViewHolder(holder, originalPosition);
        }
    }

    public int getItemCount() {
        return this.mAppierAdPlacer.getItemCount();
    }

    public class AppierAdViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout mItemView;

        AppierAdViewHolder(RelativeLayout itemView) {
            super((View)itemView);
            this.mItemView = itemView;
        }

        public void setAdView(View adView) {
            if (this.mItemView != null) {
                this.mItemView.addView(adView);
            }
        }
    }
}

