/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import com.appier.ads.common.BaseWebView;

public class AppierInterstitialWebView
extends BaseWebView {
    EventListener mEventListener;

    public AppierInterstitialWebView(Context context, EventListener eventListener) {
        super(context);
        this.mEventListener = eventListener;
        this.setOnTouchListener(new WebViewListener());
    }

    public EventListener getEventListener() {
        return this.mEventListener;
    }

    public void loadHtml(final String html) {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                AppierInterstitialWebView.this.loadDataWithBaseURL("about:blank", html, "text/html", "utf-8", null);
            }
        });
    }

    public void loadCreative(String creative) {
        String html = "<html><head></head><body style=\"margin:0;padding:0\">" + creative + "</body></html>";
        this.loadHtml(html);
    }

    public static interface EventListener {
        public void onClick();

        public void onDismiss();
    }

    private class WebViewListener
    implements View.OnTouchListener {
        private static final long MAX_TOUCH_DURATION = 500L;
        private long mDownTime;

        private WebViewListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    this.mDownTime = event.getEventTime();
                    break;
                }
                case 1: {
                    if (event.getEventTime() - this.mDownTime > 500L) break;
                    AppierInterstitialWebView.this.mEventListener.onClick();
                    break;
                }
            }
            return false;
        }
    }
}

