/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;
import com.appier.ads.Appier;
import com.appier.ads.common.BitmapCache;
import com.appier.ads.network.AppierVolley;
import com.appier.volley.Response;
import com.appier.volley.VolleyError;
import com.appier.volley.toolbox.ImageRequest;
import java.util.List;

public class ImageLoader {
    private int mFinishedCount;
    private AppierVolley mAppierVolley;
    private static BitmapCache mCache;

    public ImageLoader(Context context) {
        this.mAppierVolley = AppierVolley.getInstance(context);
        mCache = Appier.getBitmapCache();
    }

    private void resetBatchCounter() {
        this.mFinishedCount = 0;
    }

    private void increaseBatchCounter() {
        ++this.mFinishedCount;
    }

    public void batchLoadImages(List<String> urls, final OnBatchImageEventListener eventListener) {
        final int batchCount = urls.size();
        this.resetBatchCounter();
        for (final String url : urls) {
            Bitmap cachedBitmap = mCache.getBitmap(url);
            if (cachedBitmap == null) {
                ImageRequest request = new ImageRequest(url, (Response.Listener)new Response.Listener<Bitmap>(){

                    public void onResponse(Bitmap response) {
                        mCache.putBitmap(url, response);
                        ImageLoader.this.increaseBatchCounter();
                        if (ImageLoader.this.mFinishedCount == batchCount) {
                            ImageLoader.this.resetBatchCounter();
                            eventListener.onBatchImageLoadedAndCached();
                        }
                    }
                }, 0, 0, ImageView.ScaleType.CENTER, Bitmap.Config.RGB_565, new Response.ErrorListener(){

                    public void onErrorResponse(VolleyError error) {
                        eventListener.onBatchImageLoadFail();
                    }
                });
                this.mAppierVolley.addToRequestQueue(request);
                continue;
            }
            mCache.putBitmap(url, cachedBitmap);
            this.increaseBatchCounter();
            if (this.mFinishedCount != batchCount) continue;
            this.resetBatchCounter();
            eventListener.onBatchImageLoadedAndCached();
        }
    }

    public void loadImage(final String url, final OnImageEventListener eventListener) {
        Bitmap cachedBitmap = mCache.getBitmap(url);
        if (cachedBitmap == null) {
            ImageRequest request = new ImageRequest(url, (Response.Listener)new Response.Listener<Bitmap>(){

                public void onResponse(Bitmap response) {
                    mCache.putBitmap(url, response);
                    eventListener.onImageLoadedAndCached(response);
                }
            }, 0, 0, ImageView.ScaleType.CENTER, Bitmap.Config.RGB_565, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    eventListener.onImageLoadFail();
                }
            });
            this.mAppierVolley.addToRequestQueue(request);
        } else {
            mCache.putBitmap(url, cachedBitmap);
            eventListener.onImageLoadedAndCached(cachedBitmap);
        }
    }

    public void loadImageView(final ImageView imageView, final String url) {
        this.loadImage(url, new OnImageEventListener(){

            @Override
            public void onImageLoadedAndCached(Bitmap image) {
                imageView.setImageBitmap(image);
            }

            @Override
            public void onImageLoadFail() {
                Appier.log("[Appier SDK]", "Fail to load and cache image:", url);
            }
        });
    }

    public static interface OnBatchImageEventListener {
        public void onBatchImageLoadedAndCached();

        public void onBatchImageLoadFail();
    }

    public static interface OnImageEventListener {
        public void onImageLoadedAndCached(Bitmap var1);

        public void onImageLoadFail();
    }
}

