/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.content.Context;
import android.telephony.TelephonyManager;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.IOException;

public class Identifier {
    private Context mContext;
    private TelephonyManager mTelManager;
    private AdvertisingIdClient.Info mAdInfo = null;

    public Identifier(Context context) {
        this.mContext = context;
        try {
            this.mTelManager = (TelephonyManager)this.mContext.getSystemService("phone");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getAdInfo(final EventListener eventListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Identifier.this.mAdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)Identifier.this.mContext);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (GooglePlayServicesRepairableException e) {
                    e.printStackTrace();
                }
                catch (GooglePlayServicesNotAvailableException e) {
                    e.printStackTrace();
                }
                eventListener.onAdInfoFetched(Identifier.this.mAdInfo);
            }
        }).start();
    }

    public AdvertisingIdClient.Info getCachedAdInfo() {
        return this.mAdInfo;
    }

    public void setCachedAdInfo(AdvertisingIdClient.Info adInfo) {
        this.mAdInfo = adInfo;
    }

    public String getTelCountry() {
        if (this.mTelManager != null) {
            return this.mTelManager.getNetworkCountryIso();
        }
        return "";
    }

    public String getTelNetworkOperator() {
        if (this.mTelManager != null) {
            return this.mTelManager.getNetworkOperator();
        }
        return "";
    }

    public String getTelNetworkOperatorName() {
        if (this.mTelManager != null) {
            return this.mTelManager.getNetworkOperatorName();
        }
        return "";
    }

    public static interface EventListener {
        public void onAdInfoFetched(AdvertisingIdClient.Info var1);
    }
}

