/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import com.appier.ads.Appier;
import com.appier.ads.AppierError;
import com.appier.ads.AppierPredictor;
import com.appier.ads.common.ImageLoader;
import java.util.List;

public class AppierPredictHandler
implements AppierPredictor.EventListener {
    private Context mContext;

    public AppierPredictHandler(Context context) {
        this.mContext = context;
    }

    @Override
    public void onPredictSuccess(final String adUnitId, List<String> prefetchList) {
        Appier.log("[Appier SDK]", "[Predict Mode]", "successfully predict ad:", adUnitId);
        new ImageLoader(this.mContext).batchLoadImages(prefetchList, new ImageLoader.OnBatchImageEventListener(){

            @Override
            public void onBatchImageLoadedAndCached() {
                Appier.log("[Appier SDK]", "[Predict Mode]", "successfully cache images for ad:", adUnitId);
            }

            @Override
            public void onBatchImageLoadFail() {
                Appier.log("[Appier SDK]", "[Predict Mode]", "failed to cache images for ad:", adUnitId);
            }
        });
    }

    @Override
    public void onPredictFailed(String adUnitId, AppierError error) {
        Appier.log(new Object[]{"[Appier SDK]", "[Predict Mode]", "predict ad", adUnitId, " failed:", error});
    }
}

