/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appier.ads.Appier;
import com.appier.ads.AppierError;
import com.appier.ads.common.AdUnitIdentifier;
import com.appier.ads.common.AppierTargeting;
import com.appier.ads.common.Identifier;
import com.appier.ads.network.AppierVolley;
import com.appier.volley.NetworkResponse;
import com.appier.volley.Response;
import com.appier.volley.VolleyError;
import com.appier.volley.toolbox.StringRequest;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AppierBaseAd {
    private Context mContext;
    private BaseAdEventListener mBaseAdEventListener;
    private AppierVolley mAppierVolley;
    private JSONObject mAdJSON;
    private int mResCode = -1;
    private boolean mIsLoaded;
    private String mNetworkHost = "https://ad3.apx.appier.net";
    private String mAdPath = "/v1/sdk/ad";
    private AdUnitIdentifier mAdUnitId;
    @Nullable
    private String mZoneId;
    @Nullable
    private AppierTargeting mTargetingParams;
    @Nullable
    private Map<String, Object> mLocalExtras;

    public AppierBaseAd(Context context, @NonNull AdUnitIdentifier adUnitId) {
        this.mContext = context;
        this.mAdUnitId = adUnitId;
        this.mAppierVolley = AppierVolley.getInstance(context.getApplicationContext());
        this.mIsLoaded = false;
        this.mTargetingParams = new AppierTargeting();
    }

    public void destroy() {
        this.mContext = null;
        this.mAppierVolley = null;
        this.mTargetingParams = null;
    }

    public void setBaseAdEventListener(BaseAdEventListener eventListener) {
        this.mBaseAdEventListener = eventListener;
    }

    public Context getContext() {
        return this.mContext;
    }

    public AppierVolley getAppierVolley() {
        return this.mAppierVolley;
    }

    public JSONObject getAdJSON() {
        return this.mAdJSON;
    }

    public boolean isLoaded() {
        return this.mIsLoaded;
    }

    public void setIsLoaded(boolean isLoaded) {
        this.mIsLoaded = isLoaded;
    }

    public String getNetworkHost() {
        return this.mNetworkHost;
    }

    public void setNetworkHost(String networkHost) {
        this.mNetworkHost = networkHost;
    }

    public String getAdPath() {
        return this.mAdPath;
    }

    public void setAdPath(String adPath) {
        this.mAdPath = adPath;
    }

    public AdUnitIdentifier getAdUnitId() {
        return this.mAdUnitId;
    }

    public String getZoneId() {
        return this.mZoneId;
    }

    public void setZoneId(String zoneId) {
        this.mZoneId = zoneId;
    }

    public Map<String, Object> getLocalExtras() {
        return this.mLocalExtras;
    }

    public void setLocalExtras(Map<String, Object> localExtras) {
        this.mLocalExtras = localExtras;
    }

    public void setYob(int yob) {
        if (this.mTargetingParams != null) {
            this.mTargetingParams.setYob(yob);
        }
    }

    public void setGender(AppierTargeting.Gender gender) {
        if (this.mTargetingParams != null) {
            this.mTargetingParams.setGender(gender);
        }
    }

    public void addKeyword(String key, String value) {
        if (this.mTargetingParams != null) {
            this.mTargetingParams.addKeyword(key, value);
        }
    }

    public void loadAd(String zoneId) {
        this.setIsLoaded(false);
        this.setZoneId(zoneId);
        this.loadAd();
    }

    public void loadAd() {
        this.setIsLoaded(false);
        if (this.getZoneId() == null) {
            Appier.log("[Appier SDK]", "ZoneId is required");
            this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.ZONE_ID_ERROR);
            return;
        }
        final Identifier identifier = Appier.getIdentifier(this.mContext);
        AdvertisingIdClient.Info adInfo = identifier.getCachedAdInfo();
        if (adInfo != null) {
            this.internalLoadAd();
        } else {
            identifier.getAdInfo(new Identifier.EventListener(){

                @Override
                public void onAdInfoFetched(AdvertisingIdClient.Info adInfo) {
                    identifier.setCachedAdInfo(adInfo);
                    AppierBaseAd.this.internalLoadAd();
                }
            });
        }
    }

    private void internalLoadAd() {
        String adUri = this.getAdUri();
        Appier.log("[Appier SDK]", "Requesting Ad:", adUri);
        StringRequest req = new StringRequest(1, adUri, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                if (AppierBaseAd.this.mResCode == 200) {
                    AppierBaseAd.this.setIsLoaded(true);
                    try {
                        AppierBaseAd.this.mAdJSON = new JSONObject(response);
                        AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoaded(AppierBaseAd.this, false);
                    }
                    catch (JSONException e) {
                        AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.INVALID_JSON);
                    }
                } else if (AppierBaseAd.this.mResCode == 204) {
                    AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoaded(AppierBaseAd.this, true);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (error.networkResponse != null) {
                    AppierBaseAd.this.mResCode = error.networkResponse.statusCode;
                }
                if (AppierBaseAd.this.mResCode == -1) {
                    AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.UNKNOWN_ERROR);
                    return;
                }
                if (400 <= AppierBaseAd.this.mResCode && AppierBaseAd.this.mResCode <= 499) {
                    AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.BAD_REQUEST);
                } else if (500 <= AppierBaseAd.this.mResCode && AppierBaseAd.this.mResCode <= 599) {
                    AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.INTERNAL_SERVER_ERROR);
                } else {
                    AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.NETWORK_ERROR);
                }
            }
        }){

            protected Response<String> parseNetworkResponse(NetworkResponse response) {
                AppierBaseAd.this.mResCode = response.statusCode;
                return super.parseNetworkResponse(response);
            }

            protected Map<String, String> getParams() {
                if (AppierBaseAd.this.mTargetingParams != null) {
                    return AppierBaseAd.this.mTargetingParams.getTargetingParams();
                }
                return null;
            }
        };
        this.mAppierVolley.addToRequestQueue(req);
    }

    public abstract String getAdUri();

    public static interface BaseAdEventListener {
        public void onBaseAdLoaded(AppierBaseAd var1, boolean var2);

        public void onBaseAdLoadFail(AppierError var1);
    }
}

