/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import com.appier.ads.common.BitmapCache;
import com.appier.ads.common.ConsentStatus;
import com.appier.ads.common.Identifier;
import com.appier.ads.common.Logger;

public class Appier {
    private static Logger mLogger = new Logger("Appier");
    private static BitmapCache mBitmapCache = new BitmapCache();
    private static Identifier mIdentifier;
    private static boolean mGDPRApplies;
    private static boolean mForceGDPRApplies;
    private static ConsentStatus mConsentStatus;
    private static boolean mCoppaApplies;
    private static TestMode mTestMode;

    private Appier() {
    }

    public static String getVersionName() {
        return "1.1.2";
    }

    public static BitmapCache getBitmapCache() {
        return mBitmapCache;
    }

    public static Identifier getIdentifier(Context context) {
        if (mIdentifier == null) {
            mIdentifier = new Identifier(context);
        }
        return mIdentifier;
    }

    public static TestMode getTestMode() {
        return mTestMode;
    }

    public static void setTestMode(boolean testMode) {
        mTestMode = testMode ? TestMode.BID : TestMode.FALSE;
    }

    public static void setTestMode(TestMode testMode) {
        mTestMode = testMode;
    }

    public static boolean getGDPRApplies() {
        return mGDPRApplies;
    }

    public static void setGDPRApplies(boolean gdprApplies) {
        mGDPRApplies = gdprApplies;
        Appier.setForceGDPRApplies(false);
        Appier.setConsentStatus(gdprApplies ? ConsentStatus.EXPLICIT_YES : ConsentStatus.EXPLICIT_NO);
    }

    public static boolean getForceGDPRApplies() {
        return mForceGDPRApplies;
    }

    public static void setForceGDPRApplies(boolean forceGDPRApplies) {
        mForceGDPRApplies = forceGDPRApplies;
        Appier.setConsentStatus(forceGDPRApplies ? ConsentStatus.EXPLICIT_YES : ConsentStatus.EXPLICIT_NO);
    }

    public static ConsentStatus getConsentStatus() {
        return mConsentStatus;
    }

    public static void setConsentStatus(ConsentStatus consentStatus) {
        mConsentStatus = consentStatus;
    }

    public static boolean getCoppaApplies() {
        return mCoppaApplies;
    }

    public static void setCoppaApplies(boolean coppaApplies) {
        mCoppaApplies = coppaApplies;
    }

    public static void log(Object ... messages) {
        mLogger.log(messages);
    }

    static {
        mGDPRApplies = false;
        mForceGDPRApplies = false;
        mConsentStatus = ConsentStatus.UNKNOWN;
        mCoppaApplies = false;
        mTestMode = TestMode.FALSE;
    }

    public static enum TestMode {
        FALSE(0),
        BID(1),
        NO_BID(2);

        private int value;

        private TestMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

