/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import java.util.Map;
import java.util.WeakHashMap;

public class AppierTargeting {
    private static final String KEY_YOB = "yob";
    private static final String KEY_GENDER = "gender";
    private int mYob;
    private Gender mGender;
    private WeakHashMap<String, String> mKeywords = new WeakHashMap();

    public void setYob(int yob) {
        this.mYob = yob;
    }

    public void setGender(Gender gender) {
        this.mGender = gender;
    }

    public void addKeyword(String key, String value) {
        this.mKeywords.put(key, value);
    }

    public Map<String, String> getTargetingParams() {
        WeakHashMap<String, String> targetingParams = new WeakHashMap<String, String>();
        if (this.mYob != 0) {
            targetingParams.put(KEY_YOB, Integer.toString(this.mYob));
        }
        if (this.mGender != null) {
            targetingParams.put(KEY_GENDER, Integer.toString(this.mGender.getValue()));
        }
        if (!this.mKeywords.isEmpty()) {
            targetingParams.putAll(this.mKeywords);
        }
        return targetingParams;
    }

    public static enum Gender {
        UNKNOWN(0),
        FEMALE(1),
        MALE(2),
        OTHER(3);

        private int value;

        private Gender(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

