/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.webkit.URLUtil;
import com.appier.ads.common.AppierBrowserActivity;
import java.net.URISyntaxException;

public class BrowserUtil {
    private Context mContext;
    private boolean isInternalBrowserEnabled = true;
    private boolean isExternalBrowserEnabled = true;

    public BrowserUtil(Context context) {
        this.mContext = context;
    }

    public void enableInternalBrowser() {
        this.isInternalBrowserEnabled = true;
    }

    public void enableExternalBrowser() {
        this.isExternalBrowserEnabled = true;
    }

    public void disableInternalBrowser() {
        this.isInternalBrowserEnabled = false;
    }

    public void disableExternalBrowser() {
        this.isExternalBrowserEnabled = false;
    }

    public static boolean isWebPage(String url) {
        return url != null && (URLUtil.isHttpsUrl((String)url) || URLUtil.isHttpUrl((String)url));
    }

    public static boolean isValidGooglePlayWebPage(String url) {
        Uri uri = Uri.parse((String)url);
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        return host.equals("play.google.com") && uri.getQueryParameter("id") != null;
    }

    public boolean tryToOpenUrl(String url) {
        if (this.isInternalBrowserEnabled) {
            this.openUrlWithInAppBrowser(url);
            return true;
        }
        if (this.isExternalBrowserEnabled) {
            return this.tryToOpenUrlWithExternalApp(url);
        }
        return false;
    }

    public void openUrlWithInAppBrowser(String url) {
        this.openUrlWithInAppBrowser(this.mContext, url);
    }

    public void openUrlWithInAppBrowser(Context context, String url) {
        Intent intent = new Intent(context, AppierBrowserActivity.class);
        intent.putExtra(AppierBrowserActivity.EXTRA_URL, url);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public boolean tryToOpenUrlWithExternalApp(String url) {
        return this.tryToOpenUrlWithExternalApp(this.mContext, url);
    }

    public boolean tryToOpenUrlWithExternalApp(Context context, String url) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        try {
            ResolveInfo info;
            intent = Intent.parseUri((String)url, (int)1);
            if (intent != null && (info = packageManager.resolveActivity(intent, 65536)) != null) {
                context.startActivity(intent);
                return true;
            }
        }
        catch (URISyntaxException info) {
            // empty catch block
        }
        Uri link = Uri.parse((String)url);
        intent = new Intent("android.intent.action.VIEW");
        intent.setData(link);
        intent.setFlags(0x10000000);
        if (intent.resolveActivity(packageManager) != null) {
            context.startActivity(intent);
            return true;
        }
        return false;
    }
}

