/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.content.Context;
import android.net.Uri;
import com.appier.ads.Appier;
import com.appier.ads.common.ConsentStatus;
import com.appier.ads.common.Identifier;
import com.appier.ads.network.Network;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.Date;
import java.util.Locale;

public class AppierUrlGenerator {
    public Uri.Builder mUriBuilder;
    private static final String KEY_CACHE_BUSTER = "cb";
    private static final String KEY_BUNDLE = "bundle";
    private static final String KEY_IDFA = "ia";
    private static final String KEY_IDFA_TYPE = "type";
    private static final String KEY_LIMIT_AD_TRACKING = "lat";
    private static final String KEY_LOCALE = "locale";
    private static final String KEY_SDK_VERSION = "sdk_version";
    private static final String KEY_TEST_MODE = "test_mode";
    private static final String KEY_CONNECTION_TYPE = "conntype";
    private static final String KEY_COUNTRY = "country";
    private static final String KEY_OPERATOR_ID = "operator";
    private static final String KEY_OPERATOR_NAME = "operator_name";
    private static final String KEY_GDPR_APPLIES = "gdpr_applies";
    private static final String KEY_FORCE_GDPR_APPLIES = "force_gdpr_applies";
    private static final String KEY_CONSENT_STATUS = "current_consent_status";
    private static final String KEY_COPPA_STATUS = "coppa_applies";

    public AppierUrlGenerator(Context context, String host, String path) {
        this.mUriBuilder = Uri.parse((String)(host + path)).buildUpon();
        Identifier identifier = Appier.getIdentifier(context);
        AdvertisingIdClient.Info adInfo = identifier.getCachedAdInfo();
        boolean isLATEnabled = adInfo == null || adInfo.isLimitAdTrackingEnabled();
        this.mUriBuilder.appendQueryParameter(KEY_CACHE_BUSTER, Long.toString(new Date().getTime()));
        this.mUriBuilder.appendQueryParameter(KEY_SDK_VERSION, "1.1.0");
        this.mUriBuilder.appendQueryParameter(KEY_LOCALE, Locale.getDefault().toString());
        this.mUriBuilder.appendQueryParameter(KEY_IDFA_TYPE, "adid");
        this.mUriBuilder.appendQueryParameter(KEY_BUNDLE, context.getPackageName());
        this.mUriBuilder.appendQueryParameter(KEY_LIMIT_AD_TRACKING, isLATEnabled ? "1" : "0");
        this.mUriBuilder.appendQueryParameter(KEY_CONNECTION_TYPE, Network.getType(context).toString());
        this.mUriBuilder.appendQueryParameter(KEY_COUNTRY, identifier.getTelCountry());
        this.mUriBuilder.appendQueryParameter(KEY_OPERATOR_ID, identifier.getTelNetworkOperator());
        this.mUriBuilder.appendQueryParameter(KEY_OPERATOR_NAME, identifier.getTelNetworkOperatorName());
        this.mUriBuilder.appendQueryParameter(KEY_GDPR_APPLIES, Appier.getGDPRApplies() ? "1" : "0");
        this.mUriBuilder.appendQueryParameter(KEY_FORCE_GDPR_APPLIES, Appier.getForceGDPRApplies() ? "1" : "0");
        this.mUriBuilder.appendQueryParameter(KEY_CONSENT_STATUS, Appier.getConsentStatus().getValue());
        this.mUriBuilder.appendQueryParameter(KEY_COPPA_STATUS, Appier.getCoppaApplies() ? "1" : "0");
        this.setPersonalData(adInfo, isLATEnabled);
        if (Appier.getTestMode() != Appier.TestMode.FALSE) {
            this.mUriBuilder.appendQueryParameter(KEY_TEST_MODE, Integer.toString(Appier.getTestMode().getValue()));
        }
    }

    private void setPersonalData(AdvertisingIdClient.Info adInfo, boolean isLATEnabled) {
        boolean canCollectPersonalData = Appier.getConsentStatus() == ConsentStatus.UNKNOWN ? !isLATEnabled : Appier.getGDPRApplies();
        if (canCollectPersonalData) {
            this.mUriBuilder.appendQueryParameter(KEY_IDFA, adInfo.getId());
        } else {
            this.mUriBuilder.appendQueryParameter(KEY_IDFA, "");
        }
    }

    public String generateUrlString() {
        return this.mUriBuilder.build().toString();
    }
}

