/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.util.Log;

public class Logger {
    private String mLogTag;
    private Level mLogLevel;
    private String mLogDelimiter;

    public Logger(String logTag) {
        this(logTag, Level.DEBUG);
    }

    public Logger(String logTag, Level logLevel) {
        this(logTag, logLevel, " ");
    }

    public Logger(String logTag, Level logLevel, String logDelimiter) {
        this.mLogTag = logTag;
        this.mLogLevel = logLevel;
        this.mLogDelimiter = logDelimiter;
    }

    private void internalLog(String message) {
        switch (this.mLogLevel) {
            case VERBOSE: {
                Log.v((String)this.mLogTag, (String)message);
                break;
            }
            case DEBUG: {
                Log.d((String)this.mLogTag, (String)message);
                break;
            }
            case INFO: {
                Log.i((String)this.mLogTag, (String)message);
                break;
            }
            case WARN: {
                Log.w((String)this.mLogTag, (String)message);
                break;
            }
            case ERROR: {
                Log.e((String)this.mLogTag, (String)message);
            }
        }
    }

    public void log(Object ... messages) {
        if (messages.length == 1) {
            this.internalLog(messages[0].toString());
        } else {
            String joinedMessage = "";
            for (Object message : messages) {
                joinedMessage = joinedMessage + this.mLogDelimiter + message;
            }
            this.internalLog(joinedMessage);
        }
    }

    public static enum Level {
        VERBOSE(0),
        DEBUG(1),
        INFO(2),
        WARN(3),
        ERROR(4);

        private int mLevel;

        private Level(int level) {
            this.mLevel = level;
        }
    }
}

