/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.webkit.URLUtil;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.appier.ads.AppierError;
import com.appier.ads.common.BaseWebView;

public class HtmlWebViewClient
extends WebViewClient {
    private EventListener mEventListener;
    private BaseWebView mBaseWebView;
    private boolean isLoadingFinished = true;
    private boolean isRedirecting = false;

    public HtmlWebViewClient(EventListener eventListener, BaseWebView baseWebView) {
        this.mEventListener = eventListener;
        this.mBaseWebView = baseWebView;
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.isLoadingFinished = false;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        super.shouldOverrideUrlLoading(view, url);
        if (!this.isLoadingFinished) {
            this.isRedirecting = true;
        }
        this.isLoadingFinished = false;
        if (url != null && (URLUtil.isHttpsUrl((String)url) || URLUtil.isHttpUrl((String)url))) {
            boolean isOpened = this.tryToOpenWebPageWithExternalApp(view.getContext(), url);
            if (!isOpened) {
                this.mEventListener.onFailed(AppierError.NO_AVAILABLE_ACTIVITY_FOR_INTENT, url);
            }
            return true;
        }
        return false;
    }

    public boolean tryToOpenWebPageWithExternalApp(Context context, String url) {
        Uri webPage = Uri.parse((String)url);
        Intent intent = new Intent("android.intent.action.VIEW", webPage);
        intent.setFlags(0x10000000);
        if (intent.resolveActivity(context.getPackageManager()) != null) {
            context.startActivity(intent);
            return true;
        }
        return false;
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!this.isRedirecting) {
            this.isLoadingFinished = true;
            this.mEventListener.onLoaded(this.mBaseWebView);
        } else {
            this.isRedirecting = false;
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        this.mEventListener.onFailed(AppierError.WEBVIEW_ERROR, failingUrl);
    }

    public static interface EventListener {
        public void onLoaded(BaseWebView var1);

        public void onFailed(AppierError var1, String var2);
    }
}

