/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import com.appier.ads.Appier;
import com.appier.ads.common.UrlGenerator;
import java.util.Locale;

public class AdUrlGenerator
extends UrlGenerator<AdUrlGenerator> {
    private static final String KEY_AD_UNIT_ID = "zoneid";
    private static final String KEY_BUNDLE = "bundle";
    private static final String KEY_IDFA = "ia";
    private static final String KEY_IDFA_TYPE = "type";
    private static final String KEY_LIMIT_AD_TRACKING = "lat";
    private static final String KEY_LOCALE = "locale";
    private static final String KEY_SDK_VERSION = "sdk_version";
    private static final String KEY_CONNECTION_TYPE = "conntype";
    private static final String KEY_COUNTRY = "country";
    private static final String KEY_OPERATOR_ID = "operator";
    private static final String KEY_OPERATOR_NAME = "operator_name";
    private static final String KEY_AD_UNIT_WIDTH = "w";
    private static final String KEY_AD_UNIT_HEIGHT = "h";
    private static final String KEY_GDPR_APPLIES = "gdpr_applies";
    private static final String KEY_FORCE_GDPR_APPLIES = "force_gdpr_applies";
    private static final String KEY_CONSENT_STATUS = "current_consent_status";

    public AdUrlGenerator(String host, String path) {
        super(host, path);
    }

    public AdUrlGenerator withAdUnitId(String adUnitId) {
        this.addParam(KEY_AD_UNIT_ID, adUnitId);
        return this;
    }

    public AdUrlGenerator withBundleId(String bundleId) {
        this.addParam(KEY_BUNDLE, bundleId);
        return this;
    }

    public AdUrlGenerator withIDFA(String idfa) {
        this.addParam(KEY_IDFA, idfa);
        return this;
    }

    public AdUrlGenerator withIDFAType(String idfaType) {
        this.addParam(KEY_IDFA_TYPE, idfaType);
        return this;
    }

    public AdUrlGenerator withLATEnabled(Boolean latEnabled) {
        this.addParam(KEY_LIMIT_AD_TRACKING, latEnabled != false ? "1" : "0");
        return this;
    }

    public AdUrlGenerator withLocale(String locale) {
        this.addParam(KEY_LOCALE, locale);
        return this;
    }

    public AdUrlGenerator withLocale() {
        return this.withLocale(Locale.getDefault().toString());
    }

    public AdUrlGenerator withSDKVersion(String sdkVersion) {
        this.addParam(KEY_SDK_VERSION, sdkVersion);
        return this;
    }

    public AdUrlGenerator withSDKVersion() {
        return this.withSDKVersion("1.0.0-rc4");
    }

    public AdUrlGenerator withConnectionType(String connectionType) {
        this.addParam(KEY_CONNECTION_TYPE, connectionType);
        return this;
    }

    public AdUrlGenerator withCountry(String country) {
        this.addParam(KEY_COUNTRY, country);
        return this;
    }

    public AdUrlGenerator withOperatorId(String operatorId) {
        this.addParam(KEY_OPERATOR_ID, operatorId);
        return this;
    }

    public AdUrlGenerator withOperatorName(String operatorName) {
        this.addParam(KEY_OPERATOR_NAME, operatorName);
        return this;
    }

    public AdUrlGenerator withAdUnitWidth(String adUnitWidth) {
        this.addParam(KEY_AD_UNIT_WIDTH, adUnitWidth);
        return this;
    }

    public AdUrlGenerator withAdUnitHeight(String adUnitHeight) {
        this.addParam(KEY_AD_UNIT_HEIGHT, adUnitHeight);
        return this;
    }

    public AdUrlGenerator withGDPRApplies(boolean gdprApplies) {
        this.addParam(KEY_GDPR_APPLIES, gdprApplies ? "1" : "0");
        return this;
    }

    public AdUrlGenerator withGDPRApplies() {
        return this.withGDPRApplies(Appier.getGDPRApplies());
    }

    public AdUrlGenerator withForceGDPRApplies(boolean forceGDPRApplies) {
        this.addParam(KEY_FORCE_GDPR_APPLIES, forceGDPRApplies ? "1" : "0");
        return this;
    }

    public AdUrlGenerator withForceGDPRApplies() {
        return this.withForceGDPRApplies(Appier.getForceGDPRApplies());
    }

    public AdUrlGenerator withConsentStatus(String consentStatus) {
        this.addParam(KEY_CONSENT_STATUS, consentStatus);
        return this;
    }

    public AdUrlGenerator withConsentStatus() {
        return this.withConsentStatus(Appier.getConsentStatus().getValue());
    }
}

