/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.appier.ads.Appier;
import com.appier.ads.AppierBaseAd;
import com.appier.ads.AppierError;
import com.appier.ads.AppierInterstitialView;
import com.appier.ads.InterstitialActivity;
import com.appier.ads.common.BaseWebView;
import com.appier.ads.common.HtmlWebViewClient;
import com.appier.ads.common.Identifier;
import com.appier.ads.common.ObjectWrapperForBinder;
import com.appier.ads.network.Network;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AppierInterstitialAd
extends AppierBaseAd
implements AppierBaseAd.BaseAdEventListener {
    private static final String LOG_TAG = "AppierMediation";
    private Context mContext;
    private EventListener mEventListener;
    private AppierInterstitialView mAppierInterstitialView;
    private String mZoneId;
    private int mAdWidth;
    private int mAdHeight;
    private String mFailingUrl;

    public AppierInterstitialAd(Context context, EventListener eventListener) {
        super(context);
        this.setBaseAdEventListener(this);
        this.mContext = context;
        this.mEventListener = eventListener;
        this.mAppierInterstitialView = new AppierInterstitialView(context, new AppierInterstitialViewListener());
        HtmlWebViewClient htmlWebViewClient = new HtmlWebViewClient(new HtmlWebViewListener(), this.mAppierInterstitialView);
        this.mAppierInterstitialView.setWebViewClient(htmlWebViewClient);
    }

    public void loadAd(String zoneId) {
        this.mZoneId = zoneId;
        super.loadAd();
    }

    public void showAd() {
        Bundle bundle = new Bundle();
        bundle.putBinder("INTERSTITIAL_BUNDLE_BINDER", (IBinder)new ObjectWrapperForBinder((Object)this.mAppierInterstitialView));
        Intent intent = new Intent(this.mContext, InterstitialActivity.class);
        intent.putExtra("INTERSTITIAL_INTENT_EXTRA_BUNDLE", bundle);
        this.mContext.startActivity(intent);
    }

    @Override
    public String getAdUri() {
        String networkHost = this.getNetworkHost();
        String adPath = this.getAdPath();
        Identifier identifier = this.getIdentifier();
        AdvertisingIdClient.Info adInfo = this.getAdInfo();
        boolean isLATEnabled = adInfo == null || adInfo.isLimitAdTrackingEnabled();
        Uri adUri = Uri.parse((String)(networkHost + adPath)).buildUpon().appendQueryParameter("zoneid", this.mZoneId).appendQueryParameter("bundle", this.getContext().getPackageName()).appendQueryParameter("ia", isLATEnabled ? "" : adInfo.getId()).appendQueryParameter("type", "adid").appendQueryParameter("lat", isLATEnabled ? "1" : "0").appendQueryParameter("locale", Locale.getDefault().toString()).appendQueryParameter("sdk_version", "1.0.0-rc3").appendQueryParameter("conntype", Network.getType(this.getContext()).toString()).appendQueryParameter("country", identifier.getTelCountry()).appendQueryParameter("operator", identifier.getTelNetworkOperator()).appendQueryParameter("operator_name", identifier.getTelNetworkOperatorName()).appendQueryParameter("w", Integer.toString(this.mAdWidth)).appendQueryParameter("h", Integer.toString(this.mAdHeight)).appendQueryParameter("gdpr_applies", Appier.getGDPRApplies() ? "1" : "0").appendQueryParameter("force_gdpr_applies", Appier.getForceGDPRApplies() ? "1" : "0").appendQueryParameter("current_consent_status", Appier.getConsentStatus().getValue()).build();
        return adUri.toString();
    }

    public void setAdDimension(int adWidth, int adHeight) {
        this.mAdWidth = adWidth;
        this.mAdHeight = adHeight;
        this.mAppierInterstitialView.setDpDimension(this.mAdWidth, this.mAdHeight);
    }

    private JSONObject getAd() throws JSONException {
        return this.getAdJSON().getJSONArray("adUnits").getJSONObject(0).getJSONObject("ad");
    }

    public String getCreative() throws JSONException {
        return this.getAd().getString("content");
    }

    public String getFailingUrl() {
        return this.mFailingUrl;
    }

    public void destroy() {
        if (this.mAppierInterstitialView != null) {
            this.mAppierInterstitialView.destroy();
            this.mAppierInterstitialView = null;
        }
    }

    @Override
    public void onBaseAdLoaded(AppierBaseAd ad, boolean isNoBid) {
        Log.d((String)LOG_TAG, (String)("[Appier SDK] AppierInterstitialAd.onBaseAdLoaded(), isNoBid = " + isNoBid));
        if (isNoBid) {
            this.mEventListener.onAdNoBid(this);
        } else {
            try {
                this.mAppierInterstitialView.loadCreative(this.getCreative());
            }
            catch (JSONException e) {
                this.mEventListener.onAdLoadFail(AppierError.INVALID_JSON, this);
            }
            catch (Exception e) {
                this.mEventListener.onAdLoadFail(AppierError.UNKNOWN_ERROR, this);
            }
        }
    }

    @Override
    public void onBaseAdLoadFail(AppierError appierError) {
        Log.d((String)LOG_TAG, (String)("[Appier SDK] AppierInterstitialAd.onBaseAdLoadFail(): " + appierError.toString()));
        this.mEventListener.onAdLoadFail(appierError, this);
    }

    public static interface EventListener {
        public void onAdLoaded(AppierInterstitialAd var1);

        public void onAdNoBid(AppierInterstitialAd var1);

        public void onAdLoadFail(AppierError var1, AppierInterstitialAd var2);

        public void onViewShown(AppierInterstitialAd var1);

        public void onDismiss(AppierInterstitialAd var1);
    }

    private class AppierInterstitialViewListener
    implements AppierInterstitialView.EventListener {
        private AppierInterstitialViewListener() {
        }

        @Override
        public void onShown() {
            AppierInterstitialAd.this.mEventListener.onViewShown(AppierInterstitialAd.this);
        }

        @Override
        public void onDismiss() {
            AppierInterstitialAd.this.mEventListener.onDismiss(AppierInterstitialAd.this);
        }
    }

    private class HtmlWebViewListener
    implements HtmlWebViewClient.EventListener {
        private HtmlWebViewListener() {
        }

        @Override
        public void onLoaded(BaseWebView mHtmlWebView) {
            AppierInterstitialAd.this.mEventListener.onAdLoaded(AppierInterstitialAd.this);
        }

        @Override
        public void onFailed(AppierError appierError, String failingUrl) {
            AppierInterstitialAd.this.mFailingUrl = failingUrl;
            AppierInterstitialAd.this.mEventListener.onAdLoadFail(appierError, AppierInterstitialAd.this);
        }
    }
}

